/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.CompositeParseException;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.CompositeParsedObject;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.COMPOSITE, isStructural=false, rootModules={"Services"})
public final class CompositeTypeLoader
extends AbstractTypeLoader<CompositeInfo> {
    private static final URI compositeErrorUri = URI.create("composite.xml/");

    public CompositeTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ParsedObject<CompositeInfo> parseUri(@NotNull URI uri) throws TypeParseException {
        CompositeInfo compositeInfo;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.parseUri must not be null");
        }
        try {
            compositeInfo = this.compositeAccessor.parseComposite();
        }
        catch (CompositeAccessorException e) {
            throw new CompositeParseException(e);
        }
        CompositeParsedObject compositeParsedObject = new CompositeParsedObject(uri, compositeInfo);
        if (compositeParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.parseUri must not return null");
        }
        return compositeParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<CompositeInfo> parsedObject) {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.loadTypes must not be null");
        }
        HashMap<String, TypeDescription> hashMap = new HashMap<String, TypeDescription>();
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected URI buildErrorURI(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.buildErrorURI must not be null");
        }
        assert (compositeErrorUri != null);
        URI uRI = compositeErrorUri;
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeTypeLoader.buildErrorURI must not return null");
        }
        return uRI;
    }
}

