/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TArgumentList;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.BusinessRuleParseException;
import oracle.bpm.project.catalog.loaders.BusinessRuleTypeBuildException;
import oracle.bpm.project.catalog.loaders.MdsDictionaryFinder;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.VFileSystemDictionaryFinder;
import oracle.bpm.project.catalog.loaders.impl.RuleDictionaryParsedObject;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.util.Identifier;
import oracle.rules.sdk2.datamodel.CombinedDataModel;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.datamodel.DecisionFunctionFact;
import oracle.rules.sdk2.datamodel.DecisionFunctionFactTable;
import oracle.rules.sdk2.datamodel.FactType;
import oracle.rules.sdk2.datamodel.JaxbFactType;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.dictionary.DOID;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TypeLoaderMetadata(resourceType=ResourceType.BUSINESS_RULE, isStructural=false, rootModules={"Rules"})
public final class BusinessRuleTypeLoader
extends AbstractTypeLoader<RuleDictionary> {
    private static final String OUT_ARG_NAME_SUFIX = "Out";
    private static final String XML_ELEMENT_TOKEN = "//xs:element";
    private static final String XML_COMPLEXTYPE_TOKEN = "//xs:complexType";
    private static final String XML_ELEMENT_TOKEN_OLD = ".//xs:element";
    private static final String XML_COMPLEXTYPE_TOKEN_OLD = ".//xs:complexType";
    private static final Map<String, TypeDescription> typeMatching = new HashMap<String, TypeDescription>();

    public BusinessRuleTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ParsedObject<RuleDictionary> parseUri(@NotNull URI uri) throws TypeParseException {
        RuleDictionaryParsedObject parsedObject;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.parseUri must not be null");
        }
        InputStream inputStream = null;
        try {
            inputStream = URLHelper.openStream((URI)uri);
            DecisionPointDictionaryFinder pointDictionaryFinder = new DecisionPointDictionaryFinder();
            VFileSystemDictionaryFinder vFileSystemDictionaryFinder = new VFileSystemDictionaryFinder((DictionaryFinder)pointDictionaryFinder, this.getFileSystem());
            MdsDictionaryFinder mdsRulesDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)vFileSystemDictionaryFinder, "rules");
            MdsDictionaryFinder mdsMediatorDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)mdsRulesDictionaryFinder, "mediator/oracle/rules");
            MdsDictionaryFinder mdsCasemgmtDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)mdsMediatorDictionaryFinder, "casemgmt/oracle/rules");
            RuleDictionary rd = RuleDictionary.readDictionary((Reader)new InputStreamReader(inputStream, "UTF-8"), (DictionaryFinder)mdsCasemgmtDictionaryFinder);
            parsedObject = new RuleDictionaryParsedObject(uri, rd);
        }
        catch (SDKException e) {
            try {
                throw new BusinessRuleParseException(uri, e);
                catch (IOException e2) {
                    throw new BusinessRuleParseException(uri, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        RuleDictionaryParsedObject ruleDictionaryParsedObject = parsedObject;
        if (ruleDictionaryParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.parseUri must not return null");
        }
        return ruleDictionaryParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.loadTypes must not be null");
        }
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        RuleDictionary ruleDictionary = (RuleDictionary)parsedObject.getParsedData();
        String ruleName = ruleDictionary.getName();
        String ruleDescription = ruleDictionary.getDescription();
        ObjectTypeDescription td = new ObjectTypeDescription(Identifier.classname((String)ruleName));
        td.setComponentType(ComponentType.BUSINESS_RULE.getText());
        td.setDescription(ruleDescription);
        td.setProperty("nativeName", ruleName);
        this.addMethods(parsedObject.getUri(), ruleDictionary, td);
        String rulesPackage = ruleDictionary.getPackage();
        rulesPackage = XmlUtils.buildValidQualifiedModuleName((String)rulesPackage);
        rulesPackage = !Str.isEmpty((String)rulesPackage) ? "." + rulesPackage : "";
        String typeName = "Rules" + rulesPackage + "." + td.getName();
        result.put(typeName, (TypeDescription)td);
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    private void addMethods(@NotNull URI uri, @NotNull RuleDictionary ruleDictionary, @NotNull ObjectTypeDescription td) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.addMethods must not be null");
        }
        if (ruleDictionary == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.addMethods must not be null");
        }
        if (td == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.addMethods must not be null");
        }
        Map<String, TDecisionService> decisionServicesByRule = this.loadDecisionByRule(uri);
        CombinedDataModel dataModel = ruleDictionary.getCombinedDataModel();
        List functions = dataModel.getDecisionFunctions();
        for (DecisionFunction decFunction : functions) {
            if (!decFunction.isWebService()) continue;
            MethodTypeDescription method = this.buildMethod(uri, decisionServicesByRule, decFunction.getCombinedDataModel(), decFunction);
            td.addMember(method);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private MethodTypeDescription buildMethod(@NotNull URI uri, @NotNull Map<String, TDecisionService> decisionServicesByRule, @NotNull CombinedDataModel combinedDataModel, @NotNull DecisionFunction decFunction) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.buildMethod must not be null");
        }
        if (decisionServicesByRule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.buildMethod must not be null");
        }
        if (combinedDataModel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.buildMethod must not be null");
        }
        if (decFunction == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.buildMethod must not be null");
        }
        String decFunctionName = decFunction.getName();
        String description = decFunction.getDescription();
        TDecisionService service = decisionServicesByRule.get(decFunction.getFullyQualifiedName());
        MethodTypeDescription result = new MethodTypeDescription(decFunctionName);
        result.setDescription(description);
        result.addModifiers(64L);
        result.setTransientProperty("nativeName", (Object)decFunctionName);
        if (service != null) {
            result.setTransientProperty("namespace", (Object)service.getTargetNamespace());
            result.setTransientProperty("target", (Object)service.getCatalog());
            result.setTransientProperty("target.port", (Object)service.getName());
        }
        DecisionFunctionFactTable decisionFunctionInputTable = decFunction.getDecisionFunctionInputTable();
        for (DecisionFunctionFact decFunctionFact : decisionFunctionInputTable) {
            String argName = Identifier.argument((String)decFunctionFact.getName());
            try {
                Argument arg = this.createArgument(uri, decFunctionName, argName, combinedDataModel, decFunctionFact, 1L);
                result.addArgument(arg);
            }
            catch (SDKException sdke) {
                throw new BusinessRuleTypeBuildException(uri, decFunctionName, argName, sdke.getMessage());
            }
        }
        DecisionFunctionFactTable decisionFunctionOutputTable = decFunction.getDecisionFunctionOutputTable();
        for (DecisionFunctionFact decFunctionFact : decisionFunctionOutputTable) {
            String argName = Identifier.argument((String)decFunctionFact.getName());
            if (result.findArgument(argName) != null) {
                argName = argName + OUT_ARG_NAME_SUFIX;
            }
            try {
                Argument arg = this.createArgument(uri, decFunctionName, argName, combinedDataModel, decFunctionFact, 2L);
                result.addArgument(arg);
            }
            catch (SDKException sdke) {
                throw new BusinessRuleTypeBuildException(uri, decFunctionName, argName, sdke.getMessage());
            }
        }
        MethodTypeDescription methodTypeDescription = result;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.buildMethod must not return null");
        }
        return methodTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Map<String, TDecisionService> loadDecisionByRule(@NotNull URI uri) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.loadDecisionByRule must not be null");
        }
        HashMap<String, TDecisionService> result = new HashMap<String, TDecisionService>();
        VFile vfile = this.uriToVFile(uri);
        DecisionServices services = this.loadDecisionServices(vfile);
        if (services != null) {
            for (TDecisionService decisionService : services.getDecisionServices()) {
                List patterns = decisionService.getPatterns();
                for (TPattern pattern : patterns) {
                    TArgumentList arguments = pattern.getArguments();
                    String ruleName = arguments.getCall();
                    result.put(ruleName, decisionService);
                }
            }
        }
        HashMap<String, TDecisionService> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.loadDecisionByRule must not return null");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private DecisionServices loadDecisionServices(@NotNull VFile rulesFile) {
        if (rulesFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.loadDecisionServices must not be null");
        }
        DecisionServices services = null;
        VFileSystem fs = rulesFile.getFileSystem();
        VFile decVFile = VFileUtils.changeExtension((VFile)fs.createFile(rulesFile.getName()), (String)".decs");
        BufferedInputStream is = null;
        try {
            if (decVFile.exists()) {
                RuleEngineFactory factory = RuleEngineFactory.getInstance();
                Unmarshaller unmarshaller = factory.createUnmarshaller();
                is = new BufferedInputStream((InputStream)new VFileInputStream(decVFile));
                services = (DecisionServices)unmarshaller.unmarshal((InputStream)is);
            }
            if (is == null) return services;
        }
        catch (IOException e) {
            if (is == null) return services;
            StreamUtils.close((Closeable[])new Closeable[]{is});
            return services;
        }
        catch (JAXBException e2) {
            if (is == null) return services;
            StreamUtils.close((Closeable[])new Closeable[]{is});
            return services;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    StreamUtils.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{is});
        return services;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Argument createArgument(@NotNull URI uri, @NotNull String decFunctionName, @NotNull String argName, @NotNull CombinedDataModel combinedDataModel, @NotNull DecisionFunctionFact decFunctionFact, long modifiers) throws TypeBuildException, SDKException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not be null");
        }
        if (decFunctionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not be null");
        }
        if (argName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not be null");
        }
        if (combinedDataModel == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not be null");
        }
        if (decFunctionFact == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not be null");
        }
        TypeRef ref = this.factTypeToTypeRef(uri, decFunctionName, argName, combinedDataModel, decFunctionFact);
        String nativeName = decFunctionFact.getName();
        Argument argument = new Argument(argName, ref, modifiers);
        argument.setProperty("nativeName", nativeName);
        Argument argument2 = argument;
        if (argument2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.createArgument must not return null");
        }
        return argument2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeRef factTypeToTypeRef(@NotNull URI uri, @NotNull String decFunctionName, @NotNull String argName, @NotNull CombinedDataModel combinedDataModel, @NotNull DecisionFunctionFact decFunctionFact) throws TypeBuildException, SDKException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not be null");
        }
        if (decFunctionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not be null");
        }
        if (argName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not be null");
        }
        if (combinedDataModel == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not be null");
        }
        if (decFunctionFact == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not be null");
        }
        TypeRef result = this.buildSimpleType(decFunctionFact);
        if (result == null) {
            result = this.buildJaxbType(uri, decFunctionName, argName, combinedDataModel, decFunctionFact);
        }
        if (result == null) {
            throw new BusinessRuleTypeBuildException(uri, decFunctionName, argName, ProjectCatalogMsg.CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME(decFunctionFact.getType()));
        }
        TypeRef typeRef = result;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.factTypeToTypeRef must not return null");
        }
        return typeRef;
    }

    private TypeRef buildSimpleType(DecisionFunctionFact decFunctionFact) {
        TypeDescription result = TypeMappings.getType((String)decFunctionFact.getTypeID().getJavaClassName());
        if (result == null) {
            result = (TypeRef)typeMatching.get(decFunctionFact.getTypeID().getJavaClassName());
        }
        return result;
    }

    private TypeRef buildJaxbType(URI uri, String decFunctionName, String argName, CombinedDataModel combinedDataModel, DecisionFunctionFact decFunctionFact) throws BusinessRuleTypeBuildException {
        QName qname = this.getDecisionFunctionFactQName(combinedDataModel, decFunctionFact);
        if (qname == null) {
            throw new BusinessRuleTypeBuildException(uri, decFunctionName, argName, ProjectCatalogMsg.CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME(decFunctionFact.getType()));
        }
        String namespace = qname.getNamespaceURI();
        String nativeName = qname.getLocalPart();
        String uniqueId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)namespace, (String)nativeName).getId();
        String name = Identifier.classname((String)nativeName);
        ComponentCatalog catalog = this.getCatalog();
        BpmObjectDynamicRef result = new BpmObjectDynamicRef(uniqueId, name, catalog);
        if (decFunctionFact.isList()) {
            result = TypeFactory.createArray((TypeRef)result);
        }
        return result;
    }

    @Nullable
    private QName getDecisionFunctionFactQName(@NotNull CombinedDataModel combinedDataModel, @NotNull DecisionFunctionFact decFunctionFact) {
        if (combinedDataModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.getDecisionFunctionFactQName must not be null");
        }
        if (decFunctionFact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.getDecisionFunctionFactQName must not be null");
        }
        DOID id = decFunctionFact.getTypeID();
        FactType factType = this.findFactType(id, combinedDataModel);
        if (factType != null && factType.isJaxb()) {
            SortedSet elementSet;
            String xmlComplexTypeToken;
            String xmlElementToken;
            JaxbFactType xmlFact = (JaxbFactType)factType;
            if (xmlFact.isJAXB2()) {
                xmlElementToken = XML_ELEMENT_TOKEN;
                xmlComplexTypeToken = XML_COMPLEXTYPE_TOKEN;
            } else {
                xmlElementToken = XML_ELEMENT_TOKEN_OLD;
                xmlComplexTypeToken = XML_COMPLEXTYPE_TOKEN_OLD;
            }
            String matchString = xmlElementToken + "[@name='" + xmlFact.getNodeName() + "']";
            if (matchString.equals(xmlFact.getXMLName())) {
                return xmlFact.getQName();
            }
            matchString = xmlComplexTypeToken + "[@name='" + xmlFact.getNodeName() + "']";
            if (matchString.equals(xmlFact.getXMLName()) && (elementSet = this.typeFinder.findByPropertyValue("element.type.id", UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)xmlFact.getNamespace(), (String)xmlFact.getNodeName()).getId())) != null && elementSet.size() == 1) {
                QName result = new QName(xmlFact.getNamespace(), ((TypeRef)elementSet.first()).get().asSchemaObject().getName());
                return result;
            }
        }
        return null;
    }

    @Nullable
    private FactType findFactType(@NotNull DOID id, @NotNull CombinedDataModel combinedDataModel) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.findFactType must not be null");
        }
        if (combinedDataModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BusinessRuleTypeLoader.findFactType must not be null");
        }
        for (FactType factType : combinedDataModel.getFactTypes()) {
            if (!id.equals((Object)factType.getID())) continue;
            return factType;
        }
        return null;
    }

    static {
        typeMatching.put("java.math.BigInteger", TypeFactory.getInt((int)64));
        typeMatching.put("javax.xml.datatype.XMLGregorianCalendar", TypeFactory.getTime());
        typeMatching.put("javax.xml.datatype.Duration", TypeFactory.getInterval());
    }
}

