/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Tuple;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.lang.WebFormTypeDescription;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.ResourceTypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.WebFormData;
import oracle.bpm.project.catalog.loaders.WebFormParsedObject;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.utils.XmlSchemaToTypeRef;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.impl.TypeErrorImpl;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TypeLoaderMetadata(resourceType=ResourceType.WEB_FORM, isStructural=false)
public class WebFormTypeLoader
extends AbstractTypeLoader<WebFormData> {
    private static final String METHOD_NAME = "invoke";

    public WebFormTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
        this.typeFinder = typeFinder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected ParsedObject<WebFormData> parseUri(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.parseUri must not be null");
        }
        WebFormParsedObject webFormParsedObject = new WebFormParsedObject(uri, this.getFileSystem());
        if (webFormParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.parseUri must not return null");
        }
        return webFormParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<WebFormData> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.loadTypes must not be null");
        }
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>(1);
        try {
            TypeDescription type = this.buildWebFormType(parsedObject);
            result.put("Ext.Forms." + parsedObject.getParsedData().getName(), type);
        }
        catch (TypeParseException e) {
            this.wrapException(parsedObject, (Exception)((Object)e));
        }
        catch (XPathExpressionException e) {
            this.wrapException(parsedObject, e);
        }
        catch (URISyntaxException e) {
            this.wrapException(parsedObject, e);
        }
        catch (IOException e) {
            this.wrapException(parsedObject, e);
        }
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    private void wrapException(@NotNull ParsedObject<WebFormData> parsedObject, Exception e) throws ResourceTypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.wrapException must not be null");
        }
        throw new ResourceTypeBuildException(parsedObject.getUri(), (TypeError)TypeErrorImpl.create((ErrorMsg)ProjectCatalogMsg.UNEXPECTED_TYPEBUILD_ERROR(parsedObject.getUri().getPath(), e.getMessage()), (Exception)e));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription buildWebFormType(@NotNull ParsedObject<WebFormData> parsedObject) throws TypeParseException, TypeBuildException, XPathExpressionException, IOException, URISyntaxException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildWebFormType must not be null");
        }
        MethodTypeDescription invoke = this.buildInvokeMethod(parsedObject);
        String formName = parsedObject.getParsedData().getName();
        WebFormTypeDescription result = new WebFormTypeDescription(formName);
        result.addMember(invoke);
        WebFormTypeDescription webFormTypeDescription = result;
        if (webFormTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildWebFormType must not return null");
        }
        return webFormTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Argument buildArgument(@NotNull TypeRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgument must not be null");
        }
        Argument argument = new Argument(ref.getName(), ref, 1L);
        if (argument == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgument must not return null");
        }
        return argument;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Argument buildArgument(@NotNull String name, @NotNull TypeRef ref) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgument must not be null");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgument must not be null");
        }
        Argument argument = new Argument(name, ref, 1L);
        if (argument == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgument must not return null");
        }
        return argument;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String getDependencyName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.getDependencyName must not be null");
        }
        String string = path.substring(path.lastIndexOf("/") + 1, path.length() - ".xsd".length());
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.getDependencyName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Argument buildArgumentFromType(@NotNull String name, @NotNull TypeRef typeRef) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgumentFromType must not be null");
        }
        if (typeRef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgumentFromType must not be null");
        }
        Argument argument = new Argument(name, typeRef, 1L);
        argument.setProperty("nativeName", name);
        Argument argument2 = argument;
        if (argument2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgumentFromType must not return null");
        }
        return argument2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private MethodTypeDescription buildInvokeMethod(@NotNull ParsedObject<WebFormData> parsedObject) throws XPathExpressionException, TypeParseException, TypeBuildException, IOException, URISyntaxException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildInvokeMethod must not be null");
        }
        MethodTypeDescription result = new MethodTypeDescription(METHOD_NAME);
        WebFormData parsedData = parsedObject.getParsedData();
        if (parsedObject.getParsedData().getDependencyDom() != null) {
            List<Argument> arguments = this.buildArguments(parsedObject);
            for (Argument argument : arguments) {
                result.addArgument(argument, true);
            }
        }
        MethodTypeDescription methodTypeDescription = result;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildInvokeMethod must not return null");
        }
        return methodTypeDescription;
    }

    private List<Argument> buildArguments(@NotNull ParsedObject<WebFormData> parsedObject) {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArguments must not be null");
        }
        WebFormData parsedData = parsedObject.getParsedData();
        List<Argument> result = parsedData.isFromScratch() ? this.buildArgumentsFromScratch(parsedObject) : this.buildArgumentsFromExternal(parsedObject);
        return result;
    }

    private List<Argument> buildArgumentsFromExternal(@NotNull ParsedObject<WebFormData> parsedObject) {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgumentsFromExternal must not be null");
        }
        ArrayList<Argument> result = new ArrayList<Argument>();
        Document dependencyDom = parsedObject.getParsedData().getDependencyDom();
        assert (dependencyDom != null);
        List<Element> types = XmlSchemaToTypeRef.getFirstLevelElements(dependencyDom);
        assert (types.size() == 1);
        Element type = (Element)CollectionUtils.first(types);
        assert (type != null);
        List<Tuple<String, TypeRef>> children = XmlSchemaToTypeRef.getSecondLevelElementRefs(type, this.getCatalog());
        for (Tuple<String, TypeRef> child : children) {
            result.add(this.buildArgument((String)child.getFirst(), (TypeRef)child.getSecond()));
        }
        return result;
    }

    private List<Argument> buildArgumentsFromScratch(@NotNull ParsedObject<WebFormData> parsedObject) {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormTypeLoader.buildArgumentsFromScratch must not be null");
        }
        ArrayList<Argument> result = new ArrayList<Argument>();
        Document dependencyDom = parsedObject.getParsedData().getDependencyDom();
        assert (dependencyDom != null);
        List<Tuple<String, TypeRef>> definedElements = XmlSchemaToTypeRef.getDefinedElementRefs(dependencyDom, this.getCatalog());
        assert (definedElements.size() == 1);
        Tuple tuple = (Tuple)CollectionUtils.first(definedElements);
        assert (tuple != null);
        result.add(this.buildArgument((String)tuple.getFirst(), (TypeRef)tuple.getSecond()));
        return result;
    }
}

