/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.xmlparser.TypeErrorExceptionInterface;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.impl.TypeErrorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class TypeParseException
extends DefaultException
implements TypeErrorExceptionInterface {
    private TypeError typeError;
    private static final long serialVersionUID = 3700451423240723833L;

    public TypeParseException(@NotNull URL url, @NotNull IOException cause) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URL)url), (Exception)cause);
    }

    public TypeParseException(@NotNull URI uri, @NotNull IOException cause) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URI)uri), (Exception)cause);
    }

    public TypeParseException(@NotNull URL url, @NotNull SAXException cause) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URL)url), (Exception)cause);
    }

    public TypeParseException(@NotNull URL url, @NotNull URISyntaxException cause) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URL)url), (Exception)cause);
    }

    public TypeParseException(@NotNull URI uri, @NotNull URISyntaxException cause) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URI)uri), (Exception)cause);
    }

    public TypeParseException(@NotNull URI uri, @NotNull XPathExpressionException e) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URI)uri), (Exception)e);
    }

    public TypeParseException(@NotNull URI uri, @NotNull SAXException e) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URI)uri), (Exception)e);
    }

    public TypeParseException(@NotNull URI uri, @NotNull ParserConfigurationException e) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(URLHelper.getResourceLocation((URI)uri), (Exception)e);
    }

    protected TypeParseException(@NotNull ErrorMsg msg, @Nullable Exception cause) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(msg, cause, (TypeError)TypeErrorImpl.create((ErrorMsg)msg, (Exception)cause));
    }

    protected TypeParseException(@NotNull ErrorMsg msg, @Nullable Exception cause, @NotNull TypeError typeError) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (typeError == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        super((Msg)msg, (Throwable)cause);
        this.typeError = typeError;
    }

    private TypeParseException(@NotNull String path, @NotNull Exception cause) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.<init> must not be null");
        }
        this(ProjectCatalogMsg.UNEXPECTED_PARSER_ERROR(path, cause.getMessage()), cause);
    }

    public static TypeParseException wrap(@NotNull TypeBuildException exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeParseException.wrap must not be null");
        }
        TypeError error = exception.getTypeError();
        return new TypeParseException(error.longDesc(), (Exception)((Object)exception), error);
    }

    @Override
    public TypeError getTypeError() {
        return this.typeError;
    }
}

