/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.correlation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.project.catalog.correlation.PropertiesManager;
import oracle.bpm.project.catalog.correlation.Property;
import oracle.bpm.project.catalog.correlation.PropertyAlias;

public class ResourcePropertiesManager {
    final Map<URI, PropertiesManager> managerByUri = new HashMap<URI, PropertiesManager>();

    public void setProperties(URI uri, Set<Property> properties) {
        if (properties != null) {
            PropertiesManager propertyManager = this.getPropertiesManagerByUri(uri);
            propertyManager.setProperties(properties);
            this.managerByUri.put(uri, propertyManager);
        }
    }

    public void setPropertyAliases(URI uri, Set<PropertyAlias> propertyAliases) {
        PropertiesManager propertyManager = this.getPropertiesManagerByUri(uri);
        propertyManager.setPropertyAliases(propertyAliases);
        this.managerByUri.put(uri, propertyManager);
    }

    public List<Property> getProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (PropertiesManager list : this.managerByUri.values()) {
            result.addAll(list.getProperties());
        }
        return result;
    }

    public Collection<Property> getPropertiesByUri(URI uri) {
        PropertiesManager propertyManager = this.managerByUri.get(uri);
        if (propertyManager != null) {
            return Collections.unmodifiableCollection(propertyManager.getProperties());
        }
        return Collections.emptyList();
    }

    public Collection<PropertyAlias> getPropertyAliasesByUri(URI uri) {
        PropertiesManager propertyManager = this.managerByUri.get(uri);
        if (propertyManager != null) {
            return Collections.unmodifiableCollection(propertyManager.getPropertyAliases());
        }
        return Collections.emptyList();
    }

    public List<PropertyAlias> getPropertyAliases() {
        ArrayList<PropertyAlias> result = new ArrayList<PropertyAlias>();
        for (PropertiesManager list : this.managerByUri.values()) {
            result.addAll(list.getPropertyAliases());
        }
        return result;
    }

    public void remove(URI uri) {
        this.managerByUri.remove(uri);
    }

    public void clear() {
        this.managerByUri.clear();
    }

    public Property findProperty(QName name) {
        PropertiesManager manager;
        Property property = null;
        Iterator<PropertiesManager> i$ = this.managerByUri.values().iterator();
        while (i$.hasNext() && (property = (manager = i$.next()).findProperty(name)) == null) {
        }
        return property;
    }

    private PropertiesManager getPropertiesManagerByUri(URI uri) {
        PropertiesManager propertyManager = this.managerByUri.get(uri);
        if (propertyManager == null) {
            propertyManager = new PropertiesManager();
        }
        return propertyManager;
    }
}

