/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.correlation;

import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyAliasSetId {
    private XmlElementType elementType;
    private String part;
    private final QName qname;
    private static final String INITIATE_TASK_MESSAGE = "initiateTaskMessage";
    private static final String TASK_RESPONSE_MESSAGE = "taskMessage";
    private static final String PAYLOAD = "payload";

    private PropertyAliasSetId(XmlElementType type, QName qname) {
        this(type, qname, null);
    }

    private PropertyAliasSetId(XmlElementType type, QName qname, String part) {
        this.elementType = type;
        this.qname = qname;
        this.part = part;
    }

    public static PropertyAliasSetId createInputId(Activity activity, String argument) {
        assert (activity.isConversationMember());
        return PropertyAliasSetId.createInputId((CorrelationsEnabled)((Object)activity), argument);
    }

    public static PropertyAliasSetId createInputId(Activity activity) {
        return PropertyAliasSetId.createInputId(activity, null);
    }

    public static PropertyAliasSetId createInputId(CorrelationsEnabled node, String argument) {
        return PropertyAliasSetId.create(node, true, argument);
    }

    public static PropertyAliasSetId createInputId(CorrelationsEnabled node) {
        return PropertyAliasSetId.createInputId(node, null);
    }

    public static PropertyAliasSetId createOutputId(Activity activity, String argument) {
        return PropertyAliasSetId.createOutputId((CorrelationsEnabled)((Object)activity), argument);
    }

    public static PropertyAliasSetId createOutputId(Activity activity) {
        return PropertyAliasSetId.createOutputId(activity, null);
    }

    public static PropertyAliasSetId createOutputId(CorrelationsEnabled node, String argument) {
        return PropertyAliasSetId.create(node, false, argument);
    }

    public static PropertyAliasSetId createOutputId(CorrelationsEnabled node) {
        return PropertyAliasSetId.createOutputId(node, null);
    }

    @Nullable
    public static PropertyAliasSetId create(CorrelationsEnabled node, boolean input) {
        return PropertyAliasSetId.create(node, input, null);
    }

    @Nullable
    public static PropertyAliasSetId create(CorrelationsEnabled node, boolean input, String argumentName) {
        UserTask userTask;
        Event event;
        PropertyAliasSetId result = null;
        if (node.isEvent() && (event = node.asAnyNode(Event.class)).getEventTriggerType() == EventTriggerType.SIGNAL) {
            result = PropertyAliasSetId.create(event);
        }
        if (result == null && node.isActivity() && node.isActivity() && (userTask = node.asAnyNode(UserTask.class)) != null) {
            String msgName = input ? INITIATE_TASK_MESSAGE : TASK_RESPONSE_MESSAGE;
            QName initiateTaskMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", msgName);
            result = new PropertyAliasSetId(XmlElementType.MESSAGE, initiateTaskMessage, PAYLOAD);
        }
        if (result == null) {
            QName msg;
            assert (node.isConversational());
            Conversational conversational = node.asAnyNode(Conversational.class);
            OperationReferenceImpl wrapper = new OperationReferenceImpl(conversational);
            String partName = PropertyAliasSetId.findParamName(conversational, argumentName);
            if (CatchEvent.class.isAssignableFrom(node.getRawClass()) || ReceiveTask.class.isAssignableFrom(node.getRawClass())) {
                input = !input;
            }
            QName qName = msg = input ? wrapper.getInputType() : wrapper.getOutputType();
            if (msg != null) {
                result = new PropertyAliasSetId(XmlElementType.MESSAGE, msg, partName);
            }
        }
        return result;
    }

    public static PropertyAliasSetId create(@NotNull QName messageType, @NotNull String partName) {
        if (messageType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.create must not be null");
        }
        if (partName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.create must not be null");
        }
        return new PropertyAliasSetId(XmlElementType.MESSAGE, messageType, partName);
    }

    public static PropertyAliasSetId create(@NotNull QName element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.create must not be null");
        }
        return new PropertyAliasSetId(XmlElementType.ELEMENT, element);
    }

    @Nullable
    public static PropertyAliasSetId create(@NotNull XmlElementType elementType, @Nullable QName element, @Nullable QName messageType, @Nullable String part) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.create must not be null");
        }
        PropertyAliasSetId aliasSetId = elementType == XmlElementType.ELEMENT && element != null ? PropertyAliasSetId.create(element) : (elementType == XmlElementType.MESSAGE && messageType != null && part != null ? PropertyAliasSetId.create(messageType, part) : null);
        return aliasSetId;
    }

    @Nullable
    public static PropertyAliasSetId parseAliasIdString(@NotNull String aliasSetIdString) {
        if (aliasSetIdString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.parseAliasIdString must not be null");
        }
        PropertyAliasSetId propertyAliasSetId = null;
        XmlUUID xmlUUID = null;
        try {
            xmlUUID = UUIDFactory.parseXmlId((String)aliasSetIdString);
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        if (xmlUUID != null) {
            QName element = null;
            if (xmlUUID.getNamespace() != null && xmlUUID.getNativeName() != null) {
                element = QName.valueOf(xmlUUID.getNamespace() + "/" + xmlUUID.getNativeName());
            }
            propertyAliasSetId = PropertyAliasSetId.create(xmlUUID.getElemType(), element, xmlUUID.getQName(), xmlUUID.getParentFullName());
        }
        return propertyAliasSetId;
    }

    public XmlElementType getElementType() {
        return this.elementType;
    }

    public QName getQname() {
        return this.qname;
    }

    public String getPart() {
        return this.part;
    }

    public String getId() {
        XmlUUID id = UUIDFactory.createXmlId((XmlElementType)this.elementType, (String)this.qname.getNamespaceURI(), (String)this.qname.getLocalPart());
        return id.getId() + (this.part == null ? "" : "|" + this.part);
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyAliasSetId)) {
            return false;
        }
        PropertyAliasSetId propertyAliasSetId = (PropertyAliasSetId)o;
        return this.getId().equals(propertyAliasSetId.getId());
    }

    private static String findParamName(@NotNull Conversational conversational, @Nullable String paramName) {
        ConversationType conversationType;
        if (conversational == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/PropertyAliasSetId.findParamName must not be null");
        }
        String partName = "parameters";
        Conversation conversation = conversational.getConversation();
        if (conversation != null && ((conversationType = conversation.getConversationType()) == ConversationType.SERVICE_CALL || conversationType == ConversationType.USE_INTERFACE)) {
            String attPartName;
            CatalogMember member = conversational.getOperation();
            Sequence<CatalogArgument> arguments = member.getArguments();
            CatalogArgument argument = null;
            if (paramName == null) {
                argument = (CatalogArgument)CollectionUtils.first(arguments);
            } else {
                for (CatalogArgument arg : arguments) {
                    if (!paramName.equals(arg.getName())) continue;
                    argument = arg;
                    break;
                }
            }
            if (argument != null && !Str.isEmpty((String)(attPartName = argument.getDelegateArgument().getProperty("partName")))) {
                partName = attPartName;
            }
        }
        return partName;
    }

    private static PropertyAliasSetId create(Event event) {
        EventDefinition eventDefinition = event.getEventDefinition();
        assert (eventDefinition != null);
        SignalEventDefinition definition = eventDefinition.as(SignalEventDefinition.class);
        SignalObject signalObject = definition.getSignal();
        return new PropertyAliasSetId(XmlElementType.ELEMENT, signalObject.getContentQName());
    }
}

