/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite.util;

import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import org.jetbrains.annotations.Nullable;

public final class FlowNodeFilter {
    public static final Function<FlowNode, OperationReferenceImpl> NODE_OPERATION_DEF_MAPPER = new Function<FlowNode, OperationReferenceImpl>(){

        public OperationReferenceImpl eval(FlowNode event) {
            boolean hasConversation = false;
            Conversational conversational = null;
            if (event.isConversational()) {
                conversational = event.asAnyNode(Conversational.class);
                hasConversation = conversational.getConversation() != null;
            }
            return hasConversation ? new OperationReferenceImpl(conversational) : null;
        }
    };
    public static final Predicate<OperationReferenceImpl> OPERATION_DEFINED_FILTER = new Predicate<OperationReferenceImpl>(){

        public boolean check(@Nullable OperationReferenceImpl opRef) {
            return opRef != null && opRef.getConversation().getConversationType() == ConversationType.DEFINE_INTERFACE;
        }
    };
    public static final Predicate<OperationReferenceImpl> OPERATION_USE_EXTERNAL_FILTER = new Predicate<OperationReferenceImpl>(){

        public boolean check(@Nullable OperationReferenceImpl opRef) {
            return opRef != null && opRef.getConversation().getConversationType() == ConversationType.USE_INTERFACE;
        }
    };
}

