/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite.jaxb;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.composite.ScaEventInfo;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.catalog.composite.jaxb.Component;
import oracle.bpm.project.catalog.composite.jaxb.ComponentType;
import oracle.bpm.project.catalog.composite.jaxb.CompositeUtils;
import oracle.bpm.project.catalog.composite.jaxb.Interface;
import oracle.bpm.project.catalog.composite.jaxb.JaxbScaController;
import oracle.bpm.project.catalog.composite.jaxb.OverrideOptions;
import oracle.bpm.project.catalog.composite.jaxb.Property;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.SCABusinessEvents;
import oracle.bpm.project.catalog.composite.jaxb.SCAConsistencyOptions;
import oracle.bpm.project.catalog.composite.jaxb.SCAFilter;
import oracle.bpm.project.catalog.composite.jaxb.SCAPublish;
import oracle.bpm.project.catalog.composite.jaxb.SCASubscribe;
import oracle.bpm.project.catalog.composite.jaxb.SCAXPath;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.catalog.composite.jaxb.WSDLInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentTypeInfo {
    private Component component;
    private JAXBElement<ComponentType> componentTypeElement;
    private JaxbScaController controller;
    private HashSet<String> names;

    ComponentTypeInfo(JaxbScaController controller, Component component) {
        this.controller = controller;
        this.component = component;
    }

    public boolean isNameUnique(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.isNameUnique must not be null");
        }
        this.initialize();
        return !this.names.contains(name);
    }

    public void addService(@NotNull String serviceName, @Nullable ScaWsdlInfo wsdlInfo) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.addService must not be null");
        }
        if (!this.isNameUnique(serviceName)) {
            throw new IllegalArgumentException("serviceName is not unique: '" + serviceName + "'");
        }
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Service> services = componentType.getService();
        Service service = this.controller.factory.createService();
        service.setName(serviceName);
        if (wsdlInfo != null) {
            JAXBElement<WSDLInterface> interfaceWsdl = this.controller.makeWsdlInterface(wsdlInfo);
            this.controller.setServiceLocation(wsdlInfo, service);
            service.setInterface(interfaceWsdl);
        }
        this.names.add(serviceName);
        services.add(service);
    }

    public void addReference(String referenceName, ScaWsdlInfo wsdlInfo) {
        if (!this.isNameUnique(referenceName)) {
            throw new IllegalArgumentException("serviceName is not unique: '" + referenceName + "'");
        }
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Reference> references = componentType.getReference();
        Reference reference = this.controller.factory.createReference();
        reference.setName(referenceName);
        if (wsdlInfo != null) {
            JAXBElement<WSDLInterface> interfaceWsdl = this.controller.makeWsdlInterface(wsdlInfo);
            Map<QName, String> attributes = reference.getOtherAttributes();
            attributes.put(new QName("http://xmlns.oracle.com/soa/designer/", "wsdlLocation", "ui"), wsdlInfo.location);
            reference.setInterface(interfaceWsdl);
        }
        this.names.add(referenceName);
        references.add(reference);
    }

    public List<String> getServiceNames() {
        this.initialize();
        ArrayList<String> result = new ArrayList<String>();
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Service> services = componentType.getService();
        if (services != null) {
            for (Service service : services) {
                result.add(service.getName());
            }
        }
        return result;
    }

    public List<String> getReferenceNames() {
        this.initialize();
        ArrayList<String> result = new ArrayList<String>();
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Reference> references = componentType.getReference();
        if (references != null) {
            for (Reference reference : references) {
                result.add(reference.getName());
            }
        }
        return result;
    }

    public void deleteService(String serviceName) {
        if (!this.isNameUnique(serviceName)) {
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            List<Service> references = componentType.getService();
            Iterator<Service> it = references.iterator();
            while (it.hasNext()) {
                Service service = it.next();
                if (!service.getName().equals(serviceName)) continue;
                it.remove();
                break;
            }
            this.names.remove(serviceName);
        }
    }

    public void deleteReference(String referenceName) {
        if (!this.isNameUnique(referenceName)) {
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            List<Reference> references = componentType.getReference();
            Iterator<Reference> it = references.iterator();
            while (it.hasNext()) {
                Reference reference = it.next();
                if (!reference.getName().equals(referenceName)) continue;
                it.remove();
                break;
            }
            this.names.remove(referenceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commitChanges() {
        this.initialize();
        VFile componentTypeXml = this.getFile();
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream((OutputStream)new VFileOutputStream(componentTypeXml));
            JaxbScaController.save(this.componentTypeElement, os);
        }
        catch (JAXBException e) {
            block6: {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
            StreamUtils.close((Closeable[])new Closeable[]{os});
        }
        catch (IOException e2) {
            block7: {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.close((Closeable[])new Closeable[]{os});
                        throw throwable;
                    }
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{os});
        }
        StreamUtils.close((Closeable[])new Closeable[]{os});
    }

    public ScaWsdlInfo getWsdlInfoForName(String linkName) {
        List<Reference> references;
        this.initialize();
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Service> services = componentType.getService();
        if (services != null) {
            for (Service service : services) {
                String location;
                JAXBElement<? extends Interface> element;
                ScaWsdlInfo result;
                if (!linkName.equals(service.getName()) || service.getInterface() == null || (result = this.getWsdlInfo(element = service.getInterface(), location = this.controller.getLocation(service.getOtherAttributes()))) == null) continue;
                return result;
            }
        }
        if ((references = componentType.getReference()) != null) {
            for (Reference reference : references) {
                String location;
                JAXBElement<? extends Interface> element;
                ScaWsdlInfo result;
                if (!linkName.equals(reference.getName()) || reference.getInterface() == null || (result = this.getWsdlInfo(element = reference.getInterface(), location = this.controller.getLocation(reference.getOtherAttributes()))) == null) continue;
                return result;
            }
        }
        return null;
    }

    public void addEventSubscription(ScaEventInfo eventInfo) {
        this.initialize();
        QName eventName = new QName(eventInfo.namespace, eventInfo.name, "sub1");
        SCASubscribe subscriptionEvent = this.findSubscriptionEvent(eventName);
        if (subscriptionEvent == null) {
            SCASubscribe subscription = this.controller.factory.createSCASubscribe();
            this.updateSubscription(eventName, eventInfo, subscription);
            this.addSubscription(subscription);
        } else {
            this.updateSubscription(eventName, eventInfo, subscriptionEvent);
        }
    }

    public void deleteEventSubscription(ScaEventInfo eventInfo) {
        this.initialize();
        QName eventName = new QName(eventInfo.namespace, eventInfo.name);
        SCABusinessEvents events = this.component.getBusinessEvents();
        if (events != null) {
            Iterator<SCASubscribe> it = events.getSubscribe().iterator();
            while (it.hasNext()) {
                SCASubscribe subscription = it.next();
                if (!eventName.equals(subscription.getName())) continue;
                it.remove();
                break;
            }
        }
    }

    public void addEventPublish(ScaEventInfo eventInfo) {
        this.initialize();
        QName eventName = new QName(eventInfo.namespace, eventInfo.name, "pub1");
        SCAPublish publicationEvent = this.findPublicationEvent(eventName);
        if (publicationEvent == null) {
            SCAPublish publication = this.controller.factory.createSCAPublish();
            publication.setName(eventName);
            this.addPublication(publication);
        } else {
            publicationEvent.setName(eventName);
        }
    }

    public void deleteEventPublish(ScaEventInfo eventInfo) {
        this.initialize();
        QName eventName = new QName(eventInfo.namespace, eventInfo.name);
        SCABusinessEvents events = this.component.getBusinessEvents();
        if (events != null) {
            Iterator<SCAPublish> it = events.getPublishes().iterator();
            while (it.hasNext()) {
                SCAPublish publish = it.next();
                if (!eventName.equals(publish.getName())) continue;
                it.remove();
                break;
            }
        }
    }

    public Sequence<ScaEventInfo> getEventPublishes() {
        this.initialize();
        SCABusinessEvents events = this.component.getBusinessEvents();
        Sequence result = events == null ? CollectionUtils.emptySequence() : CollectionUtils.asSequence(events.getPublishes()).map((Function)new Function<SCAPublish, ScaEventInfo>(){

            public ScaEventInfo eval(SCAPublish value) {
                QName qName = value.getName();
                return qName == null ? null : ScaEventInfo.createEventInfo(qName.getNamespaceURI(), qName.getLocalPart());
            }
        }).selectInstanceOf(ScaEventInfo.class);
        return result;
    }

    public Sequence<ScaEventInfo> getEventSubscriptions() {
        this.initialize();
        SCABusinessEvents events = this.component.getBusinessEvents();
        Sequence result = events == null ? CollectionUtils.emptySequence() : CollectionUtils.asSequence(events.getSubscribe()).map((Function)new Function<SCASubscribe, ScaEventInfo>(){

            public ScaEventInfo eval(SCASubscribe value) {
                return ScaEventInfo.createEventInfo(value.getName().getNamespaceURI(), value.getName().getLocalPart()).consistency(ScaEventInfo.Consistency.fromString(value.getConsistency().value())).runAsRoles(value.getRunAsRoles());
            }
        });
        return result;
    }

    public void delete() {
        this.getFile().delete();
    }

    public void deleteProperty(String propertyName, String serviceOrReferenceName) {
        this.initialize();
        if (serviceOrReferenceName == null) {
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            this.deleteProperty(propertyName, componentType.getProperty());
        } else {
            if (this.isNameUnique(serviceOrReferenceName)) {
                throw new IllegalArgumentException("unknown name: " + serviceOrReferenceName);
            }
            Service service = this.findService(serviceOrReferenceName);
            if (service != null) {
                this.deleteProperty(propertyName, service.getProperty());
            } else {
                Reference reference = this.findReference(serviceOrReferenceName);
                if (reference != null) {
                    this.deleteProperty(propertyName, reference.getProperty());
                }
            }
        }
    }

    public void addProperty(ScaPropertyInfo propInfo, String serviceOrReferenceName) {
        this.initialize();
        if (serviceOrReferenceName == null) {
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            this.addProperty(propInfo, componentType.getProperty());
        } else {
            if (this.isNameUnique(serviceOrReferenceName)) {
                throw new IllegalArgumentException("unknown name: " + serviceOrReferenceName);
            }
            Service service = this.findService(serviceOrReferenceName);
            if (service != null) {
                this.addProperty(propInfo, service.getProperty());
            } else {
                Reference reference = this.findReference(serviceOrReferenceName);
                if (reference != null) {
                    this.addProperty(propInfo, reference.getProperty());
                }
            }
        }
    }

    public ScaPropertyInfo getProperty(String serviceOrReferenceName, String propertyName) {
        Property property;
        this.initialize();
        if (serviceOrReferenceName == null) {
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            return CompositeUtils.convert(this.findProperty(componentType.getProperty(), propertyName));
        }
        if (this.isNameUnique(serviceOrReferenceName)) {
            throw new IllegalArgumentException("unknown name: " + serviceOrReferenceName);
        }
        Service service = this.findService(serviceOrReferenceName);
        if (service != null) {
            return CompositeUtils.convert(this.findProperty(service.getProperty(), propertyName));
        }
        Reference reference = this.findReference(serviceOrReferenceName);
        if (reference != null && (property = this.findProperty(reference.getProperty(), propertyName)) != null) {
            return CompositeUtils.convert(property);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static SCAConsistencyOptions mapConsistency(@NotNull ScaEventInfo.Consistency subscriptionConsistency) {
        if (subscriptionConsistency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.mapConsistency must not be null");
        }
        switch (subscriptionConsistency) {
            case GUARANTEED: {
                SCAConsistencyOptions sCAConsistencyOptions = SCAConsistencyOptions.GUARANTEED;
                if (sCAConsistencyOptions == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.mapConsistency must not return null");
                return sCAConsistencyOptions;
            }
            case IMMEDIATE: {
                SCAConsistencyOptions sCAConsistencyOptions = SCAConsistencyOptions.IMMEDIATE;
                if (sCAConsistencyOptions == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.mapConsistency must not return null");
                return sCAConsistencyOptions;
            }
            case ONEONLY: {
                SCAConsistencyOptions sCAConsistencyOptions = SCAConsistencyOptions.ONE_AND_ONLY_ONE;
                if (sCAConsistencyOptions != null) return sCAConsistencyOptions;
                throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.mapConsistency must not return null");
            }
        }
        throw new AssertionError((Object)("Unexpected enum constant: " + (Object)((Object)subscriptionConsistency)));
    }

    private VFile getFile() {
        VFileSystem vfs = this.controller.getFileSystem();
        return vfs.createFile(this.component.getName() + ".componentType");
    }

    private void initialize() {
        if (this.componentTypeElement == null) {
            List<Reference> references;
            List<Service> services;
            this.componentTypeElement = this.loadComponentType(this.component);
            this.names = new HashSet();
            ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
            List<Property> properties = componentType.getProperty();
            if (properties != null) {
                for (Property property : properties) {
                    this.names.add(property.getName());
                }
            }
            if ((services = componentType.getService()) != null) {
                for (Service service : services) {
                    this.names.add(service.getName());
                }
            }
            if ((references = componentType.getReference()) != null) {
                for (Reference reference : references) {
                    this.names.add(reference.getName());
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private JAXBElement<ComponentType> loadComponentType(@NotNull Component component) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JAXBElement<ComponentType> createEmptyComponentType() {
        ComponentType componentType = this.controller.factory.createComponentType();
        return this.controller.factory.createComponentType(componentType);
    }

    private ScaWsdlInfo getWsdlInfo(JAXBElement<? extends Interface> element, String location) {
        ScaWsdlInfo result = null;
        Interface value = (Interface)element.getValue();
        if (value instanceof WSDLInterface) {
            WSDLInterface wsdlInterface = (WSDLInterface)value;
            result = new ScaWsdlInfo(location, this.toQName(wsdlInterface.getInterface()), this.toQName(wsdlInterface.getCallbackInterface()));
        }
        return result;
    }

    private QName toQName(String anInterface) {
        if (!Str.isEmpty((String)anInterface)) {
            int index = anInterface.indexOf("#wsdl.interface(");
            if (index != -1 && anInterface.endsWith(")")) {
                String namespaceURI = anInterface.substring(0, index);
                String localPart = anInterface.substring(index + "#wsdl.interface(".length(), anInterface.length() - 1);
                return new QName(namespaceURI, localPart);
            }
            return new QName(anInterface);
        }
        return null;
    }

    private void addSubscription(SCASubscribe subscription) {
        SCABusinessEvents businessEvents = this.component.getBusinessEvents();
        if (businessEvents == null) {
            businessEvents = this.controller.factory.createSCABusinessEvents();
            this.component.setBusinessEvents(businessEvents);
        }
        businessEvents.getSubscribe().add(subscription);
    }

    private void updateSubscription(QName eventName, ScaEventInfo eventInfo, SCASubscribe subscription) {
        subscription.setName(eventName);
        subscription.setConsistency(ComponentTypeInfo.mapConsistency(eventInfo.subscriptionConsistency));
        subscription.setFilter(this.mapFilter(eventInfo.filter, eventInfo.filterNamespaces));
        subscription.setRunAsRoles(eventInfo.runAsRoles);
    }

    @Nullable
    private SCAFilter mapFilter(@Nullable String filter, @Nullable Map<String, URI> filterNamespaces) {
        SCAFilter scaFilter;
        if (filter != null && filterNamespaces != null) {
            SCAXPath xpath = this.controller.factory.createSCAXPath();
            xpath.setExpression(filter);
            scaFilter = this.controller.factory.createSCAFilter();
            scaFilter.setXpath(xpath);
        } else {
            scaFilter = null;
        }
        return scaFilter;
    }

    @Nullable
    private SCASubscribe findSubscriptionEvent(@NotNull QName eventName) {
        if (eventName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.findSubscriptionEvent must not be null");
        }
        SCABusinessEvents events = this.component.getBusinessEvents();
        if (events != null) {
            for (SCASubscribe subscription : events.getSubscribe()) {
                if (!eventName.equals(subscription.getName())) continue;
                return subscription;
            }
        }
        return null;
    }

    private void addPublication(@NotNull SCAPublish publication) {
        if (publication == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.addPublication must not be null");
        }
        SCABusinessEvents businessEvents = this.component.getBusinessEvents();
        if (businessEvents == null) {
            businessEvents = this.controller.factory.createSCABusinessEvents();
            this.component.setBusinessEvents(businessEvents);
        }
        businessEvents.getPublishes().add(publication);
    }

    @Nullable
    private SCAPublish findPublicationEvent(@NotNull QName eventName) {
        if (eventName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/ComponentTypeInfo.findPublicationEvent must not be null");
        }
        SCABusinessEvents events = this.component.getBusinessEvents();
        if (events != null) {
            for (SCAPublish publication : events.getPublishes()) {
                if (!eventName.equals(publication.getName())) continue;
                return publication;
            }
        }
        return null;
    }

    private void deleteProperty(String propertyName, List<Property> propertyList) {
        if (propertyName != null) {
            Iterator<Property> it = propertyList.iterator();
            while (it.hasNext()) {
                Property property = it.next();
                if (!propertyName.equals(property.getName())) continue;
                it.remove();
                break;
            }
        }
    }

    private Property findProperty(List<Property> propertyList, String propertyName) {
        if (propertyName != null) {
            for (Property property : propertyList) {
                if (!propertyName.equals(property.getName())) continue;
                return property;
            }
        } else {
            throw new IllegalArgumentException("Property name is null");
        }
        return null;
    }

    private Service findService(String name) {
        this.initialize();
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Service> services = componentType.getService();
        if (services != null) {
            for (Service service : services) {
                if (!name.equals(service.getName())) continue;
                return service;
            }
        }
        return null;
    }

    private Reference findReference(String name) {
        this.initialize();
        ComponentType componentType = (ComponentType)this.componentTypeElement.getValue();
        List<Reference> references = componentType.getReference();
        if (references != null) {
            for (Reference reference : references) {
                if (!name.equals(reference.getName())) continue;
                return reference;
            }
        }
        return null;
    }

    private void addProperty(ScaPropertyInfo propInfo, List<Property> propertyList) {
        Property property = this.findProperty(propertyList, propInfo.name);
        if (property != null) {
            propertyList.remove(property);
        }
        propertyList.add(this.convert(propInfo));
    }

    private Property convert(ScaPropertyInfo propInfo) {
        Property result = new Property();
        result.setMany(propInfo.many);
        result.setName(propInfo.name);
        ScaPropertyInfo.Override override = propInfo.override;
        if (override != null) {
            result.setOverride(OverrideOptions.fromValue(override.scaName));
        }
        result.setSource(propInfo.source);
        if (propInfo.type != null) {
            result.setType(propInfo.type);
        } else {
            result.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        }
        result.setValue(propInfo.value);
        return result;
    }
}

