/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ElementContainer;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.jaxb.BPELImplementation;
import oracle.bpm.project.catalog.composite.jaxb.BPMNImplementation;
import oracle.bpm.project.catalog.composite.jaxb.CEPImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Component;
import oracle.bpm.project.catalog.composite.jaxb.ComponentType;
import oracle.bpm.project.catalog.composite.jaxb.CompositeUtils;
import oracle.bpm.project.catalog.composite.jaxb.DecisionImplementation;
import oracle.bpm.project.catalog.composite.jaxb.EventAgentImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Implementation;
import oracle.bpm.project.catalog.composite.jaxb.MediatorImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Property;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.catalog.composite.jaxb.SpringImplementation;
import oracle.bpm.project.catalog.composite.jaxb.WorkflowImplementation;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JaxbComponentTypeAccessor {
    private Map<String, CompositeComponent> componentByName;
    private VFileSystem fileSystem;
    private static final String COMPONENT_TYPE_EXT = ".componentType";

    public JaxbComponentTypeAccessor(@NotNull VFileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbComponentTypeAccessor.<init> must not be null");
        }
        this.componentByName = new HashMap<String, CompositeComponent>();
        this.fileSystem = fileSystem;
        fileSystem.addListener(new VFileEventListener(){

            public void onFileEvent(@NotNull VFileEvent event) {
                String name;
                int index;
                VEventType type = event.getType();
                if ((type == VEventType.CHANGE || type == VEventType.REMOVE) && (index = (name = event.getSource().getName()).lastIndexOf(JaxbComponentTypeAccessor.COMPONENT_TYPE_EXT)) > 0) {
                    JaxbComponentTypeAccessor.this.componentByName.remove(name.substring(0, index));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CompositeComponent getCompositeComponent(@NotNull Component component, @NotNull Iterable<CompositeImport> compositeImports) throws CompositeAccessorException {
        CompositeComponent result;
        block12: {
            if (component == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbComponentTypeAccessor.getCompositeComponent must not be null");
            }
            if (compositeImports == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbComponentTypeAccessor.getCompositeComponent must not be null");
            }
            String name = component.getName();
            result = this.componentByName.get(name);
            if (result != null) break block12;
            JAXBElement<? extends Implementation> implementationElement = component.getImplementation();
            Map<String, ScaPropertyInfo> componentProperties = Collections.emptyMap();
            CompositeServiceType serviceType = this.getType(implementationElement);
            CompositeComponent compositeComponent = new CompositeComponent(name, serviceType, this.getSrc(implementationElement), componentProperties);
            if (implementationElement != null) {
                VFileInputStream componentInputStream;
                block11: {
                    componentInputStream = null;
                    try {
                        VFile componentFile = this.fileSystem.createFile(name + COMPONENT_TYPE_EXT);
                        if (!componentFile.exists()) break block11;
                        componentInputStream = new VFileInputStream(componentFile);
                        JAXBElement<ComponentType> componentElement = CompositeUtils.loadScaElement((InputStream)componentInputStream, ComponentType.class);
                        ComponentType componentType = (ComponentType)componentElement.getValue();
                        List<Service> services = componentType.getService();
                        for (Service service : services) {
                            ElementContainer objectContainer = new ElementContainer(this.fileSystem, service, compositeImports);
                            Map<String, ScaPropertyInfo> properties = this.buildPropertyMap(service.getProperty());
                            CompositeInterface compositeRef = CompositeAccessor.createInterface(objectContainer, name, service.getName(), CatalogInterfaceType.SERVICE, properties);
                            if (compositeRef == null) continue;
                            compositeComponent.addService(compositeRef);
                        }
                        List<Reference> references = componentType.getReference();
                        for (Reference reference : references) {
                            ElementContainer objectContainer = new ElementContainer(this.fileSystem, reference, compositeImports);
                            Map<String, ScaPropertyInfo> properties = this.buildPropertyMap(reference.getProperty());
                            CompositeInterface compositeRef = CompositeAccessor.createInterface(objectContainer, name, reference.getName(), CatalogInterfaceType.REFERENCE, properties);
                            if (compositeRef == null) continue;
                            compositeComponent.addReference(compositeRef);
                        }
                    }
                    catch (JAXBException ignore) {
                        StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
                    }
                    catch (IOException ignore2) {
                        StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
                        {
                            catch (Throwable throwable) {
                                StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
                                throw throwable;
                            }
                        }
                    }
                }
                StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
            }
            this.componentByName.put(name, compositeComponent);
            result = compositeComponent;
        }
        return result;
    }

    public void clear() {
        this.componentByName.clear();
    }

    private Map<String, ScaPropertyInfo> buildPropertyMap(List<Property> propertyList) {
        Map<String, ScaPropertyInfo> result;
        if (propertyList != null && !propertyList.isEmpty()) {
            result = new HashMap<String, ScaPropertyInfo>();
            for (Property property : propertyList) {
                ScaPropertyInfo info = CompositeUtils.convert(property);
                result.put(info.name, info);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private CompositeServiceType getType(@Nullable JAXBElement<? extends Implementation> implementation) {
        CompositeServiceType result = CompositeServiceType.UNKNOWN;
        if (implementation != null) {
            Implementation value = (Implementation)implementation.getValue();
            if (value instanceof WorkflowImplementation) {
                result = CompositeServiceType.HUMAN_TASK;
            } else if (value instanceof BPELImplementation) {
                result = "implementation.bpmn".equals(implementation.getName().getLocalPart()) ? CompositeServiceType.BPMN : CompositeServiceType.BPEL;
            } else if (value instanceof EventAgentImplementation) {
                result = CompositeServiceType.EVENT_AGENT;
            } else if (value instanceof CEPImplementation) {
                result = CompositeServiceType.CEP;
            } else if (value instanceof MediatorImplementation) {
                result = CompositeServiceType.MEDIATOR;
            } else if (value instanceof DecisionImplementation) {
                result = CompositeServiceType.BUSINESS_RULE;
            } else if (value instanceof BPMNImplementation) {
                result = CompositeServiceType.BPMN;
            } else if (value instanceof SpringImplementation) {
                result = CompositeServiceType.SPRING;
            }
        }
        return result;
    }

    private String getSrc(@Nullable JAXBElement<? extends Implementation> implementation) {
        String result = null;
        if (implementation != null) {
            Implementation value = (Implementation)implementation.getValue();
            if (value instanceof WorkflowImplementation) {
                WorkflowImplementation impl = (WorkflowImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof BPELImplementation) {
                BPELImplementation impl = (BPELImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof EventAgentImplementation) {
                EventAgentImplementation impl = (EventAgentImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof CEPImplementation) {
                CEPImplementation impl = (CEPImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof MediatorImplementation) {
                MediatorImplementation impl = (MediatorImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof DecisionImplementation) {
                DecisionImplementation impl = (DecisionImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof BPMNImplementation) {
                BPMNImplementation impl = (BPMNImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof SpringImplementation) {
                SpringImplementation impl = (SpringImplementation)value;
                result = impl.getSrc();
            }
        }
        return result;
    }
}

