/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import oracle.bpm.project.catalog.composite.jaxb.ImportType;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class CompositeImport {
    private final ResourceType importType;
    private final String location;
    private final String namespace;

    public CompositeImport(@NotNull String namespace, @NotNull String location, @NotNull ImportType importType) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        if (importType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        this.namespace = namespace;
        this.location = location;
        this.importType = this.processImportType(importType);
    }

    public CompositeImport(@NotNull String namespace, @NotNull String location, @NotNull String importType) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        if (importType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.<init> must not be null");
        }
        this.namespace = namespace;
        this.location = location;
        this.importType = this.processImportType(importType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getNamespace() {
        String string = this.namespace;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeImport.getNamespace must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getLocation() {
        String string = this.location;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeImport.getLocation must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ResourceType getImportType() {
        ResourceType resourceType = this.importType;
        if (resourceType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeImport.getImportType must not return null");
        }
        return resourceType;
    }

    private ResourceType processImportType(@NotNull ImportType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.processImportType must not be null");
        }
        switch (type) {
            case XSD: {
                return ResourceType.XML_SCHEMA;
            }
            case WSDL: {
                return ResourceType.WSDL;
            }
            case EDL: {
                return ResourceType.EVENT;
            }
        }
        throw new IllegalArgumentException("Unsupported importType '" + (Object)((Object)this.importType) + "'");
    }

    private ResourceType processImportType(@NotNull String importType) {
        if (importType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeImport.processImportType must not be null");
        }
        ImportType type = ImportType.fromValue(importType);
        if (type != null) {
            return this.processImportType(type);
        }
        throw new IllegalArgumentException("Invalid importType '" + importType + "'");
    }
}

