/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlParser;
import oracle.bpm.project.catalog.utils.WsdlUtils;
import oracle.bpm.project.catalog.xmltype.OraMdsImportResolver;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.data.PortTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeAccessor {
    @NotNull
    private Project project;

    public CompositeAccessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.<init> must not be null");
        }
        this.project = project;
    }

    @NotNull
    public abstract CompositeInfo parseComposite() throws CompositeAccessorException;

    public abstract void reload();

    @Nullable
    public static CompositeInterface createInterface(@NotNull CompositeObjectContainer compositeObjectContainer, @NotNull String target, @Nullable String targetPort, @NotNull CatalogInterfaceType interfaceType, @Nullable Map<String, ScaPropertyInfo> properties) {
        if (compositeObjectContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        String name = compositeObjectContainer.getName();
        List<URI> locations = compositeObjectContainer.getWsdl();
        QName servicePorttype = compositeObjectContainer.getInterfaceQName();
        QName callbackPorttype = compositeObjectContainer.getCallbankInterfaceQName();
        URI location = null;
        if (locations == null) {
            Log.logWarning((Msg)ProjectCatalogMsg.MISSING_WSDL_LOCATION(name));
            return null;
        }
        if (locations.size() == 1) {
            location = locations.get(0);
        } else {
            String portType = compositeObjectContainer.getInterfaceQName().getLocalPart();
            WsdlParser wsdlParser = new WsdlParser(compositeObjectContainer.getVFileSystem(), new WsdlTypeIndex());
            wsdlParser.setXsdImportResolver(new OraMdsImportResolver());
            for (URI location_tmp : locations) {
                try {
                    ServiceDefinition definition = wsdlParser.parseDefinition(location_tmp);
                    List<PortTypeDescription> ports = WsdlUtils.getPorts(definition);
                    for (PortTypeDescription port : ports) {
                        if (!port.getName().equals(portType)) continue;
                        location = location_tmp;
                    }
                }
                catch (TypeParseException e) {
                    Log.logWarning((Msg)ProjectCatalogMsg.MISSING_WSDL_LOCATION(location_tmp.toString()));
                }
            }
        }
        if (location == null) {
            return null;
        }
        return new CompositeInterface(name, location, servicePorttype, callbackPorttype, target, targetPort, compositeObjectContainer.getInterfaceType(), interfaceType, properties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessor.getProject must not return null");
        }
        return project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected VFileSystem getVFileSystemProject() {
        VFileSystem vFileSystem = this.project.getLoader().getProjectFileSystem().getDataFileSystem();
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessor.getVFileSystemProject must not return null");
        }
        return vFileSystem;
    }

    protected final <S, T> Iterable<T> nonNullIterable(Collection<S> references, Function<S, T> mapper) {
        Iterable result = references != null ? CollectionUtils.asSequence(references).map(mapper).select(PredicateUtils.notNull()) : CollectionUtils.emptyIterable();
        return result;
    }

    private static class WsdlTypeIndex
    implements TypeIndex {
        private WsdlTypeIndex() {
        }

        @Nullable
        public TypeRef findExact(@NotNull String typeName) {
            if (typeName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findExact must not be null");
            }
            return null;
        }

        @Nullable
        public TypeRef findById(@NotNull String componentType, @NotNull String id) {
            if (componentType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findById must not be null");
            }
            if (id == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findById must not be null");
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public SortedSet<TypeRef> findByPropertyValue(@NotNull String propertyName, @NotNull String propertyValue) {
            if (propertyName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findByPropertyValue must not be null");
            }
            if (propertyValue == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findByPropertyValue must not be null");
            }
            SortedSet sortedSet = CollectionUtils.emptySortedSet();
            if (sortedSet == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessor$WsdlTypeIndex.findByPropertyValue must not return null");
            }
            return sortedSet;
        }
    }

    protected static interface CompositeObjectContainer {
        public String getName();

        public QName getInterfaceQName();

        public QName getCallbankInterfaceQName();

        public VFileSystem getVFileSystem();

        public List<URI> getWsdl();

        @NotNull
        public CompositeServiceType getInterfaceType();
    }
}

