/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.common;

import javax.xml.namespace.QName;
import oracle.bpm.lang.Str;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringComponentUtils {
    private static final String WSDL = ".wsdl";
    private static final String PACKAGE_SEPARATOR = ".";

    private SpringComponentUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String buildWsdlFileName(@NotNull String interfaceName) {
        if (interfaceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/SpringComponentUtils.buildWsdlFileName must not be null");
        }
        String string = SpringComponentUtils.shortName(interfaceName) + WSDL;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/SpringComponentUtils.buildWsdlFileName must not return null");
        }
        return string;
    }

    public static QName buildQName(@Nullable String interfaceName) {
        QName result = null;
        if (interfaceName != null) {
            String interfacePackage = SpringComponentUtils.getPackage(interfaceName);
            String[] strings = Str.split((String)interfacePackage, (char)'.', (boolean)false);
            String namespace = "http://";
            String separator = null;
            for (int i = strings.length - 1; i >= 0; --i) {
                namespace = namespace + (separator == null ? "" : separator) + strings[i];
                separator = PACKAGE_SEPARATOR;
            }
            namespace = namespace + "/";
            result = new QName(namespace, SpringComponentUtils.shortName(interfaceName));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String shortName(@NotNull String interfaceName) {
        if (interfaceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/SpringComponentUtils.shortName must not be null");
        }
        int indexOfDot = interfaceName.lastIndexOf(PACKAGE_SEPARATOR);
        String string = indexOfDot == -1 ? interfaceName : interfaceName.substring(indexOfDot + 1);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/SpringComponentUtils.shortName must not return null");
        }
        return string;
    }

    private static String getPackage(@NotNull String interfaceName) {
        if (interfaceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/SpringComponentUtils.getPackage must not be null");
        }
        int indexOfDot = interfaceName.lastIndexOf(PACKAGE_SEPARATOR);
        return indexOfDot == -1 ? "" : interfaceName.substring(0, indexOfDot);
    }
}

