/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.project.catalog.common.Resource;
import org.jetbrains.annotations.NotNull;

public class AssociatedType {
    private Set<Resource> associatedResources;
    private String typeName;

    public AssociatedType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/AssociatedType.<init> must not be null");
        }
        this.typeName = typeName;
        this.associatedResources = new HashSet<Resource>();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTypeName() {
        String string = this.typeName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/AssociatedType.getTypeName must not return null");
        }
        return string;
    }

    public void addAssociatedResource(@NotNull Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/AssociatedType.addAssociatedResource must not be null");
        }
        if (!this.associatedResources.contains(resource)) {
            this.associatedResources.add(resource);
            resource.addAssociatedType(this);
        }
    }

    public void removeAssociatedResource(@NotNull Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/AssociatedType.removeAssociatedResource must not be null");
        }
        if (this.associatedResources.contains(resource)) {
            this.associatedResources.remove(resource);
            resource.removeAssociatedType(this);
        }
    }

    public Set<Resource> getAssociatedResources() {
        return Collections.unmodifiableSet(this.associatedResources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociatedType that = (AssociatedType)o;
        return this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }
}

