/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.bundles.SynthesizedReferenceManager;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSchemaReferenceManager
extends SynthesizedReferenceManager {
    private BiMap<String, String> bpmObjectsBySchema;
    private final String EXT_MODULE_PREFIX = "Ext.";
    private final String PROCESS_MODULE_PREFIX = "Processes.";
    private Map<String, Set<String>> referencesByTypeName;
    private BiMap<String, String> synthesizedByName = new HashBiMap();
    private Map<String, Set<String>> typeNameByReference;
    private final String TYPES_MODULE_PREFIX = "Types.";

    public XmlSchemaReferenceManager(ComponentCatalog projectCatalog) {
        super(projectCatalog);
        this.bpmObjectsBySchema = new HashBiMap();
        this.referencesByTypeName = new Hashtable<String, Set<String>>();
        this.typeNameByReference = new Hashtable<String, Set<String>>();
    }

    @Override
    public void addObject(MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription otd) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addObject must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addObject must not be null");
        }
        if (this.needsProcessing(typeName)) {
            int i;
            if (!otd.isModule()) {
                if (otd.isBpmObject() && !otd.isSynthesized()) {
                    this.addBpmObject(typeIndex, (XObjectTypeDescription)otd, typeName);
                }
                for (i = 0; i < otd.getMemberCount(); ++i) {
                    MethodTypeDescription mtd = otd.getMember(i);
                    if (mtd.isAttribute()) {
                        this.fixAttribute(typeIndex, typeName, mtd.asAttribute());
                        continue;
                    }
                    for (Argument argument : mtd.getArguments()) {
                        this.fixArgument(typeIndex, typeName, argument);
                    }
                    this.fixArgument(typeIndex, typeName, mtd.getResultArgument());
                    this.fixExceptions(typeIndex, typeName, mtd);
                }
                if (otd.isBpmObject()) {
                    if (Modifier.isException((long)otd.getModifiers())) {
                        TypeRef ref = typeIndex.findById(ComponentType.XML.getText(), otd.getProperty("attributes.schema.id"));
                        XmlTypeDescription xmlotd = null;
                        if (ref != null) {
                            xmlotd = (XmlTypeDescription)ref.get();
                        }
                        if (xmlotd != null) {
                            for (MethodTypeDescription mtd : xmlotd.getAttributes()) {
                                this.fixAttribute(typeIndex, typeName, mtd.asAttribute());
                            }
                        }
                    }
                    this.fixServiceExceptions(typeIndex, typeName, otd);
                }
            }
            for (i = 0; i < otd.getInnerTypeCount(); ++i) {
                ObjectTypeDescription innerType = otd.getInnerType(i);
                this.addObject(typeIndex, typeName + "." + innerType.getName(), innerType);
            }
        }
    }

    @Override
    public void typeAddedOrUpdated(MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription type) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.typeAddedOrUpdated must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.typeAddedOrUpdated must not be null");
        }
        if (this.needsProcessing(typeName)) {
            this.addObject(typeIndex, typeName, type);
        }
    }

    @Override
    public void typeRemoved(MutableTypeIndex typeIndex, @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.typeRemoved must not be null");
        }
        if (this.needsProcessing(typeName)) {
            String schemaId;
            if (this.referencesByTypeName.containsKey(typeName)) {
                this.removeTypeReferences(typeIndex, typeName);
            }
            if ((schemaId = (String)this.bpmObjectsBySchema.inverse().remove((Object)typeName)) != null && this.typeNameByReference.containsKey(schemaId)) {
                this.createSynthesized(typeIndex, schemaId);
            }
        }
    }

    @Override
    public void clear() {
        this.referencesByTypeName.clear();
        this.bpmObjectsBySchema.clear();
        this.referencesByTypeName.clear();
        this.typeNameByReference.clear();
    }

    private void fixServiceExceptions(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription customizedService) {
        ObjectTypeDescription delegatedOtd;
        TypeRef delegatedRef;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixServiceExceptions must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixServiceExceptions must not be null");
        }
        if (customizedService == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixServiceExceptions must not be null");
        }
        if (TypeUtils.isService((TypeRef)customizedService) && (delegatedRef = (TypeRef)customizedService.getTransientProperty("service.type.ref")) != null && (delegatedOtd = this.findDelegatedType(typeIndex, delegatedRef)) != null) {
            for (MethodTypeDescription method : customizedService.getMethods()) {
                DelegatedMethodTypeDescription customizedMethod;
                String signature;
                MethodTypeDescription originalMethod;
                if (!method.isDelegated() || (originalMethod = delegatedOtd.getMemberBySignature(signature = (customizedMethod = (DelegatedMethodTypeDescription)method).getDelegatedMethodSignature())) == null) continue;
                this.fixExceptions(typeIndex, typeName, originalMethod);
            }
        }
    }

    private ObjectTypeDescription findDelegatedType(@NotNull MutableTypeIndex typeIndex, @NotNull TypeRef delegatedRef) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.findDelegatedType must not be null");
        }
        if (delegatedRef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.findDelegatedType must not be null");
        }
        ObjectTypeDescription result = null;
        TypeDescription td = delegatedRef.get();
        if (td.isUnknown()) {
            if (delegatedRef instanceof DynamicRef) {
                TypeDescription type;
                DynamicRef dynamicRef = (DynamicRef)delegatedRef;
                String id = dynamicRef.getId();
                TypeRef ref = typeIndex.findById(ComponentType.PORT_TYPE.getText(), id);
                if (ref != null && (type = ref.get()) != null && !type.isUnknown()) {
                    result = type.asObject();
                }
            }
        } else {
            result = td.asObject();
        }
        return result;
    }

    private void fixExceptions(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull MethodTypeDescription mtd) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixExceptions must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixExceptions must not be null");
        }
        if (mtd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixExceptions must not be null");
        }
        for (int i = 0; i < mtd.getExceptions().size(); ++i) {
            XmlTypeDescription xmlOtd;
            TypeRef ref = (TypeRef)mtd.getExceptions().get(i);
            TypeDescription td = this.getType(typeIndex, ref);
            if (!(td instanceof XmlTypeDescription) || (xmlOtd = (XmlTypeDescription)td).getXmlElementType() != XmlElementType.FAULT) continue;
            DynamicRef typeRef = this.addReference(typeIndex, typeName, xmlOtd);
            mtd.setException(i, (TypeRef)typeRef);
            SortedSet refs = typeIndex.findByPropertyValue("attributes.schema.id", typeRef.getId());
            assert (refs.size() == 1);
            ObjectTypeDescription exceptionType = ((TypeRef)refs.first()).get().asObject();
            this.addObject(typeIndex, exceptionType.getText(), exceptionType);
        }
    }

    private boolean needsProcessing(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.needsProcessing must not be null");
        }
        return (!typeName.startsWith("Ext.") || typeName.startsWith("Ext.Forms")) && !typeName.startsWith("Processes.") && !typeName.startsWith("Types.");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private DynamicRef addReference(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull XmlTypeDescription xmlotd) {
        BpmObjectDynamicRef bpmObjectDynamicRef;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not be null");
        }
        if (xmlotd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not be null");
        }
        String schemaId = xmlotd.getId();
        BpmObjectDynamicRef ref = new BpmObjectDynamicRef((ObjectTypeDescription)xmlotd, this.getCatalog());
        if (Utils.isBpmObjectNamespace(xmlotd.getNamespace())) {
            bpmObjectDynamicRef = ref;
            if (bpmObjectDynamicRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not return null");
            return bpmObjectDynamicRef;
        }
        Set<String> schemas = this.referencesByTypeName.get(typeName);
        if (schemas == null) {
            schemas = new HashSet<String>();
            this.referencesByTypeName.put(typeName, schemas);
        }
        schemas.add(schemaId);
        Set<String> objects = this.typeNameByReference.get(schemaId);
        if (objects == null) {
            objects = new HashSet<String>();
            this.typeNameByReference.put(schemaId, objects);
        }
        objects.add(typeName);
        if (this.bpmObjectsBySchema.containsKey((Object)schemaId)) {
            bpmObjectDynamicRef = ref;
            if (bpmObjectDynamicRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not return null");
            return bpmObjectDynamicRef;
        }
        this.createSynthesized(typeIndex, schemaId);
        bpmObjectDynamicRef = ref;
        if (bpmObjectDynamicRef != null) return bpmObjectDynamicRef;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addReference must not return null");
    }

    private void createSynthesized(@NotNull MutableTypeIndex typeIndex, String schemaId) {
        String fullName;
        XmlTypeDescription xmlOtd;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.createSynthesized must not be null");
        }
        if (!this.synthesizedByName.containsValue((Object)schemaId) && (xmlOtd = this.getXmlObjectType(typeIndex, schemaId)) != null && !this.synthesizedByName.containsKey((Object)(fullName = xmlOtd.getXmlElementType() == XmlElementType.FAULT ? this.buildExceptionName(xmlOtd) : this.buildName(xmlOtd)))) {
            this.synthesizedByName.put((Object)fullName, (Object)schemaId);
            this.addSynthToCatalog(typeIndex, xmlOtd, fullName);
        }
    }

    private String buildExceptionName(@NotNull XmlTypeDescription newXmlOtd) {
        String fullName;
        if (newXmlOtd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.buildExceptionName must not be null");
        }
        int count = 1;
        String result = fullName = "Errors." + newXmlOtd.getName();
        String schemaId = (String)this.synthesizedByName.get((Object)result);
        while (schemaId != null && !schemaId.equals(newXmlOtd.getId())) {
            result = fullName + count;
            schemaId = (String)this.synthesizedByName.get((Object)result);
            ++count;
        }
        return result;
    }

    @Nullable
    private XmlTypeDescription getXmlObjectType(@NotNull MutableTypeIndex typeIndex, String schemaId) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.getXmlObjectType must not be null");
        }
        TypeRef typeRef = typeIndex.findById(ComponentType.XML.getText(), schemaId);
        return typeRef != null ? (XmlTypeDescription)typeRef.get() : null;
    }

    private void addSynthToCatalog(@NotNull MutableTypeIndex typeIndex, XmlTypeDescription xmlotd, String fullName) {
        block7: {
            if (typeIndex == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addSynthToCatalog must not be null");
            }
            try {
                ObjectTypeDescription module;
                XObjectTypeDescription xotd = this.buildObject(fullName, xmlotd);
                if (xmlotd.getXmlElementType() == XmlElementType.FAULT) {
                    xotd.addModifier(262144L);
                    TypeRef ref = typeIndex.findExact("Errors");
                    assert (ref != null);
                    module = ref.get().asObject();
                } else {
                    TypeRef ref = typeIndex.findExact("Types");
                    assert (ref != null);
                    module = ref.get().asObject();
                }
                module.addInnerType((TypeRef)xotd);
                typeIndex.add((ObjectTypeDescription)xotd, "");
            }
            catch (TypeCatalogException e) {
                if (!Log.isDebugging()) break block7;
                Log.logDebug((Throwable)e);
            }
        }
    }

    private String buildName(@NotNull XmlTypeDescription newXmlOtd) {
        String fullName;
        if (newXmlOtd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.buildName must not be null");
        }
        int count = 1;
        String result = fullName = "Types." + newXmlOtd.getName();
        String schemaId = (String)this.synthesizedByName.get((Object)result);
        while (schemaId != null && !schemaId.equals(newXmlOtd.getId())) {
            result = fullName + count;
            schemaId = (String)this.synthesizedByName.get((Object)result);
            ++count;
        }
        return result;
    }

    private void addBpmObject(@NotNull MutableTypeIndex typeIndex, @NotNull XObjectTypeDescription xotd, @NotNull String typeName) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addBpmObject must not be null");
        }
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addBpmObject must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.addBpmObject must not be null");
        }
        String schemaId = xotd.getProperty("attributes.schema.id");
        String bpmoTypeName = (String)this.bpmObjectsBySchema.get((Object)schemaId);
        if (bpmoTypeName != null) {
            if (bpmoTypeName.equals(typeName)) {
                return;
            }
            throw new IllegalStateException("There is already another BPM Object based on schema id '" + schemaId + "'");
        }
        this.bpmObjectsBySchema.put((Object)schemaId, (Object)typeName);
        this.removeSynthesized(typeIndex, schemaId);
    }

    private XObjectTypeDescription buildObject(@NotNull String fullName, @NotNull XmlTypeDescription xmlotd) {
        if (fullName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.buildObject must not be null");
        }
        if (xmlotd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.buildObject must not be null");
        }
        String name = this.getObjectName(fullName);
        XObjectTypeDescription xotd = BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr((String)name, (ComponentCatalog)this.getCatalog(), (XmlTypeDescription)xmlotd);
        xotd.setModifiers(xotd.getModifiers() | 0x100000000L | 0x20000L);
        return xotd;
    }

    private String getObjectName(@NotNull String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.getObjectName must not be null");
        }
        int i = fullName.lastIndexOf(46);
        if (i != -1) {
            return fullName.substring(i + 1);
        }
        return fullName;
    }

    private void removeTypeReferences(@NotNull MutableTypeIndex typeIndex, String typeName) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.removeTypeReferences must not be null");
        }
        Set<String> schemas = this.referencesByTypeName.remove(typeName);
        for (String schemaId : schemas) {
            Set<String> references = this.typeNameByReference.get(schemaId);
            references.remove(typeName);
            if (!references.isEmpty()) continue;
            this.removeSynthesized(typeIndex, schemaId);
        }
    }

    private void removeSynthesized(@NotNull MutableTypeIndex typeIndex, String schemaId) {
        block7: {
            if (typeIndex == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.removeSynthesized must not be null");
            }
            String synthesizedTypeName = (String)this.synthesizedByName.inverse().remove((Object)schemaId);
            if (synthesizedTypeName != null) {
                try {
                    TypeRef typeRef = typeIndex.findExact(synthesizedTypeName);
                    if (typeRef != null) {
                        ObjectTypeDescription parent;
                        TypeRef innerType;
                        long modifiers = typeRef.getModifiers();
                        TypeRef ref = typeIndex.findExact(TypeUtils.moduleName((String)synthesizedTypeName, (String)synthesizedTypeName));
                        if (ref != null && (innerType = (parent = ref.get().asObject()).findInnerType(TypeUtils.shortName((String)synthesizedTypeName))) != null) {
                            parent.asObject().removeInnerType(innerType);
                        }
                        typeIndex.remove(synthesizedTypeName);
                        if (Modifier.isException((long)modifiers)) {
                            this.typeRemoved(typeIndex, synthesizedTypeName);
                        }
                    }
                }
                catch (TypeCatalogException e) {
                    if (!Log.isDebugging()) break block7;
                    Log.logDebug((Throwable)e);
                }
            }
        }
    }

    private void fixArgument(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull Argument argument) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArgument must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArgument must not be null");
        }
        if (argument == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArgument must not be null");
        }
        TypeDescription td = this.getType(typeIndex, argument.getTypeRef());
        if (td instanceof XmlTypeDescription) {
            argument.setType((TypeRef)this.addReference(typeIndex, typeName, (XmlTypeDescription)td));
        } else if (td.isArray()) {
            argument.setType(this.fixArray(typeIndex, typeName, (ArrayTypeDescription)td));
        }
    }

    private TypeRef fixArray(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ArrayTypeDescription artd) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArray must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArray must not be null");
        }
        if (artd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixArray must not be null");
        }
        TypeDescription td = this.getType(typeIndex, artd.getElementTypeRef());
        if (td.isArray()) {
            return this.fixArray(typeIndex, typeName, (ArrayTypeDescription)td);
        }
        if (td instanceof XmlTypeDescription) {
            artd.setElementType((TypeRef)this.addReference(typeIndex, typeName, (XmlTypeDescription)td));
        }
        return artd.getRef();
    }

    private void fixAttribute(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull AttributeTypeDescription atd) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixAttribute must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixAttribute must not be null");
        }
        if (atd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.fixAttribute must not be null");
        }
        TypeDescription td = this.getType(typeIndex, atd.getTypeRef());
        if (td instanceof XmlTypeDescription && !((XmlTypeDescription)td).isPointer()) {
            atd.setType((TypeRef)this.addReference(typeIndex, typeName, (XmlTypeDescription)td));
        } else if (td.isArray()) {
            atd.setType(this.fixArray(typeIndex, typeName, (ArrayTypeDescription)td));
        }
    }

    private TypeDescription getType(@NotNull MutableTypeIndex typeIndex, @NotNull TypeRef ref) {
        TypeDescription result;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.getType must not be null");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/XmlSchemaReferenceManager.getType must not be null");
        }
        if (ref instanceof DynamicRef) {
            DynamicRef dynamicRef = (DynamicRef)ref;
            TypeRef typeRef = typeIndex.findById(ComponentType.XML.getText(), dynamicRef.getId());
            result = typeRef == null ? ref.get() : typeRef.get();
        } else {
            result = ref.get();
        }
        return result;
    }
}

