/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.BundleCatalogView;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.PropertyProvider;
import oracle.bpm.type.PropertyVisitor;
import oracle.bpm.type.SimplePropertyIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ComponentBundleTypeIndex
implements MutableTypeIndex {
    private ComponentCatalog catalog;
    private SimplePropertyIndex propertyIndex;
    private Map<String, TypeDescription> typesByName;

    public ComponentBundleTypeIndex(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.<init> must not be null");
        }
        this.typesByName = new HashMap<String, TypeDescription>();
        this.catalog = catalog;
        this.propertyIndex = new SimplePropertyIndex();
    }

    public TypeRef findExact(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findExact must not be null");
        }
        TypeRef ref = (TypeRef)this.typesByName.get(typeName);
        if (ref == null) {
            try {
                ref = this.catalog.find(typeName);
            }
            catch (AmbiguousTypeNameException ambiguousTypeNameException) {
                // empty catch block
            }
        }
        return ref;
    }

    public TypeRef findById(@NotNull String componentType, @NotNull String id) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findById must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findById must not be null");
        }
        TypeRef ref = null;
        SortedSet types = this.propertyIndex.findByPropertyValue("typeId", id);
        for (String type : types) {
            TypeRef exact = this.findExact(type);
            if (exact == null || !componentType.equals(exact.getComponentType())) continue;
            if (ref != null) {
                throw new IllegalStateException("Multiple objects with component type '" + componentType + "' and id '" + id + "' have been found on the index");
            }
            ref = exact;
        }
        if (ref == null) {
            ref = this.catalog.findById(componentType, id);
        }
        return ref;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SortedSet<TypeRef> findByPropertyValue(@NotNull String propertyName, @NotNull String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findByPropertyValue must not be null");
        }
        if (propertyValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findByPropertyValue must not be null");
        }
        TreeSet<TypeRef> result = new TreeSet<TypeRef>();
        SortedSet types = this.propertyIndex.findByPropertyValue(propertyName, propertyValue);
        types.addAll(this.catalog.findByPropertyValue(propertyName, propertyValue));
        for (String type : types) {
            TypeRef ref = this.findExact(type);
            if (ref == null) continue;
            result.add(ref);
        }
        TreeSet<TypeRef> treeSet = result;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.findByPropertyValue must not return null");
        }
        return treeSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeRef add(@NotNull ObjectTypeDescription otd, @NotNull String module) throws TypeCatalogException {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.add must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.add must not be null");
        }
        TypeRef typeRef = this.getCatalogView().addNoStore(otd, module);
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.add must not return null");
        }
        return typeRef;
    }

    public void remove(@NotNull String typeName) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.remove must not be null");
        }
        this.indexTypeRemoved(typeName);
        this.getCatalogView().removeNoStore(typeName);
    }

    public void update(@NotNull ObjectTypeDescription type) throws TypeCatalogException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex.update must not be null");
        }
    }

    public List<String> getTypeNames() {
        return new ArrayList<String>(this.typesByName.keySet());
    }

    public Map<String, TypeDescription> getTypesByName() {
        return new HashMap<String, TypeDescription>(this.typesByName);
    }

    public TypeDescription findLocal(String name) {
        return this.typesByName.get(name);
    }

    void indexTypeAdded(String typeName, TypeDescription type) {
        this.typesByName.put(typeName, type);
        this.propertyIndex.addType(typeName, (PropertyProvider)new TypePropertyProvider(type));
    }

    void indexTypeRemoved(String typeName) {
        TypeRef type = (TypeRef)this.typesByName.remove(typeName);
        if (type != null) {
            this.propertyIndex.removeType(typeName, (PropertyProvider)new TypePropertyProvider(type.get()));
        }
    }

    void clear() {
        this.propertyIndex.clear();
        this.typesByName.clear();
    }

    private BundleCatalogView getCatalogView() {
        return (BundleCatalogView)this.catalog;
    }

    private static class TypePropertyProvider
    implements PropertyProvider {
        private final TypeDescription td;

        public TypePropertyProvider(TypeDescription td) {
            this.td = td;
        }

        public void visitProperties(@NotNull PropertyVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ComponentBundleTypeIndex$TypePropertyProvider.visitProperties must not be null");
            }
            if (this.td instanceof ObjectTypeDescription) {
                ObjectTypeDescription otd = this.td.asObject();
                TypeUtils.visitProperties((Map)otd.getProperties(), (PropertyVisitor)visitor);
            }
        }
    }
}

