/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser.preprocessor;

import fuego.parser.CodeGenerator;
import fuego.parser.Tool;
import fuego.parser.collections.impl.IndexedVector;
import fuego.parser.preprocessor.GrammarFile;
import fuego.parser.preprocessor.Hierarchy;
import fuego.parser.preprocessor.Option;
import fuego.parser.preprocessor.Rule;
import java.io.IOException;

class Grammar {
    protected boolean alreadyExpanded = false;
    protected Tool antlrTool;
    protected String exportVocab = null;
    protected String fileName;
    protected Hierarchy hier;
    protected String importVocab = null;
    protected String memberAction;
    protected String name;
    protected IndexedVector<String, Option> options;
    protected String preambleAction;
    protected boolean predefined = false;
    protected IndexedVector<String, Rule> rules;
    protected boolean specifiedVocabulary = false;
    protected String superGrammar;
    protected String tokenSection;
    protected String type;

    public Grammar(Tool tool, String name, String superGrammar, IndexedVector<String, Rule> rules) {
        this.name = name;
        this.superGrammar = superGrammar;
        this.rules = rules;
        this.antlrTool = tool;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setHierarchy(Hierarchy hier) {
        this.hier = hier;
    }

    public void setMemberAction(String a) {
        this.memberAction = a;
    }

    public String getName() {
        return this.name;
    }

    public void setOptions(IndexedVector<String, Option> options) {
        this.options = options;
    }

    public IndexedVector<String, Option> getOptions() {
        return this.options;
    }

    public void setPreambleAction(String a) {
        this.preambleAction = a;
    }

    public void setPredefined(boolean b) {
        this.predefined = b;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public IndexedVector<String, Rule> getRules() {
        return this.rules;
    }

    public Grammar getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        return this.hier.getGrammar(this.superGrammar);
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public void setTokenSection(String tk) {
        this.tokenSection = tk;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void addOption(Option o) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(o.getName(), o);
    }

    public void addRule(Rule r) {
        this.rules.appendElement(r.getName(), r);
    }

    public void expandInPlace() {
        if (this.alreadyExpanded) {
            return;
        }
        Grammar superG = this.getSuperGrammar();
        if (superG == null) {
            return;
        }
        if (this.exportVocab == null) {
            this.exportVocab = this.getName();
        }
        if (superG.isPredefined()) {
            return;
        }
        superG.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile gf = this.hier.getFile(this.getFileName());
        gf.setExpanded(true);
        for (Rule r : superG.getRules()) {
            this.inherit(r, superG);
        }
        IndexedVector<String, Option> inhOptions = superG.getOptions();
        if (inhOptions != null) {
            for (Option o : inhOptions) {
                this.inherit(o);
            }
        }
        if (this.options != null && this.options.getElement("importVocab") == null || this.options == null) {
            Option inputV = new Option("importVocab", superG.exportVocab + ";", this);
            this.addOption(inputV);
            String originatingGrFileName = superG.getFileName();
            String path = this.antlrTool.pathToFile(originatingGrFileName);
            String superExportVocabFileName = path + superG.exportVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt;
            String newImportVocabFileName = this.antlrTool.fileMinusPath(superExportVocabFileName);
            if (!path.equals("." + System.getProperty("file.separator"))) {
                try {
                    this.antlrTool.copyFile(superExportVocabFileName, newImportVocabFileName);
                }
                catch (IOException io) {
                    this.antlrTool.toolError("cannot find/copy importVocab file " + superExportVocabFileName);
                    return;
                }
            }
        }
        this.inherit(superG.memberAction);
    }

    public void inherit(Option o) {
        if ("importVocab".equals(o.getName()) || "exportVocab".equals(o.getName())) {
            return;
        }
        Option overriddenOption = null;
        if (this.options != null) {
            overriddenOption = this.options.getElement(o.getName());
        }
        if (overriddenOption == null) {
            this.addOption(o);
        }
    }

    public void inherit(Rule r, Grammar superG) {
        Rule overriddenRule = this.rules.getElement(r.getName());
        if (overriddenRule != null) {
            if (!overriddenRule.sameSignature(r)) {
                this.antlrTool.warning("rule " + this.getName() + "." + overriddenRule.getName() + " has different signature than " + superG.getName() + "." + overriddenRule.getName());
            }
        } else {
            this.addRule(r);
        }
    }

    public void inherit(String action) {
        if (this.memberAction != null) {
            return;
        }
        if (action != null) {
            this.memberAction = action;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(10000);
        if (this.preambleAction != null) {
            s.append(this.preambleAction);
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ";";
        }
        String sup = "";
        s.append("class ").append(this.name).append(" extends ").append(this.type).append(";").append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        if (this.options != null) {
            s.append(Hierarchy.optionsToString(this.options));
        }
        if (this.tokenSection != null) {
            s.append(this.tokenSection).append("\n");
        }
        if (this.memberAction != null) {
            s.append(this.memberAction).append(System.getProperty("line.separator"));
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule r = this.rules.elementAt(i);
            if (!this.getName().equals(r.enclosingGrammar.getName())) {
                s.append("// inherited from grammar ").append(r.enclosingGrammar.getName()).append(System.getProperty("line.separator"));
            }
            s.append(r).append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        }
        return s.toString();
    }
}

