/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser.collections.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Vector<E>
implements Cloneable,
Iterable<E> {
    protected E[] data;
    protected int lastElement = -1;

    public Vector() {
        this(10);
    }

    public Vector(int size) {
        this.data = new Object[size];
    }

    public synchronized void setElementAt(E obj, int i) {
        if (i >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(i + " >= " + this.data.length);
        }
        this.data[i] = obj;
        if (i > this.lastElement) {
            this.lastElement = i;
        }
    }

    public synchronized void appendElement(E o) {
        this.ensureCapacity(this.lastElement + 2);
        this.data[++this.lastElement] = o;
    }

    public int capacity() {
        return this.data.length;
    }

    public Vector<E> clone() {
        Vector<E> result = new Vector<E>(this.size());
        System.arraycopy(this.data, 0, result.data, 0, this.size());
        return result;
    }

    public synchronized E elementAt(int idx) {
        if (idx >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(idx + " >= " + this.data.length);
        }
        if (idx < 0) {
            throw new ArrayIndexOutOfBoundsException(idx + " < 0 ");
        }
        return this.data[idx];
    }

    public synchronized void ensureCapacity(int minIndex) {
        if (minIndex + 1 > this.data.length) {
            E[] oldData = this.data;
            int n = this.data.length * 2;
            if (minIndex + 1 > n) {
                n = minIndex + 1;
            }
            this.data = new Object[n];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    public synchronized boolean removeElement(Object o) {
        int i;
        for (i = 0; i <= this.lastElement && this.data[i] != o; ++i) {
        }
        if (i <= this.lastElement) {
            this.data[i] = null;
            int above = this.lastElement - i;
            if (above > 0) {
                System.arraycopy(this.data, i + 1, this.data, i, above);
            }
            --this.lastElement;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lastElement + 1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    return this.i <= Vector.this.lastElement;
                }
            }

            @Override
            public E next() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.i <= Vector.this.lastElement) {
                        return Vector.this.data[this.i++];
                    }
                    throw new NoSuchElementException("VectorEnumerator");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

