/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.ASTPair;
import fuego.parser.CommonAST;
import fuego.parser.Token;
import fuego.parser.collections.AST;
import fuego.parser.collections.impl.ASTArray;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;

public class ASTFactory {
    protected String theASTNodeType = null;
    protected Class theASTNodeTypeClass = null;
    protected Map<Integer, Class> tokenTypeToClassMap = null;

    public void setASTNodeType(String t) {
        this.theASTNodeType = t;
        try {
            this.theASTNodeTypeClass = Class.forName(t);
        }
        catch (Exception e) {
            this.error("Can't find/access AST Node type" + t);
        }
    }

    public Class getASTNodeType(int tokenType) {
        Class c;
        if (this.tokenTypeToClassMap != null && (c = this.tokenTypeToClassMap.get(tokenType)) != null) {
            return c;
        }
        if (this.theASTNodeTypeClass != null) {
            return this.theASTNodeTypeClass;
        }
        return CommonAST.class;
    }

    public void setTokenTypeASTNodeType(int tokenType, String className) throws IllegalArgumentException {
        if (this.tokenTypeToClassMap == null) {
            this.tokenTypeToClassMap = new Hashtable<Integer, Class>();
        }
        if (className == null) {
            this.tokenTypeToClassMap.remove(tokenType);
            return;
        }
        try {
            Class<?> c = Class.forName(className);
            this.tokenTypeToClassMap.put(tokenType, c);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class, " + className);
        }
    }

    public void addASTChild(ASTPair currentAST, AST child) {
        if (child != null) {
            if (currentAST.root == null) {
                currentAST.root = child;
            } else if (currentAST.child == null) {
                currentAST.root.setFirstChild(child);
            } else {
                currentAST.child.setNextSibling(child);
            }
            currentAST.child = child;
            currentAST.advanceChildToEnd();
        }
    }

    public AST create() {
        return this.create(0);
    }

    public AST create(int type) {
        Class c = this.getASTNodeType(type);
        AST t = this.create(c);
        if (t != null) {
            t.initialize(type, "");
        }
        return t;
    }

    public AST create(int type, String txt) {
        AST t = this.create(type);
        if (t != null) {
            t.initialize(type, txt);
        }
        return t;
    }

    public AST create(int type, String txt, String className) {
        AST t = this.create(className);
        if (t != null) {
            t.initialize(type, txt);
        }
        return t;
    }

    public AST create(AST tr) {
        if (tr == null) {
            return null;
        }
        AST t = this.create(tr.getType());
        if (t != null) {
            t.initialize(tr);
        }
        return t;
    }

    public AST create(Token tok) {
        AST t = this.create(tok.getType());
        if (t != null) {
            t.initialize(tok);
        }
        return t;
    }

    public AST create(Token tok, String className) {
        AST t = this.createUsingCtor(tok, className);
        if (t != null) {
            t.initialize(tok);
        }
        return t;
    }

    public AST dup(AST t) {
        if (t == null) {
            return null;
        }
        AST dup_t = this.create(t.getClass());
        dup_t.initialize(t.getType(), t.getText());
        return dup_t;
    }

    public AST dupList(AST t) {
        AST result;
        AST nt = result = this.dupTree(t);
        while (t != null) {
            t = t.getNextSibling();
            nt.setNextSibling(this.dupTree(t));
            nt = nt.getNextSibling();
        }
        return result;
    }

    public AST dupTree(AST t) {
        AST result = this.dup(t);
        if (t != null) {
            result.setFirstChild(this.dupList(t.getFirstChild()));
        }
        return result;
    }

    public void error(String e) {
        System.err.println(e);
    }

    public AST make(AST[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        AST root = nodes[0];
        if (root != null) {
            root.setFirstChild(null);
        }
        AST tail = null;
        for (int i = 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            if (root == null) {
                root = tail = nodes[i];
            } else if (tail == null) {
                root.setFirstChild(nodes[i]);
                tail = root.getFirstChild();
            } else {
                tail.setNextSibling(nodes[i]);
                tail = tail.getNextSibling();
            }
            while (tail.getNextSibling() != null) {
                tail = tail.getNextSibling();
            }
        }
        return root;
    }

    public AST make(ASTArray nodes) {
        return this.make(nodes.array);
    }

    public void makeASTRoot(ASTPair currentAST, AST root) {
        if (root != null) {
            root.addChild(currentAST.root);
            currentAST.child = currentAST.root;
            currentAST.advanceChildToEnd();
            currentAST.root = root;
        }
    }

    protected AST create(String className) {
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class, " + className);
        }
        return this.create(c);
    }

    protected AST create(Class c) {
        AST t;
        try {
            t = (AST)c.newInstance();
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }

    protected AST createUsingCtor(Token token, String className) {
        AST t;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> ctor = c.getConstructor(Token.class);
            t = ctor != null ? (AST)ctor.newInstance(token) : this.create(c);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }
}

