/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.repository.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import javax.swing.SwingUtilities;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileChangeListener;
import oracle.ide.index.file.FileChangeManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import org.jetbrains.annotations.NotNull;

public class FusionFileSystem
extends JavaFileSystem {
    private Project devProject;
    private FileChangeListener fileChangeListener;
    private Workspace workspace;

    public FusionFileSystem(File fileSystemRoot, @NotNull Workspace workspace, @NotNull Project devProject) {
        super(fileSystemRoot);
        this.workspace = workspace;
        this.devProject = devProject;
        this.startListening();
    }

    public void dispose() {
        if (this.fileChangeListener != null) {
            FileChangeManager mgr = FileChangeManager.getFileChangeManager();
            mgr.removeFileChangeListener(this.workspace, this.devProject, this.fileChangeListener);
        }
    }

    @Override
    protected boolean delete(@NotNull File file) {
        boolean result = false;
        try {
            URL url = file.toURI().toURL();
            result = URLFileSystem.delete((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected OutputStream createOutputStream(File file) throws IOException {
        URL url = file.toURI().toURL();
        return URLFileSystem.openOutputStream((URL)url);
    }

    private static URL removeFragment(URL url) {
        if (url.getRef() != null) {
            Log.logWarning(new IllegalArgumentException("Unexpected URL: " + url));
            try {
                return new URL(url, url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    private void startListening() {
        URL rootUrl = this.getRootUrl();
        if (rootUrl != null) {
            FileChangeManager mgr = FileChangeManager.getFileChangeManager();
            mgr.addFileChangeListener(this.workspace, this.devProject, this.getFileChangeListener());
        }
    }

    private URL getRootUrl() {
        URL result;
        try {
            File root = this.getFileSystemRoot();
            result = root.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return result;
    }

    private FileChangeListener getFileChangeListener() {
        if (this.fileChangeListener == null) {
            this.fileChangeListener = new FileChangeListener(){

                public void filesChanged(Workspace workspace, final Project project, Collection<FileChange> changes) {
                    final Sequence<VFileEvent> eventSequence = CollectionUtils.asSequence(changes).map(new Function<FileChange, VFileEvent>(){

                        @Override
                        public VFileEvent eval(FileChange change) {
                            VFileEvent result;
                            URL url = change.getURL();
                            URL projectUrl = project.getURL();
                            URL parentUrl = URLFileSystem.getParent((URL)projectUrl);
                            if (URLFileSystem.isBaseURLFor((URL)parentUrl, (URL)url)) {
                                File f;
                                URL url2 = FusionFileSystem.removeFragment(url);
                                try {
                                    f = new File(url2.toURI());
                                }
                                catch (URISyntaxException ignore) {
                                    f = new File(url.getPath());
                                }
                                catch (IllegalArgumentException e) {
                                    throw new IllegalArgumentException("Unsupported URL : " + url, e);
                                }
                                VFile vFile = FusionFileSystem.this.toVFile(f);
                                FileChange.Type type = change.getType();
                                switch (type) {
                                    case FILE_ADDED: {
                                        result = new VFileEvent(VEventType.ADD, vFile);
                                        break;
                                    }
                                    case TEXT_BUFFER_MODIFIED: {
                                        if (vFile.getName().equals("composite.xml")) {
                                            result = new VFileEvent(VEventType.CHANGE, vFile);
                                            break;
                                        }
                                        result = null;
                                        break;
                                    }
                                    case FILE_CHANGED: {
                                        result = new VFileEvent(VEventType.CHANGE, vFile);
                                        break;
                                    }
                                    case FILE_REMOVED: {
                                        result = new VFileEvent(VEventType.REMOVE, vFile);
                                        FusionFileSystem.this.removeObject(url);
                                        break;
                                    }
                                    default: {
                                        result = null;
                                        break;
                                    }
                                }
                            } else {
                                result = null;
                            }
                            return result;
                        }
                    }).selectInstanceOf(VFileEvent.class);
                    Runnable dispatcher = new Runnable(){

                        @Override
                        public void run() {
                            for (VFileEvent vFileEvent : eventSequence) {
                                FusionFileSystem.this.fireEvent(vFileEvent);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        dispatcher.run();
                    } else {
                        SwingUtilities.invokeLater(dispatcher);
                    }
                }
            };
        }
        return this.fileChangeListener;
    }

    private void reloadNode(URL url, Project project, long ts) {
        Node node = NodeFactory.find((URL)url);
        if (node != null && node.getTimestamp() != ts && node instanceof ProjectObjectNode) {
            ProjectObject object = ((ProjectObjectNode)node).getObject();
            FusionProjectRepository repository = (FusionProjectRepository)AbstractStudioWorkbench.getInstance().getRepository();
            ProjectLoader loader = repository.getProject(project).getLoader();
            if (loader != null) {
                try {
                    ProjectObject projectObject = loader.replaceProjectObject(object);
                    ((ProjectObjectNode)node).replaceObject(projectObject);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void removeObject(URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node != null && node instanceof ProjectObjectNode) {
            ProjectObject object = ((ProjectObjectNode)node).getObject();
            try {
                object.delete();
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }
}

