/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.repository;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.fusion.repository.BPMProjectSettings;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.repository.JdevRepositoryChangeEvent;
import oracle.bpm.fusion.repository.JdevRepositoryEventType;
import oracle.bpm.fusion.repository.JdevRepositoryServiceListener;
import oracle.bpm.log.Log;
import oracle.bpm.observers.Observable;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.navigator.ApplicationChangeNotifier;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.util.PatternFilters;
import oracle.jdeveloper.model.JProjectTechnologyEvent;
import oracle.jdeveloper.model.JProjectTechnologyListener;
import oracle.jdeveloper.model.JProjectTechnologyNotifier;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdevRepositoryService
implements Observable<JdevRepositoryServiceListener> {
    private JProjectTechnologyListener bpmTechnologyListener;
    private Collection<JdevRepositoryServiceListener> listeners = new ArrayList<JdevRepositoryServiceListener>();
    private Map<Workspace, FusionProjectRepository> repositoriesByWorkspace = new HashMap<Workspace, FusionProjectRepository>();
    private static JdevRepositoryService instance;
    private static final String BPM_PROJECT_SETTINGS_KEY;
    private static final String BPM_PROJECT_PROCESSES_CONTENT_SET_LOCAL_KEY = "bpmProjectsProcessesContentSet";
    private static final String BPM_PROJECT_PROCESSES_CONTENT_SET_KEY;

    private JdevRepositoryService() {
        this.initialize();
    }

    public static synchronized JdevRepositoryService getInstance() {
        if (instance == null) {
            instance = new JdevRepositoryService();
        }
        return instance;
    }

    public static Workspace getWorkspace(Project project) {
        Workspace result = null;
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace.containsChild((Element)project)) {
            result = activeWorkspace;
        } else {
            Workspaces workspaces = Ide.getWorkspaces();
            for (Workspace workspace : workspaces.workspaces()) {
                if (!workspace.containsChild((Element)project)) continue;
                result = workspace;
                break;
            }
            if (result == null) {
                result = activeWorkspace;
            }
        }
        return result;
    }

    public void applicationChanged(Workspace application) {
        FusionProjectRepository repository = null;
        if (application != null) {
            repository = this.getOrCreate(application);
            this.setActiveRepository((ProjectRepository)repository);
        } else {
            this.setActiveRepository(null);
        }
        this.fireRepositoryChanged(JdevRepositoryChangeEvent.create(JdevRepositoryEventType.REPOSITORY_SELECTED, (ProjectRepository)repository, application));
    }

    @Override
    public void addObserver(JdevRepositoryServiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeObserver(JdevRepositoryServiceListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public FusionProjectRepository getRepository(@NotNull URL url) {
        FusionProjectRepository result = null;
        if (result == null) {
            block0: for (FusionProjectRepository repository : this.repositoriesByWorkspace.values()) {
                List<String> projectPaths = repository.getAllProjectPaths();
                for (String projectPath : projectPaths) {
                    if (!url.getPath().startsWith(projectPath)) continue;
                    result = repository;
                    continue block0;
                }
            }
        }
        return result;
    }

    @Nullable
    public oracle.bpm.project.model.Project getProject(@NotNull Project jDevProject) {
        URL url = jDevProject.getURL();
        FusionProjectRepository repository = this.getRepository(url);
        return repository != null ? repository.getProject(url) : null;
    }

    public ProjectObject getProjectObject(@NotNull URL url) {
        FusionProjectRepository repository = this.getRepository(url);
        return repository != null ? repository.getProjectObject(url) : null;
    }

    public void syncRepositories() {
        Workspace activeWorkspace = JdevRepositoryService.getActiveWorkspace();
        if (activeWorkspace != null) {
            FusionProjectRepository repository = this.getOrCreate(activeWorkspace);
            this.setActiveRepository((ProjectRepository)repository);
        }
        for (Workspace workspace : Ide.getWorkspaces().workspaces()) {
            FusionProjectRepository repository = this.getOrCreate(workspace);
        }
    }

    private static Workspace getActiveWorkspace() {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace == null) {
            Iterator iterator = NodeFactory.getCachedNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Workspace)) continue;
                workspace = (Workspace)node;
                break;
            }
        }
        return workspace;
    }

    private void initialize() {
        this.initContentSet();
        this.syncRepositories();
        this.startListeningApplicationEvents();
        this.startListeningBpmTechnology();
    }

    private void applicationAdded(Workspace application) {
        Ide.setActiveWorkspace((Workspace)application);
        FusionProjectRepository repository = this.getOrCreate(application);
        this.setActiveRepository((ProjectRepository)repository);
        this.fireRepositoryAdded(JdevRepositoryChangeEvent.create(JdevRepositoryEventType.REPOSITORY_ADDED, (ProjectRepository)repository, application));
    }

    private void applicationRemoved(Workspace application) {
        FusionProjectRepository projectRepository = this.removeFusionRepository(application);
        this.fireRepositoryRemoved(JdevRepositoryChangeEvent.create(JdevRepositoryEventType.REPOSITORY_REMOVED, (ProjectRepository)projectRepository, application));
    }

    private void setActiveRepository(ProjectRepository repository) {
        RepositoryService.getInstance().setActiveRepository(repository);
    }

    private void startListeningBpmTechnology() {
        JProjectTechnologyNotifier.registerTechnologyListener((String)"BPM", (JProjectTechnologyListener)this.getBpmTechnologyListener());
    }

    private void projectAdded(Project project) {
        Workspace workspace = JdevRepositoryService.getWorkspace(project);
        FusionProjectRepository repository = this.getOrCreate(workspace);
        try {
            repository.create(project);
        }
        catch (ProjectException e) {
            Log.logTrace(e);
        }
    }

    private JProjectTechnologyListener getBpmTechnologyListener() {
        if (this.bpmTechnologyListener == null) {
            this.bpmTechnologyListener = new JProjectTechnologyListener(){

                public void technologyAdded(JProjectTechnologyEvent technologyEvent) {
                    Project project = technologyEvent.getProject();
                    Workspace workspace = JdevRepositoryService.getWorkspace(project);
                    if (!AbstractStudioWorkbench.getInstance().isBusinessAnalyst()) {
                        try {
                            boolean exists = MDSHelper.doesSOASharedEntryExists((Workspace)workspace);
                            if (!exists) {
                                MDSHelper.createSOASharedMDSEntry((Workspace)workspace);
                            }
                        }
                        catch (Exception e) {
                            Log.logSevere(e);
                        }
                    }
                    JdevRepositoryService.this.projectAdded(project);
                }

                public void technologyRemoved(JProjectTechnologyEvent technologyEvent) {
                    Project project = technologyEvent.getProject();
                    Workspace workspace = JdevRepositoryService.getWorkspace(project);
                    try {
                        JdevRepositoryService.this.getOrCreate(workspace).delete(project);
                    }
                    catch (ProjectException e) {
                        Log.logTrace(e);
                    }
                }
            };
        }
        return this.bpmTechnologyListener;
    }

    private void initContentSet() {
        ProjectContent.registerContentSetProvider((ContentSetProvider)new BPMProjectContentSet(BPM_PROJECT_PROCESSES_CONTENT_SET_KEY, ProjectMsg.BPM_CONTENT.getString(), Path.ROOT.toString()));
    }

    private void startListeningApplicationEvents() {
        Ide.getWorkspaces().attach(new Observer(){

            public void update(Object o, UpdateMessage updateMessage) {
                int id = updateMessage.getMessageID();
                if (id == UpdateMessage.CHILD_ADDED) {
                    Workspace application = (Workspace)updateMessage.getAddObjects().iterator().next();
                    JdevRepositoryService.this.applicationAdded(application);
                } else if (id == UpdateMessage.CHILD_REMOVED) {
                    Workspace application = (Workspace)updateMessage.getRemoveObjects().iterator().next();
                    JdevRepositoryService.this.applicationRemoved(application);
                }
            }
        });
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        if (navigatorManager != null) {
            ApplicationChangeNotifier navigatorWindow = (ApplicationChangeNotifier)navigatorManager.getNavigatorWindow();
            navigatorWindow.addApplicationChangeListener(new ApplicationChangeListener(){

                public void applicationChanged(ApplicationChangeEvent event) {
                    if (event.getStateChange() == 2) {
                        Workspace application = event.getApplication();
                        JdevRepositoryService.this.applicationChanged(application);
                    }
                }
            });
        }
    }

    private FusionProjectRepository removeFusionRepository(Workspace application) {
        FusionProjectRepository repository = this.repositoriesByWorkspace.get(application);
        this.repositoriesByWorkspace.remove(application);
        RepositoryService.getInstance().repositoryRemoved((ProjectRepository)repository);
        repository.dispose();
        return repository;
    }

    private FusionProjectRepository getOrCreate(Workspace application) {
        FusionProjectRepository repository = this.repositoriesByWorkspace.get(application);
        if (repository == null) {
            repository = this.createFusionRepository(application);
        }
        return repository;
    }

    private FusionProjectRepository createFusionRepository(Workspace application) {
        FusionProjectRepository repository = (FusionProjectRepository)AbstractStudioWorkbench.getInstance().createRepository();
        this.repositoriesByWorkspace.put(application, repository);
        repository.setWorkspace(application);
        return repository;
    }

    private void fireRepositoryChanged(JdevRepositoryChangeEvent event) {
        for (JdevRepositoryServiceListener listener : this.listeners) {
            listener.repositoryChanged(event);
        }
    }

    private void fireRepositoryAdded(JdevRepositoryChangeEvent event) {
        for (JdevRepositoryServiceListener listener : this.listeners) {
            listener.repositoryAdded(event);
        }
    }

    private void fireRepositoryRemoved(JdevRepositoryChangeEvent event) {
        for (JdevRepositoryServiceListener listener : this.listeners) {
            listener.repositoryRemoved(event);
        }
    }

    static {
        BPM_PROJECT_SETTINGS_KEY = BPMProjectSettings.class.getName();
        BPM_PROJECT_PROCESSES_CONTENT_SET_KEY = BPM_PROJECT_SETTINGS_KEY + "/" + BPM_PROJECT_PROCESSES_CONTENT_SET_LOCAL_KEY;
    }

    private class BPMProjectContentSet
    extends BaseContentSet {
        public BPMProjectContentSet(String key, String shortLabel, String root) {
            super(key, shortLabel, root);
        }

        public void initContentSet(ContentSet contentSet, URL projectURL, Context context) {
            if (contentSet.getURLPath().size() == 0) {
                URL rootURL = URLFactory.newDirURL((URL)projectURL, (String)this.root);
                contentSet.getURLPath().add(rootURL);
            }
            PatternFilters patternFilters = contentSet.getPatternFilters();
            patternFilters.addExclude("**");
            patternFilters.addInclude("processes/**");
            patternFilters.addInclude("case/**");
            patternFilters.addInclude("*.case");
            patternFilters.addInclude("*.caseactivity");
            patternFilters.addInclude("*.agdl");
            patternFilters.addInclude("organization.xml");
            patternFilters.addInclude("simulations/**");
        }
    }

    private abstract class BaseContentSet
    extends ContentSetProvider {
        protected String root;

        public BaseContentSet(String key, String shortLabel, String root) {
            super(key, shortLabel);
            this.root = root;
        }

        public Navigable getNavigable() {
            return null;
        }

        public boolean displayFoldersAsPackages() {
            return false;
        }

        public ContentSetHelper getContentSetHelper() {
            return new ContentSetHelper(this.getKey()){

                public boolean canAddContent(URL url, ProjectContent projectContent) {
                    return true;
                }
            };
        }
    }
}

