/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.rules.DecisionServiceException;
import oracle.bpel.services.rules.util.DecisionServiceBuilder;
import oracle.bpel.services.workflow.task.rules.CurrentDirectoryDictionaryFinder;
import oracle.bpel.services.workflow.util.tools.wfdecsbuilder.WFDecsSvcBuilder;
import oracle.bpm.casemgmt.caserule.MDSCaseBaseDictionaryFinder;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.metadata.Case.model.TOutcome;
import oracle.bpm.casemgmt.metadata.Case.model.TOutcomes;
import oracle.bpm.casemgmt.metadata.Case.model.TUserDefinedEvent;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.rules.sdk2.datamodel.BucketSetTable;
import oracle.rules.sdk2.datamodel.CombinedDataModel;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.datamodel.DecisionFunctionFact;
import oracle.rules.sdk2.datamodel.DecisionFunctionFactTable;
import oracle.rules.sdk2.datamodel.DecisionFunctionTable;
import oracle.rules.sdk2.datamodel.FactType;
import oracle.rules.sdk2.datamodel.FactTypeTable;
import oracle.rules.sdk2.datamodel.FormalParameter;
import oracle.rules.sdk2.datamodel.FormalParameterTable;
import oracle.rules.sdk2.datamodel.Function;
import oracle.rules.sdk2.datamodel.FunctionTable;
import oracle.rules.sdk2.datamodel.JaxbFactType;
import oracle.rules.sdk2.datamodel.JaxbNode;
import oracle.rules.sdk2.datamodel.Node;
import oracle.rules.sdk2.datamodel.NodeTable;
import oracle.rules.sdk2.datamodel.SchemaBrowser;
import oracle.rules.sdk2.datamodel.Variable;
import oracle.rules.sdk2.datamodel.VariableTable;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.decisionpoint.MetadataHelper;
import oracle.rules.sdk2.decisiontable.Bucket;
import oracle.rules.sdk2.decisiontable.BucketSet;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryLink;
import oracle.rules.sdk2.dictionary.DictionaryObject;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import oracle.rules.sdk2.repository.DictionaryFQN;
import oracle.rules.sdk2.ruleset.Action;

public class CaseDictionaryHandler {
    private static final String OPEN_BRACES = "{";
    private static final String CLOSE_BRACES = "}";
    private static final List<String> COMMON_JAVA_FACT_TYPES = new ArrayList<String>();
    private static final List<String> NON_VISIBLE_FACTS;
    private static final Map<String, String> NODENAME_TO_ALIAS;
    static final String CASE_PACKAGE = "oracle.bpm.casemgmt.metadata.caseinstance.model";
    static final String CASE_EVENT_PACKAGE = "oracle.bpm.casemgmt.metadata.event.model";
    static final String CASE_ACTION_PACKAGE = "oracle.bpm.casemgmt.caserule.model";
    static final String CASE_DATA_PACKAGE = "oracle.bpm.casemgmt.casedata.jaxb.model";
    static final String XSD_SUBDIR_NAME = "xsd";
    static final String STATEMACHINE_SCHEMA = "/xsd/TaskStateMachine.xsd";
    static final String TEMP_SRC_DIR = "/temporary/source";
    static final String TEMP_CLASSES_DIR = "/temporary/classes";
    static final String RULE_DESIGNER_CLASSES_DIR = "/.rulesdesigner/jaxb_classes/";
    public static final String RULES_SUFFIX = "Rules";
    static final String PA_XSD_FILENAME = "DecisionPoint.xsd";
    static final String PAXSD_FULLNAME = "/oracle/rules/sdk2/decisionpoint/DecisionPoint.xsd";
    static final String[] CASE_INPUTS;
    static final String[] CASE_OUTPUTS;
    private static boolean sIsPreviewMode;
    private static String sJaxbPath;
    private static String sParserPath;
    private static final String CASE_DS_NAMESPACE = "http://xmlns.oracle.com/bpm/case/caseDecision";
    static final String RULE_FILE_SUFFIX = ".rules";
    static final String RULES_SUBDIRECTORY;
    public static final String DICTIONARY_PACKAGE = "";
    static final String RULES_BASE = "Base";
    private static final String ACTIVATE_ACTIVITY = "activateActivity";
    private static final String WITHDRAW_ACTIVITY = "withdrawActivity";
    private static final String REVOKE_MILESTONE = "revokeMilestone";
    private static final String REACH_MILESTONE = "reachMilestone";
    private static final String FUNC_RETURN_TYPE = "void";
    private static final String EVENT_OBJECT_FACTORY = "oracle.bpm.casemgmt.metadata.event.model.ObjectFactory";
    private static final String EVENT_OBJECT_FACTORY_PREFIX = "CaseEventObjectFactory";
    private static final String ACTION_OBJECT_FACTORY = "oracle.bpm.casemgmt.caserule.model.ObjectFactory";
    private static final String ACTION_OBJECT_FACTORY_PREFIX = "CaseActionObjectFactory";
    private static final String CASE_OBJECT_FACTORY = "oracle.bpm.casemgmt.metadata.caseinstance.model.ObjectFactory";
    private static final String CASE_OBJECT_FACTORY_PREFIX = "CaseObjectFactory";
    private static final String ORAMDS = "oramds:/soa/shared/casemgmt/";
    private static final String DECISION_POINT_XSD = "DecisionPoint.xsd";
    private static final String DECISION_POINT_OBJECT = "oracle.rules.sdk2.decisionpoint.wsfacts.ObjectFactory";
    public static final String BASE_DICTIONARY_NAME = "CaseManagementBaseDictionary";
    public static final String BASE_DICTIONARY_PKG = "oracle.bpm.casemgmt.caserule";
    public static final String BASE_DICTIONARY_PATH = "/oracle/bpm/casemgmt/caserule";
    public static final String CASE_MILESTONES = "Milestones";
    public static final String CASE_ACTIVITIES = "Activities";
    public static final String CASE_OUTCOMES = "Outcomes";
    public static final String USER_DEFINED_EVENTS = "UserDefinedEvents";
    public static final String CASE_DATA = "Data";
    public static final String CASE_SUFFIX = ".case";
    public static final String CASE_ACTIVITY_PACKAGE = "oracle.bpm.casemgmt.metadata.activity.model";
    public static final String CASE_JAXB_PACKAGE = "oracle.bpm.casemgmt.metadata.Case.model";

    public static void setIsPreviewMode(boolean isPreviewMode) {
        sIsPreviewMode = isPreviewMode;
    }

    public static boolean getIsPreviewMode() {
        return sIsPreviewMode;
    }

    public static Map<DICTIONARY_TYPE, RuleDictionary> initCaseRuleDictionary(String componentDir, String componentName, List<URI> caseDataSchemaURI, URI caseSchemaURI, URI caseEventSchemaURI, URI caseActionSchemaURI) throws Exception {
        long start = CaseDictionaryHandler.startTimer("initCaseRuleDictionary");
        HashMap<DICTIONARY_TYPE, RuleDictionary> dictionaryMap = new HashMap<DICTIONARY_TYPE, RuleDictionary>();
        String rulesetName = componentName;
        RuleDictionary baseRd = null;
        MDSCaseBaseDictionaryFinder caseDictFinder = new MDSCaseBaseDictionaryFinder((DictionaryFinder)new DecisionPointDictionaryFinder(), null);
        baseRd = caseDictFinder.findDictionaryWithThisFinder(new DictionaryFQN(BASE_DICTIONARY_PKG, BASE_DICTIONARY_NAME));
        String customDictFileName = CaseDictionaryHandler.dictionaryFileName(componentDir, componentName);
        boolean doesCustomDictionaryExist = CaseDictionaryHandler.doesDictionaryExist(componentDir, componentName);
        RuleDictionary customRd = MetadataHelper.loadOrCreateDictionary((String)customDictFileName, (DictionaryFinder)caseDictFinder);
        if (!doesCustomDictionaryExist) {
            customRd.setName(componentName);
            customRd.setAlias(componentName);
            DictionaryLink dictionaryLink = customRd.createDictionaryLink(BASE_DICTIONARY_PKG, BASE_DICTIONARY_NAME);
            dictionaryLink.setPrefixLinkedNames(false);
            customRd.createEmptyRuleSet(rulesetName);
            CaseDictionaryHandler.addCustomDictionaryArtifacts(customRd, customDictFileName, doesCustomDictionaryExist, componentName, componentDir, rulesetName, caseDataSchemaURI);
            new File(componentDir + RULES_SUBDIRECTORY).mkdirs();
        } else {
            MetadataHelper.ensureRuleSetIsDefined((RuleDictionary)customRd, (String)rulesetName);
        }
        ArrayList list = new ArrayList();
        customRd.update(list);
        CaseDictionaryHandler.debugLog("Warnings from custom dict= " + list);
        MetadataHelper.writeDictionary((String)customDictFileName, (RuleDictionary)customRd);
        dictionaryMap.put(DICTIONARY_TYPE.BASE, baseRd);
        dictionaryMap.put(DICTIONARY_TYPE.CUSTOM, customRd);
        CaseDictionaryHandler.stopTimer("initCaseRuleDictionary", start);
        return dictionaryMap;
    }

    public static RuleDictionary generateCaseRuleBaseDictionary(String componentDir, String componentName, URI caseSchemaURI, URI caseEventSchemaURI, URI caseActionSchemaURI, List<URI> caseDataSchemaURI, boolean doesBaseDictionaryExist) throws Exception {
        String customDictFileName = CaseDictionaryHandler.baseDictionaryFileName(componentDir, componentName);
        CurrentDirectoryDictionaryFinder currentDirectoryDictionaryFinder = new CurrentDirectoryDictionaryFinder(componentDir, RULES_SUBDIRECTORY);
        File file = new File(componentDir + RULES_SUBDIRECTORY + BASE_DICTIONARY_PATH);
        file.mkdirs();
        RuleDictionary baseRd = MetadataHelper.createDictionary((String)BASE_DICTIONARY_NAME, (DictionaryFinder)new DecisionPointDictionaryFinder());
        new File(componentDir + RULES_SUBDIRECTORY).mkdirs();
        baseRd.setName(BASE_DICTIONARY_NAME);
        baseRd.setAlias(BASE_DICTIONARY_NAME);
        baseRd.setPackage(BASE_DICTIONARY_PKG);
        CaseDictionaryHandler.addBaseDictionaryArtifacts(baseRd, componentDir, componentName, caseSchemaURI, caseEventSchemaURI, caseActionSchemaURI, caseDataSchemaURI);
        ArrayList list = new ArrayList();
        baseRd.update(list);
        CaseDictionaryHandler.debugLog("Warnings from base dict= " + list);
        MetadataHelper.writeDictionary((RuleDictionary)baseRd, (File)new File(file, "CaseManagementBaseDictionary.rules"));
        return baseRd;
    }

    public static RuleDictionary readDictionary(String componentDir, String componentName) throws SDKException, IOException {
        return MetadataHelper.loadOrCreateDictionary((String)CaseDictionaryHandler.dictionaryFileName(componentDir, componentName));
    }

    public static void writeDictionary(String componentDir, String componentName, RuleDictionary rd) throws SDKException, IOException {
        MetadataHelper.writeDictionary((String)CaseDictionaryHandler.dictionaryFileName(componentDir, componentName), (RuleDictionary)rd);
    }

    public static void writeDecsContents(String compositeName, String projectDir, String componentName) throws IOException, DecisionServiceException, SDKException {
        CaseDictionaryHandler.writeDecsContents(compositeName, projectDir, componentName, null);
    }

    public static void writeDecsContents(String compositeName, String projectDir, String componentName, RuleDictionary customRd) throws IOException, DecisionServiceException, SDKException {
        CaseDictionaryHandler.debugLog("entering writeDecsContents");
        long start = CaseDictionaryHandler.startTimer("writeDecsContents");
        if (customRd == null) {
            return;
        }
        DecisionServiceBuilder dsBuilder = new DecisionServiceBuilder(componentName);
        String dummyProviderName = "myRuleEngine";
        File absCustomDictFile = new File(CaseDictionaryHandler.dictionaryFileName(projectDir, componentName)).getAbsoluteFile();
        URL customDictURL = absCustomDictFile.toURI().toURL();
        String customRulesFilePath = compositeName + "/oracle/rules/" + componentName + RULE_FILE_SUFFIX;
        dsBuilder.addOracleRuleEngineProvider(dummyProviderName, customRulesFilePath, customRd, customDictURL);
        CaseDictionaryHandler.addDecisionFunction(customRd, dsBuilder, componentName, dummyProviderName);
        CaseDictionaryHandler.copyPaXsd(projectDir);
        dsBuilder.createDecisionServiceComponent(projectDir);
        CaseDictionaryHandler.stopTimer("writeDecsContents", start);
    }

    public static boolean isRulesetNameDistinct(RuleDictionary rd, String name) {
        List ruleSets = rd.getRuleSetAliases(true);
        for (String s : ruleSets) {
            if (!s.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static boolean doesDictionaryExist(String componentDir, String componentName) {
        return new File(CaseDictionaryHandler.dictionaryFileName(componentDir, componentName)).exists();
    }

    public static boolean doesBaseDictionaryExist(String componentDir, String componentName) {
        return new File(CaseDictionaryHandler.baseDictionaryFileName(componentDir, componentName)).exists();
    }

    public static String dictionaryFileName(String componentDir, String componentName) {
        return componentDir + RULES_SUBDIRECTORY + componentName + RULE_FILE_SUFFIX;
    }

    public static String baseDictionaryFileName(String componentDir, String componentName) {
        return componentDir + RULES_SUBDIRECTORY + componentName + RULES_BASE + RULE_FILE_SUFFIX;
    }

    public static void createCaseDecisionPoint(RuleDictionary rd, String rulesetName, String componentName, List<URI> caseDataSchemaURI, List<String> caseInputs) throws Exception {
        DecisionFunction df = CaseDictionaryHandler.createDecisionFunction(rd, rulesetName);
        df.setCheckRuleFlow(false);
        df.setWebService(true);
        df.getDecisionFunctionInputTable().clear();
        df.getDecisionFunctionOutputTable().clear();
        df.getDecisionFunctionRuleSetTable().clear();
        for (String factAlias : CASE_INPUTS) {
            CaseDictionaryHandler.addDecisionFunctionInput(df, factAlias, factAlias, true, false);
        }
        if (caseInputs == null || caseInputs.isEmpty()) {
            caseInputs = CaseDictionaryHandler.getCaseInputs(rd, caseDataSchemaURI);
        }
        int i = 0;
        for (String factAlias : caseInputs) {
            CaseDictionaryHandler.addDecisionFunctionInput(df, factAlias, factAlias + ++i, true, false);
        }
        for (String factAlias : CASE_OUTPUTS) {
            CaseDictionaryHandler.addDecisionFunctionOutput(df, factAlias, factAlias, true, false);
        }
        CaseDictionaryHandler.setCaseRuleset(rd, rulesetName);
    }

    public static String getTemporaryDirectoryName() throws IOException {
        File temp = File.createTempFile("ORA", null);
        temp.delete();
        return temp.getAbsolutePath();
    }

    public static Map<String, List<String>> generateDecisionFunctionInputForDS(URI uri) throws Exception {
        XSElementDecl elemDec = null;
        ArrayList<String> typeNames = null;
        XSOMParser xsdParser = new XSOMParser();
        xsdParser.parse(uri.toURL());
        XSSchema schema = xsdParser.getResult().getSchema(1);
        Map elements = schema.getElementDecls();
        HashMap<String, List<String>> inputs = new HashMap<String, List<String>>();
        if (elements != null && !elements.isEmpty()) {
            Set element = elements.keySet();
            for (String elem : element) {
                elemDec = (XSElementDecl)elements.get(elem);
                typeNames = (ArrayList<String>)inputs.get(elemDec.getTargetNamespace());
                if (typeNames == null) {
                    typeNames = new ArrayList<String>();
                    typeNames.add(elemDec.getName());
                    inputs.put(elemDec.getTargetNamespace(), typeNames);
                    continue;
                }
                typeNames.add(elemDec.getName());
            }
        }
        return inputs;
    }

    public static Map<DICTIONARY_TYPE, RuleDictionary> regenerateXMLFactTypes(String componentDir, String componentName, List<URI> caseDataURIList, List<String> caseInputXmlTypes) throws Exception {
        CaseDictionaryHandler.debugLog("Regenerating fact types for dictionary");
        String xsdPath = null;
        HashMap<DICTIONARY_TYPE, RuleDictionary> dictionaryMap = new HashMap<DICTIONARY_TYPE, RuleDictionary>();
        HashSet allURLs = new HashSet();
        String baseDictFileName = CaseDictionaryHandler.baseDictionaryFileName(componentDir, componentName);
        CurrentDirectoryDictionaryFinder currentDirectoryDictionaryFinder = new CurrentDirectoryDictionaryFinder(componentDir, RULES_SUBDIRECTORY);
        MDSCaseBaseDictionaryFinder caseDictFinder = new MDSCaseBaseDictionaryFinder((DictionaryFinder)new DecisionPointDictionaryFinder(), null);
        RuleDictionary dictionary = caseDictFinder.findDictionaryWithThisFinder(new DictionaryFQN(BASE_DICTIONARY_PKG, BASE_DICTIONARY_NAME));
        String customDictFileName = CaseDictionaryHandler.dictionaryFileName(componentDir, componentName);
        RuleDictionary customRd = MetadataHelper.loadDictionary((File)new File(customDictFileName), (DictionaryFinder)caseDictFinder);
        dictionaryMap.put(DICTIONARY_TYPE.BASE, dictionary);
        dictionaryMap.put(DICTIONARY_TYPE.CUSTOM, customRd);
        ArrayList<JaxbFactType> jaxbFactTypes = new ArrayList<JaxbFactType>();
        List<Object> removeList = new ArrayList();
        String caseName = componentName.substring(0, componentName.indexOf(RULES_SUFFIX));
        FactTypeTable factTypes = customRd.getDataModel().getFactTypeTable();
        BucketSetTable bucketSet = customRd.getDataModel().getBucketSetTable();
        for (JaxbFactType jaxbFactType : customRd.getCombinedDataModel().getJaxbFactTypes()) {
            xsdPath = jaxbFactType.getSource();
            if (xsdPath.startsWith(ORAMDS) || xsdPath.equals("DecisionPoint.xsd")) continue;
            jaxbFactTypes.add(jaxbFactType);
        }
        removeList = CaseDictionaryHandler.generateCustomJaxbTypes(customRd, componentName, componentDir, caseDataURIList, jaxbFactTypes);
        String nodeName = null;
        boolean isTypeAdded = false;
        ArrayList<String> caseInputs = new ArrayList<String>();
        ArrayList caseInputFacts = new ArrayList();
        HashMap<String, String> elemNameToType = new HashMap<String, String>();
        for (URI uri : caseDataURIList) {
            elemNameToType.putAll(CaseDictionaryHandler.getElementNameToTypeMap(uri));
        }
        if (caseInputXmlTypes != null && !caseInputXmlTypes.isEmpty()) {
            for (String xmlType : caseInputXmlTypes) {
                for (JaxbFactType jaxbFactType : customRd.getCombinedDataModel().getJaxbFactTypes()) {
                    nodeName = (String)elemNameToType.get(xmlType);
                    if (nodeName == null || !nodeName.equals(jaxbFactType.getNodeName())) continue;
                    caseInputs.add(jaxbFactType.getAlias());
                    isTypeAdded = true;
                }
                if (!isTypeAdded) {
                    CaseDictionaryHandler.addSimpleTypeToCaseInput(xmlType, customRd, caseInputs);
                    continue;
                }
                isTypeAdded = false;
            }
        }
        CaseDictionaryHandler.resolveConflictingAliases(customRd);
        CaseDictionaryHandler.createCaseDecisionPoint(customRd, componentName, componentName, caseDataURIList, caseInputs);
        CaseDictionaryHandler.createCaseArtifactsBucketSets(caseName, componentDir, customRd);
        customRd.update(new ArrayList());
        MetadataHelper.writeDictionary((String)customDictFileName, (RuleDictionary)customRd);
        return dictionaryMap;
    }

    private static TCaseMetadata getCaseMetatdata(String componentName, String projectDir) throws Exception {
        TCaseMetadata metaData = null;
        String caseFileLoc = CaseDictionaryHandler.searchCaseArtifact(projectDir, componentName + CASE_SUFFIX);
        if (caseFileLoc != null && caseFileLoc.trim().length() > 0) {
            metaData = (TCaseMetadata)((CaseMetadata)CaseDictionaryHandler.unmarshall(caseFileLoc, CASE_JAXB_PACKAGE)).getValue();
        }
        return metaData;
    }

    private static void createCaseArtifactsBucketSets(String componentName, String projectDir, RuleDictionary rd) throws Exception {
        List mList = null;
        List oList = null;
        List uList = null;
        System.out.println("createCaseArtifactsBucketSets projectDir = " + projectDir + " componentName = " + componentName);
        String caseFileLoc = CaseDictionaryHandler.searchCaseArtifact(projectDir, componentName + CASE_SUFFIX);
        System.out.println("createCaseArtifactsBucketSets caseFileLoc = " + caseFileLoc);
        TCaseMetadata caseMetaData = (TCaseMetadata)((CaseMetadata)CaseDictionaryHandler.unmarshall(caseFileLoc, CASE_JAXB_PACKAGE)).getValue();
        TMilestones mileStones = caseMetaData.getMilestones();
        if (mileStones != null && (mList = mileStones.getMilestone()) != null && !mList.isEmpty()) {
            BucketSet bs = CaseDictionaryHandler.createBucketset(rd, CASE_MILESTONES);
            for (TMilestone ms : mList) {
                CaseDictionaryHandler.addBucket(bs, ms.getName(), ms.getName());
                CaseDictionaryHandler.createGlobals(ms.getName(), CASE_MILESTONES, rd);
            }
        }
        CaseDictionaryHandler.removeDeletedMilestonesFromBuckets(rd.getCombinedDataModel().getBucketSetByAlias(CASE_MILESTONES), mList);
        CaseDictionaryHandler.removeDeletedGlobals(rd, mList, null, CASE_MILESTONES, CaseDictionaryHandler.isRemoveAll(mList));
        TOutcomes outcomes = caseMetaData.getOutcomes();
        if (outcomes != null && (oList = outcomes.getOutcome()) != null && !oList.isEmpty()) {
            BucketSet bs = CaseDictionaryHandler.createBucketset(rd, CASE_OUTCOMES);
            for (TOutcome ot : oList) {
                CaseDictionaryHandler.addBucket(bs, ot.getName(), ot.getName());
            }
        }
        CaseDictionaryHandler.removeDeletedOutcomesFromBuckets(rd.getCombinedDataModel().getBucketSetByAlias(CASE_OUTCOMES), oList);
        TUserDefinedEvent events = caseMetaData.getEvents();
        if (events != null && (uList = events.getUserDefinedEvent()) != null && !uList.isEmpty()) {
            BucketSet bs = CaseDictionaryHandler.createBucketset(rd, USER_DEFINED_EVENTS);
            for (String ud : uList) {
                CaseDictionaryHandler.addBucket(bs, ud, ud);
            }
        }
        CaseDictionaryHandler.removeDeletedEventsFromBuckets(rd.getCombinedDataModel().getBucketSetByAlias(USER_DEFINED_EVENTS), uList);
        List<TData> caseDataList = CaseDictionaryHandler.getAllCaseDataTypes(caseMetaData);
        if (caseDataList != null && !caseDataList.isEmpty()) {
            BucketSet bs = CaseDictionaryHandler.createBucketset(rd, CASE_DATA);
            for (TData data : caseDataList) {
                CaseDictionaryHandler.addBucket(bs, data.getName(), data.getName());
            }
        }
        CaseDictionaryHandler.removeDeletedCaseDataFromBuckets(rd.getCombinedDataModel().getBucketSetByAlias(CASE_DATA), caseDataList);
        CaseDictionaryHandler.addCaseActivityBucketSet(projectDir, rd);
    }

    private static boolean isRemoveAll(List list) {
        return list == null || list.isEmpty();
    }

    private static void addCaseActivityBucketSet(String projectDir, RuleDictionary rd) throws Exception {
        List<String> activities = CaseDictionaryHandler.searchCaseActivities(projectDir);
        TCaseActivity caseActivity = null;
        String activityName = null;
        ArrayList<String> activityNames = new ArrayList<String>();
        BucketSet bs = null;
        if (activities != null && !activities.isEmpty()) {
            for (String fileLoc : activities) {
                caseActivity = (TCaseActivity)((CaseActivity)CaseDictionaryHandler.unmarshall(fileLoc, CASE_ACTIVITY_PACKAGE)).getValue();
                activityName = caseActivity.getName();
                activityNames.add(activityName);
                bs = CaseDictionaryHandler.createBucketset(rd, CASE_ACTIVITIES);
                CaseDictionaryHandler.addBucket(bs, activityName, activityName);
                CaseDictionaryHandler.createGlobals(activityName, CASE_ACTIVITIES, rd);
            }
        }
        CaseDictionaryHandler.removeDeletedActivitiesFromBuckets(bs, activityNames);
        CaseDictionaryHandler.removeDeletedGlobals(rd, null, activityNames, CASE_ACTIVITIES, CaseDictionaryHandler.isRemoveAll(activityNames));
    }

    private static BucketSet createBucketset(RuleDictionary rd, String name) {
        BucketSet bs = rd.getCombinedDataModel().getBucketSetByAlias(name);
        if (bs == null) {
            bs = (BucketSet)rd.getDataModel().getBucketSetTable().add();
            bs.setAlias(name);
            bs.setName(name);
            bs.setForm("LOV");
            bs.setType("String");
            bs.setVisible(true);
        }
        return bs;
    }

    private static void addBucket(BucketSet bs, String name, String value) {
        Bucket b = (Bucket)bs.getBucketTable().getByAlias(name);
        if (b == null) {
            b = (Bucket)bs.getBucketTable().add();
            b.getExpression().getValueProperty().setTranslatedValue(value);
            b.setAlias(value);
        }
    }

    private static void removeDeletedMilestonesFromBuckets(BucketSet bs, List<TMilestone> mList) throws Exception {
        CaseDictionaryHandler.removeDeletedArtifactsFromBuckets(bs, mList, null, null, null, null, CaseDictionaryHandler.isRemoveAll(mList));
    }

    private static void removeDeletedOutcomesFromBuckets(BucketSet bs, List<TOutcome> outcomes) throws Exception {
        CaseDictionaryHandler.removeDeletedArtifactsFromBuckets(bs, null, outcomes, null, null, null, CaseDictionaryHandler.isRemoveAll(outcomes));
    }

    private static void removeDeletedEventsFromBuckets(BucketSet bs, List<String> events) throws Exception {
        CaseDictionaryHandler.removeDeletedArtifactsFromBuckets(bs, null, null, events, null, null, CaseDictionaryHandler.isRemoveAll(events));
    }

    private static void removeDeletedCaseDataFromBuckets(BucketSet bs, List<TData> caseDataList) throws Exception {
        CaseDictionaryHandler.removeDeletedArtifactsFromBuckets(bs, null, null, null, caseDataList, null, CaseDictionaryHandler.isRemoveAll(caseDataList));
    }

    private static void removeDeletedActivitiesFromBuckets(BucketSet bs, List<String> activityNames) throws Exception {
        CaseDictionaryHandler.removeDeletedArtifactsFromBuckets(bs, null, null, null, null, activityNames, CaseDictionaryHandler.isRemoveAll(activityNames));
    }

    private static void removeDeletedArtifactsFromBuckets(BucketSet bs, List<TMilestone> mList, List<TOutcome> outcomes, List<String> events, List<TData> caseDataList, List<String> activityNames, boolean removeAll) throws Exception {
        if (bs == null) {
            return;
        }
        if (removeAll) {
            bs.getBucketTable().clear();
        } else {
            ArrayList<Bucket> removeBuckets = new ArrayList<Bucket>();
            List buckets = bs.getBuckets();
            boolean isFound = false;
            if (buckets != null && !buckets.isEmpty()) {
                for (Bucket b : buckets) {
                    if (mList != null && !mList.isEmpty()) {
                        for (TMilestone ms : mList) {
                            if (!ms.getName().equals(b.getAlias())) continue;
                            isFound = true;
                            break;
                        }
                    } else if (outcomes != null && !outcomes.isEmpty()) {
                        for (TOutcome ot : outcomes) {
                            if (!ot.getName().equals(b.getAlias())) continue;
                            isFound = true;
                            break;
                        }
                    } else if (events != null && !events.isEmpty()) {
                        if (events.contains(b.getAlias())) {
                            isFound = true;
                        }
                    } else if (caseDataList != null && !caseDataList.isEmpty()) {
                        for (TData data : caseDataList) {
                            if (!data.getName().equals(b.getAlias())) continue;
                            isFound = true;
                            break;
                        }
                    } else if (activityNames != null && !activityNames.isEmpty() && activityNames.contains(b.getAlias())) {
                        isFound = true;
                    }
                    if (!isFound) {
                        removeBuckets.add(b);
                    }
                    isFound = false;
                }
                bs.getBucketTable().removeAll(removeBuckets);
            }
        }
    }

    private static void removeDeletedGlobals(RuleDictionary rd, List<TMilestone> mList, List<String> caseActivities, String bucketsetAlias, boolean isRemoveAll) throws Exception {
        VariableTable globals = rd.getDataModel().getVariableTable();
        ArrayList<Variable> removeList = new ArrayList<Variable>();
        Iterator iter = globals.iterator();
        Variable v = null;
        boolean isFound = false;
        while (iter.hasNext()) {
            v = (Variable)iter.next();
            if (isRemoveAll) {
                CaseDictionaryHandler.addToRemoveList(removeList, v, bucketsetAlias);
                continue;
            }
            if (mList != null && !mList.isEmpty()) {
                for (TMilestone m : mList) {
                    if (!m.getName().equals(v.getAlias())) continue;
                    isFound = true;
                    break;
                }
                if (!isFound) {
                    CaseDictionaryHandler.addToRemoveList(removeList, v, bucketsetAlias);
                }
            } else if (caseActivities != null && !caseActivities.isEmpty()) {
                if (caseActivities.contains(v.getAlias())) {
                    isFound = true;
                }
                if (!isFound) {
                    CaseDictionaryHandler.addToRemoveList(removeList, v, bucketsetAlias);
                }
            }
            isFound = false;
        }
        globals.removeAll(removeList);
    }

    private static void addToRemoveList(List<Variable> removeList, Variable v, String bucketSetAlias) {
        String bucketSetAlias2 = v.getBucketSetAlias();
        if (bucketSetAlias2 != null && bucketSetAlias2.equals(bucketSetAlias)) {
            removeList.add(v);
        }
    }

    private static void createGlobals(String alias, String bucketSet, RuleDictionary rd) {
        Variable v = (Variable)rd.getDataModel().getVariableTable().getByAlias(alias);
        if (v == null) {
            v = (Variable)rd.getDataModel().getVariableTable().add();
            v.setAlias(alias);
            v.setName(alias);
            v.getTypeProperty().setTranslatedValue("String");
            v.setFinal(true);
            v.getExpression().getValueProperty().setTranslatedValue("\"" + alias + "\"");
            v.getBucketSetProperty().setTranslatedValue(bucketSet);
        }
    }

    private static List<TData> getAllCaseDataTypes(TCaseMetadata caseMetaData) {
        List list = new ArrayList();
        ArrayList<TData> dataList = new ArrayList<TData>();
        if (caseMetaData != null && caseMetaData.getCaseData() != null && !caseMetaData.getCaseData().isEmpty() && (list = caseMetaData.getCaseData()) != null && !list.isEmpty()) {
            for (TCaseData cd : list) {
                if (cd.getData() == null || cd.getData().isEmpty()) continue;
                dataList.addAll(cd.getData());
            }
        }
        return dataList;
    }

    private static void addSimpleTypeToCaseInput(String simpleType, RuleDictionary rd, List<String> caseInputs) {
        if (simpleType != null) {
            if (simpleType.endsWith("string")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("String").getAlias());
            } else if (simpleType.endsWith("int") || simpleType.endsWith("integer")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("Integer").getAlias());
            } else if (simpleType.endsWith("long")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("Long").getAlias());
            } else if (simpleType.endsWith("boolean")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("Boolean").getAlias());
            } else if (simpleType.endsWith("decimal")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("BigDecimal").getAlias());
            } else if (simpleType.endsWith("double")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("Double").getAlias());
            } else if (simpleType.endsWith("dateTime")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("XMLGregorianCalendar").getAlias());
            } else if (simpleType.endsWith("duration")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("XMLDuration").getAlias());
            } else if (simpleType.endsWith("short")) {
                caseInputs.add(rd.getCombinedDataModel().getFactTypeByAlias("Short").getAlias());
            }
        }
    }

    private static long startTimer(String name) {
        CaseDictionaryHandler.debugLog(name + ": starting");
        return Calendar.getInstance().getTimeInMillis();
    }

    private static void stopTimer(String name, long startTime) {
        long elapsedTime = Calendar.getInstance().getTimeInMillis() - startTime;
        CaseDictionaryHandler.debugLog(name + ": finished after: " + elapsedTime + "ms");
    }

    private static void debugLog(String message) {
        System.out.println(message);
    }

    private static void addCustomDictionaryArtifacts(RuleDictionary dictionary, String dictionaryFileName, boolean regeneratingDictionary, String componentName, String componentDir, String rulesetName, List<URI> caseDataURI) throws Exception {
        MetadataHelper.importJavaFactTypes((RuleDictionary)dictionary, COMMON_JAVA_FACT_TYPES);
        CaseDictionaryHandler.generateCustomJaxbTypes(dictionary, componentName, componentDir, caseDataURI, null);
        CaseDictionaryHandler.resolveConflictingAliases(dictionary);
        CaseDictionaryHandler.createCaseDecisionPoint(dictionary, rulesetName, componentName, caseDataURI, null);
    }

    private static void addBaseDictionaryArtifacts(RuleDictionary dictionary, String componentDir, String componentName, URI caseSchemaURI, URI caseEventSchemaURI, URI caseActionSchemaURI, List<URI> caseDataSchemaURI) throws Exception {
        MetadataHelper.importJavaFactTypes((RuleDictionary)dictionary, COMMON_JAVA_FACT_TYPES);
        CaseDictionaryHandler.generateBaseJaxbTypes(dictionary, componentDir, componentName, caseSchemaURI, caseEventSchemaURI, caseActionSchemaURI, caseDataSchemaURI);
        CaseDictionaryHandler.resolveAliasConflictInBase(dictionary);
        CaseDictionaryHandler.setAlias(dictionary);
        CaseDictionaryHandler.setVisibilityFalse(dictionary);
        CaseDictionaryHandler.seedCaseFunctions(dictionary);
    }

    private static void setAlias(RuleDictionary rd) {
        CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
        List factTypes = dm.getJaxbFactTypes();
        String alias = null;
        for (JaxbFactType factType : factTypes) {
            alias = NODENAME_TO_ALIAS.get(factType.getNodeName());
            if (alias == null) continue;
            factType.setAlias(alias);
        }
    }

    private static void setVisibilityFalse(RuleDictionary rd) {
        CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
        List factTypes = dm.getJaxbFactTypes();
        for (JaxbFactType factType : factTypes) {
            if (!NON_VISIBLE_FACTS.contains(factType.getAlias())) continue;
            factType.setVisible(false);
        }
    }

    private static void resolveAliasConflictInBase(RuleDictionary rd) {
        CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
        List factTypes = dm.getFactTypes();
        for (FactType factType : factTypes) {
            if (factType.getName() != null && factType.getName().equals(EVENT_OBJECT_FACTORY)) {
                factType.setAlias(EVENT_OBJECT_FACTORY_PREFIX);
                continue;
            }
            if (factType.getName() != null && factType.getName().equals(ACTION_OBJECT_FACTORY)) {
                factType.setAlias(ACTION_OBJECT_FACTORY_PREFIX);
                continue;
            }
            if (factType.getName() == null || !factType.getName().equals(CASE_OBJECT_FACTORY)) continue;
            factType.setAlias(CASE_OBJECT_FACTORY_PREFIX);
        }
    }

    private static void resolveConflictingAliases(RuleDictionary rd) {
        CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
        List factTypes = dm.getJaxbFactTypes();
        HashMap<String, String> nameToAlias = new HashMap<String, String>();
        ArrayList<JaxbFactType> temp = new ArrayList<JaxbFactType>();
        for (JaxbFactType factType : factTypes) {
            for (JaxbFactType factType2 : factTypes) {
                if (factType.getName().equals(factType2.getName()) || !factType.getAlias().equals(factType2.getAlias()) || factType.getName().equals(DECISION_POINT_OBJECT)) continue;
                nameToAlias.put(factType2.getName(), factType2.getAlias());
                temp.add(factType2);
            }
        }
        int index = 1;
        for (JaxbFactType factType : temp) {
            String factAlias;
            String newAlias = factAlias = factType.getAlias();
            while (nameToAlias.containsValue(newAlias)) {
                newAlias = factAlias + ++index;
            }
            if (factAlias.equals(newAlias)) continue;
            factType.setAlias(newAlias);
        }
    }

    private static void seedCaseFunctions(RuleDictionary rd) {
        FunctionTable ft = rd.getDataModel().getFunctionTable();
        CaseDictionaryHandler.seedActivateActivityFunction(ft, ACTIVATE_ACTIVITY);
        CaseDictionaryHandler.seedWithdrawActivityFunction(ft, WITHDRAW_ACTIVITY);
        CaseDictionaryHandler.seedRevokeMilestoneFunction(ft, REVOKE_MILESTONE);
        CaseDictionaryHandler.seedReachMilestoneFunction(ft, REACH_MILESTONE);
    }

    private static void addDecisionFunction(RuleDictionary dictionary, DecisionServiceBuilder dsBuilder, String componentName, String providerName) throws DecisionServiceException {
        for (DecisionFunction df : dictionary.getCombinedDataModel().getDecisionFunctions()) {
            if (!df.isWebService()) continue;
            String dfName = df.getName();
            String dsName = componentName + "_" + dfName;
            String functionName = null;
            functionName = componentName + "." + dfName;
            dsBuilder.addDecisionService(dsName, "http://xmlns.oracle.com/bpm/case/caseDecision/" + dsName, providerName, componentName, null, functionName);
        }
    }

    private static void setCaseRuleset(RuleDictionary rd, String name) {
        CaseDictionaryHandler.addDecisionFunctionRuleset(CaseDictionaryHandler.createDecisionFunction(rd, name), name);
    }

    private static DecisionFunction createDecisionFunction(RuleDictionary rd, String name) {
        DecisionFunctionTable dft = rd.getDataModel().getDecisionFunctionTable();
        DecisionFunction df = (DecisionFunction)dft.getByName(name);
        if (df == null) {
            df = (DecisionFunction)dft.add();
            df.setName(name);
            df.setAlias(name);
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPaXsd(String projectDir) throws IOException {
        File paXsd;
        File xsdDir = new File(projectDir, XSD_SUBDIR_NAME);
        if (!xsdDir.exists() || !xsdDir.isDirectory()) {
            // empty if block
        }
        if (!xsdDir.exists()) {
            xsdDir.mkdir();
        }
        if ((paXsd = new File(xsdDir, "DecisionPoint.xsd")).exists()) {
            return;
        }
        if (!paXsd.createNewFile()) {
            // empty if block
        }
        InputStream paSrc = new CaseDictionaryHandler().getClass().getResourceAsStream(PAXSD_FULLNAME);
        BufferedOutputStream paDest = null;
        try {
            int data;
            paDest = new BufferedOutputStream(new FileOutputStream(paXsd));
            while ((data = paSrc.read()) >= 0) {
                paDest.write(data);
            }
        }
        finally {
            paDest.flush();
            paDest.close();
        }
    }

    private static void seedActivateActivityFunction(FunctionTable ft, String funcName) {
        if (ft.getByAlias(funcName) != null) {
            return;
        }
        Function func = (Function)ft.add();
        func.setName(funcName);
        func.setAlias(funcName);
        func.setType(FUNC_RETURN_TYPE);
        FormalParameterTable fpt = func.getFormalParameterTable();
        CaseDictionaryHandler.addFunctionParameter(fpt, "activityName", "activityName", "String");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseActivityAction", "activity", "new TCaseActivityAction()");
        CaseDictionaryHandler.addActionAssign(func, "activity.name", "activityName");
        CaseDictionaryHandler.addActionAssign(func, "activity.status", "TCaseActivityStatus.ACTIVATE");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseAction", "caseAction", "(TCaseAction) RL.get facts by type(\"oracle.bpm.casemgmt.caserule.model.TCaseAction\").get(0)");
        CaseDictionaryHandler.addActionExpression(func, "caseAction.milestoneOrCaseActivity.append(activity)");
    }

    private static void seedWithdrawActivityFunction(FunctionTable ft, String funcName) {
        if (ft.getByAlias(funcName) != null) {
            return;
        }
        Function func = (Function)ft.add();
        func.setName(funcName);
        func.setAlias(funcName);
        func.setType(FUNC_RETURN_TYPE);
        FormalParameterTable fpt = func.getFormalParameterTable();
        CaseDictionaryHandler.addFunctionParameter(fpt, "activityName", "activityName", "String");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseActivityAction", "activity", "new TCaseActivityAction()");
        CaseDictionaryHandler.addActionAssign(func, "activity.name", "activityName");
        CaseDictionaryHandler.addActionAssign(func, "activity.status", "TCaseActivityStatus.WITHDRAW");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseAction", "caseAction", "(TCaseAction) RL.get facts by type(\"oracle.bpm.casemgmt.caserule.model.TCaseAction\").get(0)");
        CaseDictionaryHandler.addActionExpression(func, "caseAction.milestoneOrCaseActivity.append(activity)");
    }

    private static void seedRevokeMilestoneFunction(FunctionTable ft, String funcName) {
        if (ft.getByAlias(funcName) != null) {
            return;
        }
        Function func = (Function)ft.add();
        func.setName(funcName);
        func.setAlias(funcName);
        func.setType(FUNC_RETURN_TYPE);
        FormalParameterTable fpt = func.getFormalParameterTable();
        CaseDictionaryHandler.addFunctionParameter(fpt, "milestoneName", "milestoneName", "String");
        CaseDictionaryHandler.addFunctionParameter(fpt, "comments", "comments", "String");
        CaseDictionaryHandler.addActionAssignNew(func, "TMilestoneAction", "milestone", "new TMilestoneAction()");
        CaseDictionaryHandler.addActionAssign(func, "milestone.name", "milestoneName");
        CaseDictionaryHandler.addActionAssign(func, "milestone.comments", "comments");
        CaseDictionaryHandler.addActionAssign(func, "milestone.status", "TMilestoneStatus.REVOKE");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseAction", "caseAction", "(TCaseAction) RL.get facts by type(\"oracle.bpm.casemgmt.caserule.model.TCaseAction\").get(0)");
        CaseDictionaryHandler.addActionExpression(func, "caseAction.milestoneOrCaseActivity.append(milestone)");
    }

    private static void seedReachMilestoneFunction(FunctionTable ft, String funcName) {
        if (ft.getByAlias(funcName) != null) {
            return;
        }
        Function func = (Function)ft.add();
        func.setName(funcName);
        func.setAlias(funcName);
        func.setType(FUNC_RETURN_TYPE);
        FormalParameterTable fpt = func.getFormalParameterTable();
        CaseDictionaryHandler.addFunctionParameter(fpt, "milestoneName", "milestoneName", "String");
        CaseDictionaryHandler.addFunctionParameter(fpt, "comments", "comments", "String");
        CaseDictionaryHandler.addActionAssignNew(func, "TMilestoneAction", "milestone", "new TMilestoneAction()");
        CaseDictionaryHandler.addActionAssign(func, "milestone.name", "milestoneName");
        CaseDictionaryHandler.addActionAssign(func, "milestone.comments", "comments");
        CaseDictionaryHandler.addActionAssign(func, "milestone.status", "TMilestoneStatus.REACH");
        CaseDictionaryHandler.addActionAssignNew(func, "TCaseAction", "caseAction", "(TCaseAction) RL.get facts by type(\"oracle.bpm.casemgmt.caserule.model.TCaseAction\").get(0)");
        CaseDictionaryHandler.addActionExpression(func, "caseAction.milestoneOrCaseActivity.append(milestone)");
    }

    private static void addFunctionParameter(FormalParameterTable fpt, String paramName, String alias, String type) {
        FormalParameter taskAction = (FormalParameter)fpt.add();
        taskAction.setName(paramName);
        taskAction.setAlias(alias);
        taskAction.setType(type);
    }

    private static void addActionAssignNew(Function func, String target, String variable, String expression) {
        Action assignAction = (Action)func.getActionTable().add();
        assignAction.setForm("Assign New");
        assignAction.setVariable(variable);
        assignAction.setTarget(target);
        assignAction.getExpression(0).setConstant(false);
        assignAction.getExpression(0).setValue(expression);
    }

    private static void addActionAssign(Function func, String target, String expression) {
        Action assignAction = (Action)func.getActionTable().add();
        assignAction.setForm("Assign");
        assignAction.setTarget(target);
        assignAction.getExpression(0).setConstant(false);
        assignAction.getExpression(0).setValue(expression);
    }

    private static void addActionAssert(Function func, String target) {
        Action assignAction = (Action)func.getActionTable().add();
        assignAction.setForm("Assert");
        assignAction.setTarget(target);
    }

    private static void addActionExpression(Function func, String expression) {
        Action assignAction = (Action)func.getActionTable().add();
        assignAction.setForm("Expression");
        assignAction.getExpression(0).setConstant(false);
        assignAction.getExpression(0).setValue(expression);
    }

    private static void addDecisionFunctionRuleset(DecisionFunction df, String name) {
        MetadataHelper.ensureRuleSetIsDefined((RuleDictionary)df.getDictionary(), (String)name);
        MetadataHelper.addDecisionFunctionRuleSet((DecisionFunction)df, (String)name);
    }

    private static Map<String, String> generateDecisionFunctionInput(URI uri) throws Exception {
        XSElementDecl elemDec = null;
        XSOMParser xsdParser = new XSOMParser();
        xsdParser.parse(uri.toURL());
        XSSchema schema = xsdParser.getResult().getSchema(1);
        Map elements = schema.getElementDecls();
        HashMap<String, String> inputs = new HashMap<String, String>();
        if (elements != null && !elements.isEmpty()) {
            Set element = elements.keySet();
            for (String elem : element) {
                elemDec = (XSElementDecl)elements.get(elem);
                inputs.put(OPEN_BRACES + elemDec.getTargetNamespace() + CLOSE_BRACES + elemDec.getName(), elemDec.getType().getName());
            }
        }
        return inputs;
    }

    private static Map<String, String> getElementNameToTypeMap(URI uri) throws Exception {
        XSElementDecl elemDec = null;
        XSOMParser xsdParser = new XSOMParser();
        xsdParser.parse(uri.toURL());
        XSSchema schema = xsdParser.getResult().getSchema(1);
        Map elements = schema.getElementDecls();
        HashMap<String, String> inputs = new HashMap<String, String>();
        String typeName = null;
        if (elements != null && !elements.isEmpty()) {
            Set element = elements.keySet();
            for (String elem : element) {
                elemDec = (XSElementDecl)elements.get(elem);
                typeName = elemDec.getType().getName() == null ? elemDec.getName() : elemDec.getType().getName();
                inputs.put(OPEN_BRACES + elemDec.getTargetNamespace() + CLOSE_BRACES + elemDec.getName(), typeName);
            }
        }
        return inputs;
    }

    private static List<String> getCaseInputs(RuleDictionary rd, List<URI> caseDataSchemaURI) throws Exception {
        ArrayList<String> caseInputs = new ArrayList<String>();
        HashMap<String, String> inputs = new HashMap<String, String>();
        Object ns = null;
        Object type = null;
        for (URI uri : caseDataSchemaURI) {
            inputs.putAll(CaseDictionaryHandler.generateDecisionFunctionInput(uri));
        }
        if (inputs != null && !inputs.isEmpty()) {
            Set namespace = inputs.keySet();
            CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
            List factTypes = dm.getJaxbFactTypes();
            for (String namSpace : namespace) {
                for (JaxbFactType factType : factTypes) {
                    if (!namSpace.equals(factType.getNamespace()) || !((String)inputs.get(namSpace)).contains(factType.getNodeName())) continue;
                    caseInputs.add(factType.getAlias());
                }
            }
        }
        CaseDictionaryHandler.debugLog("getCaseInputsInputs Type being added to Decision function size = " + caseInputs.size() + " " + caseInputs);
        return caseInputs;
    }

    private static void addDecisionFunctionInput(DecisionFunction df, String factAlias, String inputName, boolean isTree, boolean isList) throws SDKException {
        CaseDictionaryHandler.addDecisionFunctionFact(df.getDecisionFunctionInputTable(), factAlias, inputName, isTree, isList);
    }

    private static void addDecisionFunctionOutput(DecisionFunction df, String factAlias, String inputName, boolean isTree, boolean isList) throws SDKException {
        CaseDictionaryHandler.addDecisionFunctionFact(df.getDecisionFunctionOutputTable(), factAlias, inputName, isTree, isList);
    }

    private static void addDecisionFunctionFact(DecisionFunctionFactTable dfft, String factAlias, String inputName, boolean isTree, boolean isList) throws SDKException {
        FactType ft = dfft.getCombinedDataModel().getFactTypeByAlias(factAlias);
        if (ft == null) {
            throw new SDKException("05157", (DictionaryObject)dfft.getDictionary());
        }
        DecisionFunctionFact dff = (DecisionFunctionFact)dfft.add();
        String dffAlias = factAlias.replaceAll("\\.", "_");
        dff.setName(inputName);
        dff.getTypeProperty().setTranslatedValue(factAlias);
        dff.setTree(isTree);
        dff.setList(isList);
    }

    private static List<JaxbFactType> addJaxbTypeToDictionary(SchemaBrowser sb, URI schemaURI, String targetPackage, String jaxbGenerationPath, List<JaxbFactType> jaxbFactyTypes, boolean isBaseDict) throws Exception {
        CaseDictionaryHandler.debugLog("schemaURI: " + schemaURI + "\nschemaRootURI: " + sb.getSchemaPathRoot() + "\ntargetPackage: " + targetPackage + "\njaxbGenSrcPath: " + sb.getSourceOutputDir() + "\njaxbGenerationPath: " + jaxbGenerationPath);
        File jaxbDir = new File(jaxbGenerationPath);
        if (!jaxbDir.exists()) {
            jaxbDir.mkdirs();
        }
        sb.setClassOutputDir(jaxbGenerationPath);
        if (isBaseDict) {
            sb.addSchemaPath(schemaURI, null);
        } else {
            sb.addSchemaPath(schemaURI, targetPackage);
        }
        NodeTable nodes = sb.getNodeTable();
        Node node = null;
        ArrayList<JaxbFactType> removeList = new ArrayList<JaxbFactType>();
        boolean found = false;
        if (jaxbFactyTypes != null && !jaxbFactyTypes.isEmpty()) {
            for (JaxbFactType jaxbFactType : jaxbFactyTypes) {
                for (int i = 0; i < nodes.size() && !(found = CaseDictionaryHandler.removeJaxbNode(jaxbFactType, (Node)nodes.get(i))); ++i) {
                }
                if (found) continue;
                removeList.add(jaxbFactType);
            }
        }
        node = null;
        if (targetPackage == null || targetPackage.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                node = (Node)nodes.get(i);
                node.load();
            }
        } else {
            for (String subpkg : targetPackage.split("\\.")) {
                node = nodes.getNode(subpkg);
                nodes = node.getNestedTable();
            }
        }
        node.load();
        return removeList;
    }

    private static boolean removeJaxbNode(JaxbFactType fact, Node n) throws Exception {
        if (n instanceof JaxbNode) {
            String factFQName = fact.getFullyQualifiedName();
            String nodeFQName = ((JaxbNode)n).getFQName();
            if (factFQName != null && nodeFQName != null && factFQName.equals(nodeFQName)) {
                return true;
            }
        }
        NodeTable children = n.getNestedTable();
        boolean bLoadJaxb = false;
        if (children != null) {
            for (int i = 0; i < children.size() && !bLoadJaxb; ++i) {
                Node n1 = children.getNode(i);
                bLoadJaxb = CaseDictionaryHandler.removeJaxbNode(fact, n1);
            }
        }
        return bLoadJaxb;
    }

    private static void generateBaseJaxbTypes(RuleDictionary rd, String componentDir, String componentName, URI caseTypeURI, URI caseEventTypeURI, URI caseActionSchemaURI, List<URI> caseDataURI) throws Exception {
        String tmpDir = CaseDictionaryHandler.getTemporaryDirectoryName();
        File tempSrc = new File(tmpDir, TEMP_SRC_DIR);
        File tempCls = new File(tmpDir, TEMP_CLASSES_DIR);
        tempSrc.mkdirs();
        tempCls.mkdirs();
        String tempClsDir = tempCls.getAbsolutePath();
        String tempSrcDir = tempSrc.getAbsolutePath();
        String classesDir = componentDir + RULE_DESIGNER_CLASSES_DIR;
        URI rootURI = new URL("oramds:/soa/shared/casemgmt").toURI();
        SchemaBrowser sb = new SchemaBrowser(rd, tempSrcDir, tempClsDir, rootURI, sJaxbPath, sParserPath);
        if (CaseDictionaryHandler.isRootURI(rootURI, caseTypeURI)) {
            sb.setSchemaPathRoot(rootURI);
        } else {
            sb.setSchemaPathRoot((URI)null);
        }
        CaseDictionaryHandler.addJaxbTypeToDictionary(sb, caseTypeURI, CASE_PACKAGE, classesDir, null, true);
        if (CaseDictionaryHandler.isRootURI(rootURI, caseEventTypeURI)) {
            sb.setSchemaPathRoot(rootURI);
        } else {
            sb.setSchemaPathRoot((URI)null);
        }
        CaseDictionaryHandler.addJaxbTypeToDictionary(sb, caseEventTypeURI, CASE_EVENT_PACKAGE, classesDir, null, true);
        if (CaseDictionaryHandler.isRootURI(rootURI, caseActionSchemaURI)) {
            sb.setSchemaPathRoot(rootURI);
        } else {
            sb.setSchemaPathRoot((URI)null);
        }
        CaseDictionaryHandler.addJaxbTypeToDictionary(sb, caseActionSchemaURI, CASE_ACTION_PACKAGE, classesDir, null, true);
    }

    private static List<JaxbFactType> generateCustomJaxbTypes(RuleDictionary rd, String componentName, String componentDir, List<URI> caseDataURI, List<JaxbFactType> jaxbFactTypes) throws Exception {
        String tmpDir = CaseDictionaryHandler.getTemporaryDirectoryName();
        File tempSrc = new File(tmpDir, TEMP_SRC_DIR);
        File tempCls = new File(tmpDir, TEMP_CLASSES_DIR);
        tempSrc.mkdirs();
        tempCls.mkdirs();
        String tempClsDir = tempCls.getAbsolutePath();
        String tempSrcDir = tempSrc.getAbsolutePath();
        List<JaxbFactType> removeList = new ArrayList<JaxbFactType>();
        String classesDir = componentDir + RULE_DESIGNER_CLASSES_DIR;
        URI rootURI = new File(componentDir).toURI();
        SchemaBrowser sb = new SchemaBrowser(rd, tempSrcDir, tempClsDir, rootURI, sJaxbPath, sParserPath);
        for (URI caseURI : caseDataURI) {
            if (CaseDictionaryHandler.isRootURI(rootURI, caseURI)) {
                sb.setSchemaPathRoot(rootURI);
            } else {
                sb.setSchemaPathRoot((URI)null);
            }
            removeList = CaseDictionaryHandler.addJaxbTypeToDictionary(sb, caseURI, null, classesDir, jaxbFactTypes, false);
        }
        return removeList;
    }

    private static boolean isRootURI(URI rootURI, URI otherURI) {
        String otherPath = otherURI.toString();
        String rootPath = rootURI.toString();
        return otherPath.startsWith(rootPath);
    }

    private static String searchCaseArtifact(String projectDir, String caseArtifactName) {
        File projectFolder = new File(projectDir);
        File[] allFiles = projectFolder.listFiles();
        String fileName = null;
        for (File file : allFiles) {
            if (caseArtifactName.equals(file.getName())) {
                CaseDictionaryHandler.debugLog("Returing file path = " + file.getAbsolutePath());
                return file.getAbsolutePath();
            }
            if (!file.isDirectory() || (fileName = CaseDictionaryHandler.searchCaseArtifact(file.getAbsolutePath(), caseArtifactName)) == null || !fileName.endsWith(caseArtifactName)) continue;
            return fileName;
        }
        return null;
    }

    private static List<String> searchCaseActivities(String projectDir) {
        return CaseDictionaryHandler.searchCaseActivities(projectDir, new ArrayList<String>());
    }

    private static List<String> searchCaseActivities(String projectDir, List<String> activities) {
        File[] allFiles;
        File projectFolder = new File(projectDir);
        for (File file : allFiles = projectFolder.listFiles()) {
            if (file.getName().endsWith(".caseactivity")) {
                if (activities.contains(file.getAbsolutePath())) {
                    return activities;
                }
                activities.add(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            CaseDictionaryHandler.searchCaseActivities(file.getAbsolutePath(), activities);
        }
        return activities;
    }

    private static Object unmarshall(String fileLocation, String packageName) throws Exception {
        File caseFile = new File(fileLocation);
        if (!caseFile.exists()) {
            throw new FileNotFoundException(fileLocation);
        }
        JAXBContext jaxbContext = null;
        Object o = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)packageName);
            o = jaxbContext.createUnmarshaller().unmarshal(caseFile);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw e;
        }
        return o;
    }

    static {
        COMMON_JAVA_FACT_TYPES.add(Boolean.class.getName());
        NON_VISIBLE_FACTS = new ArrayList<String>();
        NON_VISIBLE_FACTS.add("Sca");
        NON_VISIBLE_FACTS.add("TCaseFabricHeaderProperty");
        NON_VISIBLE_FACTS.add("TPropertyBag");
        NON_VISIBLE_FACTS.add("TProperty");
        NODENAME_TO_ALIAS = new HashMap<String, String>();
        NODENAME_TO_ALIAS.put("tCase", "Case");
        NODENAME_TO_ALIAS.put("tCaseHeader", "CaseHeader");
        NODENAME_TO_ALIAS.put("tPriority", "Priority");
        NODENAME_TO_ALIAS.put("tCategory", "Category");
        NODENAME_TO_ALIAS.put("tStakeHolders", "StakeHolders");
        NODENAME_TO_ALIAS.put("tStakeHolder", "StakeHolder");
        NODENAME_TO_ALIAS.put("tStakeHolderMembers", "StakeHolderMembers");
        NODENAME_TO_ALIAS.put("tStakeHolderMember", "StakeHolderMember");
        NODENAME_TO_ALIAS.put("tStateEnum", "CaseStateType");
        NODENAME_TO_ALIAS.put("tMilestones", CASE_MILESTONES);
        NODENAME_TO_ALIAS.put("tMilestone", "Milestone");
        NODENAME_TO_ALIAS.put("tComments", "Comments");
        NODENAME_TO_ALIAS.put("tComment", "Comment");
        NODENAME_TO_ALIAS.put("tData", CASE_DATA);
        NODENAME_TO_ALIAS.put("tSca", "Sca");
        NODENAME_TO_ALIAS.put("tCaseEvent", "CaseEvent");
        NODENAME_TO_ALIAS.put("tEventType", "CaseEventType");
        NODENAME_TO_ALIAS.put("tCaseActivityEvent", "CaseActivityEvent");
        NODENAME_TO_ALIAS.put("tActivityEvent", "CaseActivityEventType");
        NODENAME_TO_ALIAS.put("tCaseDocumentEvent", "CaseDocumentEvent");
        NODENAME_TO_ALIAS.put("tDocument", "Document");
        NODENAME_TO_ALIAS.put("tDocumentEvent", "CaseDocumentEventType");
        NODENAME_TO_ALIAS.put("tCaseLifecycleEvent", "CaseLifecycleEvent");
        NODENAME_TO_ALIAS.put("tLifecycleEvent", "CaseLifecycleEventType");
        NODENAME_TO_ALIAS.put("tCaseMilestoneEvent", "CaseMilestoneEvent");
        NODENAME_TO_ALIAS.put("tMilestoneEvent", "CaseMilestoneEventType");
        NODENAME_TO_ALIAS.put("tCaseCommentEvent", "CaseCommentEvent");
        NODENAME_TO_ALIAS.put("tCaseUserDefinedEvent", "UserDefinedEvent");
        NODENAME_TO_ALIAS.put("tCaseDataEvent", "CaseDataEvent");
        CASE_INPUTS = new String[]{"Case", "CaseEvent", "TCaseAction"};
        CASE_OUTPUTS = new String[]{"TCaseAction"};
        sIsPreviewMode = true;
        sJaxbPath = DICTIONARY_PACKAGE;
        sParserPath = DICTIONARY_PACKAGE;
        Class<?> dummyClass = new WFDecsSvcBuilder().getClass();
        URL url = dummyClass.getResource("/oracle/xml/parser/v2/DocumentBuilder.class");
        if (url != null) {
            String fileName = url.getFile();
            sParserPath = fileName.substring(fileName.indexOf(":") + 1, fileName.indexOf("!"));
        }
        boolean jaxb20 = true;
        String jaxbVersion = System.getProperty("oracle.rules.sdk2.jaxb.version");
        if (jaxbVersion != null && "1.0".equals(jaxbVersion)) {
            jaxb20 = false;
        }
        if ((url = jaxb20 ? dummyClass.getResource("/javax/xml/bind/JAXBElement.class") : dummyClass.getResource("/oracle/xml/jaxb/JaxbNode.class")) != null) {
            String fileName = url.getFile();
            sJaxbPath = fileName.substring(fileName.indexOf(":") + 1, fileName.indexOf("!"));
        }
        RULES_SUBDIRECTORY = File.separator + "oracle" + File.separator + "rules" + File.separator;
    }

    public static enum DICTIONARY_TYPE {
        BASE,
        CUSTOM;

    }
}

