/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConversationHelper {
    public static Sequence<Conversation> getAllConversationsFrom(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getAllConversationsFrom must not be null");
        }
        LinkedHashMap<String, Conversation> allConversations = new LinkedHashMap<String, Conversation>();
        ConversationHelper.putAllActiveConversationsFrom(process, allConversations);
        Sequence<Process> calledProcesses = ModelUtils.getCalledProcesses(process);
        for (Process calledProcess : calledProcesses) {
            ConversationHelper.putAllActiveConversationsFrom(calledProcess, allConversations);
        }
        return CollectionUtils.asSequence(allConversations.values());
    }

    public static String getPortTypeName(@NotNull Process process, @NotNull Conversation conversation) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getPortTypeName must not be null");
        }
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getPortTypeName must not be null");
        }
        boolean isDefault = conversation.isDefaultConversation();
        String name = isDefault ? process.getId() : conversation.getName();
        return name + "PortType";
    }

    public static String getServiceNameFrom(@NotNull Conversation conversation, @NotNull Process process) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getServiceNameFrom must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getServiceNameFrom must not be null");
        }
        return ConversationHelper.getServiceReferencedName(conversation, process) + ".service";
    }

    public static String getReferenceNameFrom(@NotNull Conversation conversation, @NotNull Process process) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getReferenceNameFrom must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getReferenceNameFrom must not be null");
        }
        String serviceName = ConversationHelper.getBaseName(conversation, process);
        if (conversation.isDefaultConversation()) {
            ConversationType conversationType = conversation.getConversationType();
            switch (conversationType) {
                case DEFINE_INTERFACE: {
                    serviceName = process.getId();
                    break;
                }
                case PROCESS_CALL: {
                    ProcessCallConversationDefinition pccf = conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class);
                    Process pccfProcess = pccf.getProcess();
                    serviceName = pccfProcess != null ? pccfProcess.getId() : null;
                    break;
                }
                case USE_INTERFACE: {
                    UseInterfaceConversationDefinition uicf = conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                    ReferenceObject reference = uicf.getReference();
                    serviceName = reference != null ? reference.getId() : null;
                    break;
                }
                case SERVICE_CALL: {
                    ServiceCallConversationDefinition sccd = conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                    ServiceObject service = sccd.getService();
                    serviceName = service != null ? service.getId() : null;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
                }
            }
        }
        return serviceName + ".reference";
    }

    @Nullable
    public static String getServiceReferencedName(@NotNull Conversation conversation, @NotNull Process process) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getServiceReferencedName must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getServiceReferencedName must not be null");
        }
        String serviceName = ConversationHelper.getBaseName(conversation, process);
        if (conversation.isDefaultConversation()) {
            ConversationType conversationType = conversation.getConversationType();
            ConversationDefinition conversationDefinition = conversation.getConversationDefinition();
            switch (conversationType) {
                case DEFINE_INTERFACE: {
                    break;
                }
                case USE_INTERFACE: {
                    UseInterfaceConversationDefinition uicf = conversationDefinition.as(UseInterfaceConversationDefinition.class);
                    ReferenceObject reference = uicf.getReference();
                    serviceName = reference != null ? reference.getId() : null;
                    break;
                }
                case PROCESS_CALL: {
                    serviceName = null;
                    break;
                }
                case SERVICE_CALL: {
                    ServiceCallConversationDefinition sccf = conversationDefinition.as(ServiceCallConversationDefinition.class);
                    ServiceObject service = sccf.getService();
                    serviceName = service != null ? service.getObjectType().asServiceObject().getTarget() : null;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
                }
            }
        }
        return serviceName;
    }

    private static void putAllActiveConversationsFrom(@NotNull Process process, @NotNull Map<String, Conversation> allConversations) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.putAllActiveConversationsFrom must not be null");
        }
        if (allConversations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.putAllActiveConversationsFrom must not be null");
        }
        Sequence<Conversation> conversations = process.getDescendants(Conversation.class);
        for (Conversation conversation : conversations) {
            if (conversation.getConversationals().isEmpty()) continue;
            allConversations.put(conversation.getId(), conversation);
        }
    }

    private static String getBaseName(@NotNull Conversation conversation, @NotNull Process process) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getBaseName must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ConversationHelper.getBaseName must not be null");
        }
        String serviceName = conversation.isDefaultConversation() ? process.getId() : process.getId() + "_" + conversation.getName();
        return serviceName;
    }
}

