/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.xmltype;

import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import oracle.bpm.project.catalog.config.ProjectCatalogConfig;
import oracle.bpm.project.catalog.config.SchemaResolver;
import oracle.bpm.project.catalog.xmltype.EntityResolver;
import oracle.bpm.project.catalog.xmltype.ImportType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraMdsImportResolver
implements EntityResolver {
    private static final String MDS_PROTOCOL_NAME = "oramds";

    @Override
    @Nullable
    public InputStream resolveEntity(@Nullable URL context, @Nullable String location, @Nullable String namespace, @NotNull ImportType importType) {
        if (importType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/OraMdsImportResolver.resolveEntity must not be null");
        }
        if (location == null) {
            return null;
        }
        if (context != null && MDS_PROTOCOL_NAME.equals(context.getProtocol()) && !location.startsWith(MDS_PROTOCOL_NAME)) {
            String contextPath = context.getPath();
            int i = contextPath.lastIndexOf("/");
            location = "oramds:" + contextPath.substring(0, i + 1) + location;
        }
        Set<SchemaResolver> schemas = ProjectCatalogConfig.getInstance().getSchemaResolvers();
        String resourceLocation = null;
        for (SchemaResolver schema : schemas) {
            if (!location.equals(schema.getLocation())) continue;
            resourceLocation = schema.getResourceLocation();
            break;
        }
        if (resourceLocation == null) {
            String start = "oramds:/";
            int index = location.indexOf("oramds:/");
            if (index > 0 && location.startsWith("oramds:/")) {
                resourceLocation = location.substring(index, location.length());
            }
        }
        InputStream result = null;
        if (resourceLocation != null) {
            result = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
        }
        return result;
    }
}

