/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Tuple;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Binding;
import oracle.bpm.project.catalog.parser.wsdl.PortDefinition;
import oracle.bpm.project.catalog.parser.wsdl.Service;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.WsdlParser;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.utils.InvalidServiceException;
import oracle.bpm.project.catalog.utils.ResourceUtils;
import oracle.bpm.project.catalog.xmltype.OraMdsImportResolver;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.data.PortTypeDescription;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsdlUtils {
    private static final String SOAP_NAMESPACE_1_1 = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP_NAMESPACE_1_2 = "http://schemas.xmlsoap.org/wsdl/soap12/";

    private WsdlUtils() {
    }

    public static List<PortTypeDescription> getPorts(@NotNull Project project, @NotNull URI uri) throws InvalidServiceException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        WsdlParser parser = WsdlUtils.getParser(project);
        if (parser == null) {
            return Collections.emptyList();
        }
        try {
            ServiceDefinition definition = parser.parseDefinition(uri);
            definition.verify();
            return WsdlUtils.getPorts(definition);
        }
        catch (TypeParseException e) {
            throw InvalidServiceException.invalidWsdlFile(uri.toString(), e);
        }
    }

    public static List<PortTypeDescription> getPorts(@NotNull Project project, @NotNull String fileName, @NotNull InputStream input) throws InvalidServiceException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        assert (!fileName.matches("(?i)[a-z](?:[a-z0-9+-.]*)://.*")) : "You should not use this method with URLs. See getPorts(Project, URI)";
        return WsdlUtils.getPorts(project, fileName, input, true);
    }

    public static List<PortTypeDescription> getPorts(@NotNull Project project, @NotNull ZipFile zipFile) throws InvalidServiceException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        WsdlUtils.validateDependencies(zipFile);
        WsdlData data = WsdlUtils.getWsdlData(project, zipFile);
        return data.ports;
    }

    public static String getServiceLocation(@NotNull Project project, @NotNull ZipFile zipFile) throws InvalidServiceException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getServiceLocation must not be null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getServiceLocation must not be null");
        }
        WsdlData data = WsdlUtils.getWsdlData(project, zipFile);
        return data.location;
    }

    public static String buildArgumentNameFromType(@NotNull TypeRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.buildArgumentNameFromType must not be null");
        }
        TypeDescription type = ref.get();
        return type.isBpmObject() || type.isXmlObject() || type.isPredefined() ? type.asSchemaObject().getName() : ref.getName();
    }

    public static List<PortTypeDescription> getPorts(@NotNull ServiceDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        ArrayList<PortTypeDescription> result = new ArrayList<PortTypeDescription>();
        String namespace = definition.getTargetNamespace();
        for (PortDefinition port : definition.getPortDefinitions()) {
            String name = port.getAttribute("name");
            PortTypeDescription portTypeData = new PortTypeDescription(name, new QName(namespace, name));
            Binding portBinding = WsdlUtils.findPortBinding(definition, port);
            if (portBinding != null) {
                portTypeData.setBinding(WsdlUtils.getSoapVersion(portBinding));
                Tuple<QName, QName> serviceInfo = WsdlUtils.getServiceInfo(definition, portBinding);
                portTypeData.setDefaultServiceName(serviceInfo.getFirst());
                portTypeData.setDefaultServicePort(serviceInfo.getSecond());
            }
            result.add(portTypeData);
        }
        return result;
    }

    private static Tuple<QName, QName> getServiceInfo(ServiceDefinition definition, Binding portBinding) {
        String targetNamespace = definition.getTargetNamespace();
        List<Service> services = definition.findChildrenByClass(Service.class);
        QName serviceName = null;
        QName portName = null;
        block0: for (Service service : services) {
            for (WsdlElement element : service.findChildrenByClass(WsdlElement.class)) {
                if (!"port".equals(element.getTagName())) continue;
                String serviceBinding = element.getAttribute("binding");
                Namespace bindingNamespace = definition.getNSContext().findNamespace(XmlUtils.prefix((String)serviceBinding));
                if (!targetNamespace.equals(bindingNamespace.getUri()) || !portBinding.getName().equals(XmlUtils.localname((String)serviceBinding))) continue;
                serviceName = new QName(targetNamespace, service.getName());
                portName = new QName(targetNamespace, element.getAttribute("name"));
                continue block0;
            }
        }
        if (serviceName == null) {
            Log.logSevere(ProjectCatalogMsg.ERROR("Service name not found for binding " + portBinding.getName()));
        }
        if (portName == null) {
            Log.logSevere(ProjectCatalogMsg.ERROR("Service port name not found for binding " + portBinding.getName()));
        }
        return Tuple.create(serviceName, portName);
    }

    private static String getSoapVersion(Binding portBinding) {
        String result = null;
        for (WsdlElement element : portBinding.findChildrenByClass(WsdlElement.class)) {
            if (!"binding".equals(element.getTagName())) continue;
            String elemNamespace = element.getNamespace();
            if (SOAP_NAMESPACE_1_1.equals(elemNamespace)) {
                result = "1.1";
                break;
            }
            if (!SOAP_NAMESPACE_1_2.equals(elemNamespace)) break;
            result = "1.2";
            break;
        }
        return result;
    }

    private static Binding findPortBinding(ServiceDefinition definition, PortDefinition port) {
        List<Binding> bindings = definition.getBindings();
        String targetNamespace = definition.getTargetNamespace();
        for (Binding binding : bindings) {
            String type = binding.getAttribute("type");
            if (type == null) continue;
            String portName = port.getAttribute("name");
            Namespace namespace = definition.getNSContext().findNamespace(XmlUtils.prefix((String)type));
            if (portName == null || !portName.equals(XmlUtils.localname((String)type)) || !targetNamespace.equals(namespace.getUri())) continue;
            return binding;
        }
        return null;
    }

    private static void checkMissing(Map<String, String> referenced) throws InvalidServiceException {
        if (referenced.isEmpty()) {
            return;
        }
        Map.Entry<String, String> entry = referenced.entrySet().iterator().next();
        String ref = entry.getKey();
        String doc = entry.getValue();
        throw InvalidServiceException.cannotResolveDependency(ref, doc, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<PortTypeDescription> getPorts(@NotNull Project project, @NotNull String fileName, @NotNull InputStream input, boolean validate) throws InvalidServiceException {
        ArrayList<PortTypeDescription> arrayList;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getPorts must not be null");
        }
        InputStream stream = input;
        try {
            WsdlParser parser;
            List<PortTypeDescription> result = new ArrayList<PortTypeDescription>();
            if (validate) {
                byte[] data = StreamUtils.readBytes(input);
                stream = new ByteArrayInputStream(data);
                WsdlUtils.validateDependencies(fileName, stream);
                stream = new ByteArrayInputStream(data);
            }
            if ((parser = WsdlUtils.getParser(project)) != null) {
                ServiceDefinition definition = parser.parseDefinition(WsdlUtils.getVFileUrl(project, fileName), stream);
                definition.verify();
                result = WsdlUtils.getPorts(definition);
            }
            input.close();
            arrayList = result;
        }
        catch (TypeParseException e) {
            try {
                throw InvalidServiceException.invalidWsdlFile(fileName, e);
                catch (IOException e2) {
                    throw InvalidServiceException.invalidWsdlFile(fileName, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(input);
                throw throwable;
            }
        }
        StreamUtils.close(input);
        return arrayList;
    }

    private static WsdlParser getParser(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getParser must not be null");
        }
        WsdlParser result = null;
        ProjectLoader loader = project.getLoader();
        if (loader != null) {
            ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
            VFileSystem fileSystem = projectFileSystem.getDataFileSystem();
            result = new WsdlParser(fileSystem, new WsdlTypeIndex());
            result.setXsdImportResolver(new OraMdsImportResolver());
            result.setCatalog(project.getComponentCatalog());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static WsdlData getWsdlData(@NotNull Project project, @NotNull ZipFile zipFile) throws InvalidServiceException {
        WsdlData wsdlData;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getWsdlData must not be null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getWsdlData must not be null");
        }
        String name = "";
        try {
            WsdlData result = null;
            for (ZipEntry zipEntry : CollectionUtils.each(zipFile.entries())) {
                List<PortTypeDescription> wsldPorts;
                if (!WsdlUtils.isWsdl(zipEntry) || (wsldPorts = WsdlUtils.getPorts(project, name = zipEntry.getName(), zipFile.getInputStream(zipEntry), false)).isEmpty()) continue;
                if (result != null) {
                    throw InvalidServiceException.moreThanOneServiceInZipFile(zipFile.getName());
                }
                result = new WsdlData(name, wsldPorts);
            }
            if (result == null) {
                throw InvalidServiceException.noServiceInZipFile(zipFile.getName());
            }
            wsdlData = result;
        }
        catch (IOException e) {
            throw InvalidServiceException.cannotLoadFileInZip(name, zipFile.getName());
        }
        if (wsdlData == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/utils/WsdlUtils.getWsdlData must not return null");
        }
        return wsdlData;
    }

    private static boolean isWsdl(ZipEntry zipEntry) {
        return !zipEntry.isDirectory() && WsdlUtils.isWsdl(zipEntry.getName());
    }

    private static boolean isWsdl(String entryName) {
        String wsdlExt = ".wsdl";
        int length = ".wsdl".length();
        return entryName.regionMatches(true, entryName.length() - length, ".wsdl", 0, length);
    }

    private static URL getVFileUrl(@NotNull Project project, @NotNull String fileName) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getVFileUrl must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.getVFileUrl must not be null");
        }
        ProjectLoader loader = project.getLoader();
        assert (loader != null) : "Cannot find loader for the project";
        ProjectFileSystem fileSystem = loader.getProjectFileSystem();
        VFileSystem system = fileSystem.getDataFileSystem();
        VFile file = system.createFile("/" + fileName);
        return file.toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateDependencies(@NotNull ZipFile zipFile) throws InvalidServiceException {
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.validateDependencies must not be null");
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        HashMap<String, String> referenced = new HashMap<String, String>();
        ArrayList<String> entries = new ArrayList<String>();
        for (ZipEntry zipEntry : CollectionUtils.each(zipFile.entries())) {
            if (zipEntry.isDirectory()) continue;
            String docName = ResourceUtils.slashify(zipEntry.getName());
            try {
                InputStream stream = zipFile.getInputStream(zipEntry);
                try {
                    entries.add(docName);
                    WsdlUtils.collectReferencedResources(docName, stream, referenced, inputFactory);
                    stream.close();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(stream);
                    throw throwable;
                }
                StreamUtils.close(stream);
            }
            catch (IOException e) {
                throw InvalidServiceException.cannotValidateZipFile(docName, e);
            }
        }
        referenced.keySet().removeAll(entries);
        WsdlUtils.checkMissing(referenced);
    }

    private static void validateDependencies(@NotNull String fileName, @NotNull InputStream inputStream) throws InvalidServiceException {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.validateDependencies must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.validateDependencies must not be null");
        }
        HashMap<String, String> referenced = new HashMap<String, String>();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        WsdlUtils.collectReferencedResources(ResourceUtils.slashify(fileName), inputStream, referenced, xmlInputFactory);
        WsdlUtils.checkMissing(referenced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectReferencedResources(@NotNull String docName, @NotNull InputStream stream, @NotNull Map<String, String> referenced, @NotNull XMLInputFactory inputFactory) throws InvalidServiceException {
        if (docName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.collectReferencedResources must not be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.collectReferencedResources must not be null");
        }
        if (referenced == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.collectReferencedResources must not be null");
        }
        if (inputFactory == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils.collectReferencedResources must not be null");
        }
        try {
            try {
                XMLStreamReader sr = inputFactory.createXMLStreamReader(stream);
                ResourceUtils.collectResources(sr, docName, referenced);
                sr.close();
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
            StreamUtils.close(stream);
        }
        catch (XMLStreamException e) {
            throw InvalidServiceException.cannotValidateZipFile(docName, e);
        }
    }

    private static class WsdlTypeIndex
    implements TypeIndex {
        private WsdlTypeIndex() {
        }

        @Nullable
        public TypeRef findExact(@NotNull String typeName) {
            if (typeName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findExact must not be null");
            }
            return null;
        }

        @Nullable
        public TypeRef findById(@NotNull String componentType, @NotNull String id) {
            if (componentType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findById must not be null");
            }
            if (id == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findById must not be null");
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public SortedSet<TypeRef> findByPropertyValue(@NotNull String propertyName, @NotNull String propertyValue) {
            if (propertyName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findByPropertyValue must not be null");
            }
            if (propertyValue == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findByPropertyValue must not be null");
            }
            SortedSet<TypeRef> sortedSet = CollectionUtils.emptySortedSet();
            if (sortedSet == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/utils/WsdlUtils$WsdlTypeIndex.findByPropertyValue must not return null");
            }
            return sortedSet;
        }
    }

    private static class WsdlData {
        final String location;
        final List<PortTypeDescription> ports;

        WsdlData(@NotNull String location, @NotNull List<PortTypeDescription> ports) {
            if (location == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlData.<init> must not be null");
            }
            if (ports == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/WsdlUtils$WsdlData.<init> must not be null");
            }
            this.ports = Collections.unmodifiableList(ports);
            this.location = location;
        }
    }
}

