/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.bpm.collections.Tuple;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.project.catalog.utils.InvalidServiceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceUtils {
    private static final QName IMPORT_TAG = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName INCLUDE_TAG = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName WSDL_IMPORT_TAG = new QName("http://schemas.xmlsoap.org/wsdl/", "import");

    public static Tuple<String, ZipFile> buildResourceDependencies(@NotNull VFile root, @NotNull File zipFile) throws InvalidServiceException {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.buildResourceDependencies must not be null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.buildResourceDependencies must not be null");
        }
        return Tuple.create(root.getCanonicalPath(), ResourceUtils.zip(ResourceUtils.extractResourceDependencies(root), zipFile));
    }

    static void collectResources(@NotNull XMLStreamReader sr, @NotNull String docName, @NotNull Map<String, String> referenced) throws XMLStreamException, InvalidServiceException {
        if (sr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.collectResources must not be null");
        }
        if (docName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.collectResources must not be null");
        }
        if (referenced == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.collectResources must not be null");
        }
        URI docUri = ResourceUtils.buildURI(docName);
        while (sr.hasNext()) {
            int eventCode = sr.next();
            if (eventCode != 1) continue;
            QName srName = sr.getName();
            String location = null;
            if (IMPORT_TAG.equals(srName) || INCLUDE_TAG.equals(srName)) {
                location = ResourceUtils.findAttribute(sr, "schemaLocation");
            } else if (WSDL_IMPORT_TAG.equals(srName)) {
                location = ResourceUtils.findAttribute(sr, "location");
            }
            if (location != null) {
                location = ResourceUtils.processLocation(docUri, location);
            }
            if (location == null) continue;
            referenced.put(location, docName);
        }
    }

    static String slashify(String name) {
        return name.startsWith("/") ? name : '/' + name;
    }

    private static Set<VFile> extractResourceDependencies(@NotNull VFile root) throws InvalidServiceException {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.extractResourceDependencies must not be null");
        }
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        HashSet<VFile> dependencies = new HashSet<VFile>();
        ResourceUtils.resourceDependencies(xmlInputFactory, root, dependencies);
        return dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ZipFile zip(@NotNull Set<VFile> resources, @NotNull File targetFile) throws InvalidServiceException {
        if (resources == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.zip must not be null");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.zip must not be null");
        }
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        out = new ZipOutputStream(new FileOutputStream(targetFile));
        InputStream in = null;
        for (VFile resource : resources) {
            try {
                int len;
                in = resource.openInputStream();
                out.putNextEntry(new ZipEntry(resource.getCanonicalPath()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
            StreamUtils.close(in);
        }
        StreamUtils.close(out);
        try {
            return new ZipFile(targetFile);
        }
        catch (IOException e) {
            throw InvalidServiceException.cannotCreateZip(targetFile.getName(), e);
        }
        catch (IOException e) {
            try {
                throw InvalidServiceException.cannotCreateZip(targetFile.getName(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
    }

    private static void resourceDependencies(@NotNull XMLInputFactory xmlInputFactory, @NotNull VFile root, @NotNull Set<VFile> dependencies) throws InvalidServiceException {
        if (xmlInputFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.resourceDependencies must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.resourceDependencies must not be null");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.resourceDependencies must not be null");
        }
        dependencies.add(root);
        Map<String, String> localImports = ResourceUtils.getLocalImports(xmlInputFactory, root);
        for (String importLocation : localImports.keySet()) {
            VFile importReference = ResourceUtils.getVFile(root, importLocation, localImports.get(importLocation));
            if (dependencies.contains(importReference)) continue;
            ResourceUtils.resourceDependencies(xmlInputFactory, importReference, dependencies);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getLocalImports(@NotNull XMLInputFactory xmlInputFactory, @NotNull VFile root) throws InvalidServiceException {
        HashMap<String, String> hashMap;
        if (xmlInputFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.getLocalImports must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.getLocalImports must not be null");
        }
        HashMap<String, String> referenced = new HashMap<String, String>();
        VFileInputStream inputStream = null;
        try {
            inputStream = new VFileInputStream(root);
            XMLStreamReader sr = xmlInputFactory.createXMLStreamReader((InputStream)inputStream);
            ResourceUtils.collectResources(sr, ResourceUtils.slashify(root.getCanonicalPath()), referenced);
            sr.close();
            hashMap = referenced;
        }
        catch (XMLStreamException e) {
            try {
                throw InvalidServiceException.invalidXsdFile(root.getCanonicalPath(), e);
                catch (IOException e2) {
                    throw InvalidServiceException.invalidLocationReference(root.getCanonicalPath(), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{inputStream});
        return hashMap;
    }

    private static VFile getVFile(@NotNull VFile root, @NotNull String location, String reference) throws InvalidServiceException {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.getVFile must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.getVFile must not be null");
        }
        VFile file = root.getFileSystem().createFile(location);
        if (!file.exists()) {
            throw InvalidServiceException.cannotResolveDependency(location, reference, null);
        }
        return file;
    }

    private static URI buildURI(String docName) {
        try {
            return new URI("uri", null, docName, null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(e);
            throw iae;
        }
    }

    @Nullable
    private static String findAttribute(XMLStreamReader sr, String attributeName) {
        for (int i = 0; i < sr.getAttributeCount(); ++i) {
            String localName = sr.getAttributeLocalName(i);
            if (!localName.equals(attributeName)) continue;
            return sr.getAttributeValue(i);
        }
        return null;
    }

    @Nullable
    private static String processLocation(@NotNull URI docUri, @NotNull String location) throws InvalidServiceException {
        URI locUri;
        if (docUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.processLocation must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/ResourceUtils.processLocation must not be null");
        }
        try {
            locUri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw InvalidServiceException.cannotResolveDependency(location, docUri.getPath(), e);
        }
        if (locUri.isAbsolute()) {
            return null;
        }
        return docUri.resolve(locUri).normalize().getPath();
    }
}

