/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.utils;

import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class TaskManagementServiceHelper {
    public static final String TASK_MANAGEMENT_SERVICE = "TaskManagementService";
    public static final String UPDATE_OUTCOME = "updateOutcome";
    public static final String UPDATE_PRIORITY = "updatePriority";
    public static final String WITHDRAW = "withdraw";
    public static final String SUSPEND = "suspend";
    public static final String RESUME = "resume";
    public static final String ESCALATE = "escalate";
    public static final String REASSIGN = "reassign";
    public static final String SUSPEND_TIMERS = "suspendTimers";
    public static final String RESUME_TIMERS = "resumeTimers";
    public static final String OUTCOME = "outcome";
    public static final String PRIORITY = "priority";
    public static final String ASSIGNED_USER = "assignedUser";

    public static String buildTaskManagementReferenceName() {
        return TASK_MANAGEMENT_SERVICE;
    }

    public static String getOperationNativeName(@NotNull UpdateType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/TaskManagementServiceHelper.getOperationNativeName must not be null");
        }
        String result = null;
        if (type == UpdateType.UPDATE_OUTCOME) {
            result = UPDATE_OUTCOME;
        } else if (type == UpdateType.UPDATE_PRIORITY) {
            result = UPDATE_PRIORITY;
        } else if (type == UpdateType.WITHDRAW) {
            result = WITHDRAW;
        } else if (type == UpdateType.SUSPEND) {
            result = SUSPEND;
        } else if (type == UpdateType.RESUME) {
            result = RESUME;
        } else if (type == UpdateType.ESCALATE) {
            result = ESCALATE;
        } else if (type == UpdateType.REASSIGN) {
            result = REASSIGN;
        } else if (type == UpdateType.SUSPEND_TIMERS) {
            result = SUSPEND_TIMERS;
        } else if (type == UpdateType.RESUME_TIMERS) {
            result = RESUME_TIMERS;
        }
        return result;
    }

    public static TypeDescription createTaskManagementService() {
        ObjectTypeDescription result = new ObjectTypeDescription(TASK_MANAGEMENT_SERVICE);
        result.addMember(TaskManagementServiceHelper.buildUpdateOutcome());
        result.addMember(TaskManagementServiceHelper.buildUpdatePriority());
        result.addMember(TaskManagementServiceHelper.buildWithdraw());
        result.addMember(TaskManagementServiceHelper.buildSuspend());
        result.addMember(TaskManagementServiceHelper.buildResume());
        result.addMember(TaskManagementServiceHelper.buildEscalate());
        result.addMember(TaskManagementServiceHelper.buildReassign());
        result.addMember(TaskManagementServiceHelper.buildSuspendTimers());
        result.addMember(TaskManagementServiceHelper.buildResumeTimers());
        return result;
    }

    private static MethodTypeDescription buildUpdateOutcome() {
        MethodTypeDescription result = new MethodTypeDescription(UPDATE_OUTCOME);
        result.addArgument(new Argument(OUTCOME, (TypeRef)TypeFactory.getString(), 1L));
        return result;
    }

    private static MethodTypeDescription buildUpdatePriority() {
        MethodTypeDescription result = new MethodTypeDescription(UPDATE_PRIORITY);
        result.addArgument(new Argument(PRIORITY, (TypeRef)TypeFactory.getInt(), 1L));
        return result;
    }

    private static MethodTypeDescription buildWithdraw() {
        return new MethodTypeDescription(WITHDRAW);
    }

    private static MethodTypeDescription buildSuspend() {
        return new MethodTypeDescription(SUSPEND);
    }

    private static MethodTypeDescription buildResume() {
        return new MethodTypeDescription(RESUME);
    }

    private static MethodTypeDescription buildEscalate() {
        return new MethodTypeDescription(ESCALATE);
    }

    private static MethodTypeDescription buildReassign() {
        MethodTypeDescription result = new MethodTypeDescription(REASSIGN);
        result.addArgument(new Argument(ASSIGNED_USER, (TypeRef)TypeFactory.getString(), 1L));
        return result;
    }

    private static MethodTypeDescription buildSuspendTimers() {
        return new MethodTypeDescription(SUSPEND_TIMERS);
    }

    private static MethodTypeDescription buildResumeTimers() {
        return new MethodTypeDescription(RESUME_TIMERS);
    }
}

