/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.Restriction;
import oracle.bpm.project.catalog.parser.xsd.RestrictionBuilder;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.parser.xsd.Sequence;
import oracle.bpm.project.catalog.parser.xsd.SimpleType;
import oracle.bpm.project.catalog.type.BpmObjectSchemaHelper;
import oracle.bpm.project.catalog.type.BpmoWriterContext;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeToXsdMapping;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ElementBuilder {
    private final String IMPORTED_PREFIX_PX = "ns";
    private int importedCount;
    private final Set<oracle.bpm.project.catalog.parser.xsd.Import> schemaImports;
    private final BpmoWriterContext writerContext;
    private final Map<String, Import> wsdlImports;
    private final String xmlschemaPrefix;

    public ElementBuilder(@NotNull String xmlschemaPrefix, @NotNull BpmoWriterContext context) {
        if (xmlschemaPrefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.<init> must not be null");
        }
        this.IMPORTED_PREFIX_PX = "ns";
        this.importedCount = 1;
        this.schemaImports = new HashSet<oracle.bpm.project.catalog.parser.xsd.Import>();
        this.wsdlImports = new Hashtable<String, Import>();
        this.xmlschemaPrefix = xmlschemaPrefix;
        this.writerContext = context;
    }

    public Collection<oracle.bpm.project.catalog.parser.xsd.Import> getSchemaImports() {
        return this.schemaImports;
    }

    public void clearSchemaImports() {
        this.schemaImports.clear();
    }

    public void addSchemaImport(@NotNull oracle.bpm.project.catalog.parser.xsd.Import anImport) {
        if (anImport == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.addSchemaImport must not be null");
        }
        this.schemaImports.add(anImport);
    }

    public Collection<Import> getWsdlImports() {
        return this.wsdlImports.values();
    }

    public Import addWsdlImport(@NotNull Import anImport) {
        if (anImport == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.addWsdlImport must not be null");
        }
        return this.wsdlImports.put(anImport.getImportedNamespace(), anImport);
    }

    ElementDef buildElementForArgument(@NotNull Argument argument, @NotNull NamespaceContext sequenceContext, @NotNull NamespaceContext schemaContext, boolean customizedServiceArg) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForArgument must not be null");
        }
        if (sequenceContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForArgument must not be null");
        }
        if (schemaContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForArgument must not be null");
        }
        TypeDescription type = argument.getType();
        if (this.isOpaque(type)) {
            XmlTypeDescription xmlotd = type.isBpmObject() ? BpmObjectSchemaHelper.findSchemaForBpmObject(type.asBpmObject()) : (XmlTypeDescription)type;
            String location = xmlotd.getLocation();
            String namespace = xmlotd.getNamespace();
            assert (!Str.isEmpty(namespace)) : "Namespace is empty";
            if (!this.wsdlImports.containsKey(namespace)) {
                location = URLHelper.buildRelativeLocation((String)this.writerContext.getWsdlLocation(), (String)location);
                Import imp = WsdlElementFactory.createImport(namespace, location, null);
                this.wsdlImports.put(namespace, imp);
            }
        }
        return this.buildElementForType(type, argument.getName(), argument.getDefaultValue(), false, sequenceContext, schemaContext, customizedServiceArg);
    }

    ElementDef buildElementForAttribute(@NotNull AttributeTypeDescription atd, @NotNull NamespaceContext sequenceContext, @NotNull NamespaceContext schemaContext) {
        if (atd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForAttribute must not be null");
        }
        if (sequenceContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForAttribute must not be null");
        }
        if (schemaContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildElementForAttribute must not be null");
        }
        TypeDescription type = atd.getType();
        if (type.isUnknown()) {
            String id;
            XmlUUID xmlUUID;
            String namespace;
            TypeRef ref = atd.getTypeRef();
            ElementDef result = null;
            if (ref instanceof BpmObjectDynamicRef && (namespace = (xmlUUID = UUIDFactory.parseXmlId((String)(id = ((BpmObjectDynamicRef)ref).getId()))).getNamespace()).startsWith("http://xmlns.oracle.com/bpm/bpmobject/")) {
                String location = this.inferLocation(namespace);
                result = this.buildXmlObjectElement(xmlUUID.getNativeName(), namespace, location, schemaContext, xmlUUID.getElemType(), false, atd.getName(), !atd.isRequired(), sequenceContext);
            }
            if (result != null) {
                return result;
            }
            TypeDescription parent = atd.getParent();
            ComponentCatalog catalog = atd.getCatalog();
            TypeRef bpmObjectBySchemaId = null;
            if (catalog != null) {
                bpmObjectBySchemaId = catalog.findBpmObjectBySchemaId(parent.getId());
            }
            String bpmObjectName = bpmObjectBySchemaId == null ? parent.getName() : bpmObjectBySchemaId.getText();
            throw new IllegalArgumentException(ProjectCatalogMsg.INVALID_ARGUMENT_TYPE(bpmObjectName, atd.getName()).getString());
        }
        if (this.isOpaque(type)) {
            throw new IllegalArgumentException(ProjectCatalogMsg.INVALID_IN_LINE_WSDL_ARGUMENT(type.getText()).getString());
        }
        return this.buildElementForType(type, atd.getName(), atd.getDefaultValue(), !atd.isRequired(), sequenceContext, schemaContext, false);
    }

    private String inferLocation(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.inferLocation must not be null");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append("businessCatalog");
        builder.append("/");
        builder.append(namespace.substring("http://xmlns.oracle.com/bpm/bpmobject/".length()));
        builder.append(".xsd");
        return builder.toString();
    }

    private boolean isOpaque(TypeDescription type) {
        XmlTypeDescription xmlotd = null;
        if (type.isBpmObject()) {
            xmlotd = BpmObjectSchemaHelper.findSchemaForBpmObject(type.asBpmObject());
        } else if (type instanceof XmlTypeDescription) {
            xmlotd = (XmlTypeDescription)type;
        }
        return xmlotd != null && xmlotd.isWsdlInlineObject();
    }

    private ElementDef buildElementForType(TypeDescription type, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext, NamespaceContext schemaContext, boolean customizedServiceArg) {
        ElementDef result = null;
        switch (type.getKind()) {
            case 5: {
                result = this.buildStringElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 2: {
                result = this.buildTypeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 1: {
                result = this.buildTypeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 4: {
                result = this.buildTypeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 3: {
                result = this.buildDecimalElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 6: {
                result = this.buildTimeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 7: {
                result = this.buildDurationElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 8: {
                result = this.buildTypeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 10: {
                result = this.buildTypeElement(type, name, defaultValue, nillable, sequenceContext);
                break;
            }
            case 13: {
                break;
            }
            case 19: {
                break;
            }
            case 12: {
                ArrayTypeDescription artd = (ArrayTypeDescription)type;
                result = this.buildArrayTypeElement(artd, name, defaultValue, nillable, sequenceContext, schemaContext);
                break;
            }
            case 11: 
            case 17: {
                XmlTypeDescription xmlotd = null;
                if (type.isBpmObject()) {
                    XObjectTypeDescription anXotd = (XObjectTypeDescription)type;
                    xmlotd = TypeUtils.getModelObject((ObjectTypeDescription)anXotd);
                } else if (type instanceof XmlTypeDescription) {
                    xmlotd = (XmlTypeDescription)type;
                }
                if (xmlotd == null) break;
                String namespace = xmlotd.getNamespace();
                String location = xmlotd.getLocation();
                String typeName = xmlotd.getNativeName();
                if (Str.isEmpty(namespace) || Str.isEmpty(location)) break;
                String prefix = this.addImport(namespace, location, xmlotd.isWsdlInlineObject(), schemaContext);
                if (xmlotd.isElement()) {
                    QName qName;
                    SchemaObject so = xmlotd.asSchemaObject();
                    if (!customizedServiceArg && so.isBpmObjectNamespace() && (qName = so.getElementTypeQName()) != null && so.getNamespace().equals(qName.getNamespaceURI())) {
                        result = this.buildObjectElement(qName.getLocalPart(), name, nillable, sequenceContext, prefix);
                    }
                    if (result != null) break;
                    result = this.buildRefElement(typeName, prefix, schemaContext);
                    QName argName = new QName("http://xmlns.oracle.com/bpm/bpmobject/", "name");
                    result.setAttribute(argName, name);
                    break;
                }
                result = this.buildObjectElement(typeName, name, nillable, sequenceContext, prefix);
            }
        }
        return result;
    }

    private ElementDef buildXmlObjectElement(String typeName, String namespace, String location, NamespaceContext schemaContext, XmlElementType xmlElementType, boolean customizedServiceArg, String name, boolean nillable, NamespaceContext sequenceContext) {
        ElementDef result = null;
        if (!Str.isEmpty(namespace) && !Str.isEmpty(location)) {
            String prefix = this.addImport(namespace, location, location.endsWith(".wsdl"), schemaContext);
            if (xmlElementType == XmlElementType.ELEMENT && !customizedServiceArg && namespace.startsWith("http://xmlns.oracle.com/bpm/bpmobject/")) {
                String boTypeName = typeName + "Type";
                result = this.buildObjectElement(boTypeName, name, nillable, sequenceContext, prefix);
                if (result == null) {
                    result = this.buildRefElement(typeName, prefix, schemaContext);
                    QName argName = new QName("http://xmlns.oracle.com/bpm/bpmobject/", "name");
                    result.setAttribute(argName, name);
                }
            } else {
                result = this.buildObjectElement(typeName, name, nillable, sequenceContext, prefix);
            }
        }
        return result;
    }

    private ElementDef buildArrayTypeElement(ArrayTypeDescription artd, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext, NamespaceContext schemaContext) {
        ElementDef result;
        TypeDescription td = artd.getElementType();
        if (td.isPredefined() || td.isObject()) {
            SchemaObject so;
            if (td.isXmlObject() && (so = td.asSchemaObject()).isElement()) {
                throw new IllegalArgumentException("The type '" + td.getText() + "' is an element and cannot be used as array's type");
            }
            result = this.buildElementForType(td, name, defaultValue, nillable, sequenceContext, schemaContext, false);
        } else {
            result = SchemaElementFactory.createElement(name, sequenceContext);
            ComplexType ct = SchemaElementFactory.createComplexType(result.getNSContext());
            result.addChild(ct);
            Sequence sequence = SchemaElementFactory.createSequence(ct.getNSContext());
            ct.addChild(sequence);
            ElementDef def = this.buildElementForType(td, Kind.getName(td.getKind()), defaultValue, nillable, sequence.getNSContext(), schemaContext, false);
            if (def != null) {
                sequence.addChild(def);
            } else {
                return null;
            }
        }
        if (result != null) {
            result.setMaxOccurs("unbounded");
        }
        return result;
    }

    private String addImport(String namespace, String location, boolean isOpaque, NamespaceContext schemaContext) {
        oracle.bpm.project.catalog.parser.xsd.Import anImport;
        String prefix;
        Set<String> prefixSet = schemaContext.getLocalDeclaredUriToPrefixMap().get(namespace);
        if (prefixSet != null) {
            prefix = prefixSet.iterator().next();
        } else {
            String existingNamespace;
            do {
                prefix = "ns" + this.importedCount;
                existingNamespace = schemaContext.getLocalDeclaredPrefixToUriMap().get(prefix);
                ++this.importedCount;
            } while (existingNamespace != null);
            schemaContext.addNamespace(prefix, namespace);
        }
        if (!isOpaque && !this.schemaImports.contains(anImport = SchemaElementFactory.createImport(namespace, location = URLHelper.buildRelativeLocation((String)this.writerContext.getWsdlLocation(), (String)location)))) {
            anImport.setNSContext(new NamespaceContext(schemaContext));
            this.schemaImports.add(anImport);
        }
        return prefix;
    }

    private ElementDef buildObjectElement(String typeName, String name, boolean nillable, NamespaceContext sequenceContext, String prefix) {
        String objectType = Str.isEmpty(prefix) ? typeName : prefix + ":" + typeName;
        ElementDef result = SchemaElementFactory.createElementWithType(name, objectType, nillable, sequenceContext);
        return result;
    }

    private ElementDef buildRefElement(@NotNull String name, @NotNull String prefix, @NotNull NamespaceContext sequenceContext) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildRefElement must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildRefElement must not be null");
        }
        if (sequenceContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ElementBuilder.buildRefElement must not be null");
        }
        return SchemaElementFactory.createElementRef(prefix + ":" + name, sequenceContext);
    }

    private ElementDef buildDurationElement(TypeDescription td, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext) {
        String type = this.xmlschemaPrefix + ":" + TypeToXsdMapping.getTypeMapping((TypeDescription)td);
        Interval interval = Interval.valueOf(defaultValue);
        defaultValue = interval != null ? interval.toXMLString() : null;
        ElementDef result = SchemaElementFactory.createElementWithType(name, type, nillable, defaultValue, sequenceContext);
        return result;
    }

    private ElementDef buildTimeElement(TypeDescription td, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext) {
        String type = this.xmlschemaPrefix + ":" + TypeToXsdMapping.getTypeMapping((TypeDescription)td);
        int precision = td.getScale();
        Time time = Time.valueOf(defaultValue);
        switch (precision) {
            case 0: {
                defaultValue = time != null ? time.toDateString() : null;
                break;
            }
            case 1: {
                defaultValue = time != null ? time.toTimeString() : null;
                break;
            }
            case 4: {
                defaultValue = time != null ? time.toGYearMonthString() : null;
                break;
            }
            case 3: {
                defaultValue = time != null ? time.toGMonthDayString() : null;
                break;
            }
            default: {
                defaultValue = time != null ? time.toXMLString() : null;
            }
        }
        ElementDef result = SchemaElementFactory.createElementWithType(name, type, nillable, defaultValue, sequenceContext);
        return result;
    }

    private ElementDef buildDecimalElement(TypeDescription td, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext) {
        ElementDef result;
        String type = this.xmlschemaPrefix + ":" + TypeToXsdMapping.getTypeMapping((TypeDescription)td);
        int length = td.getLength();
        int scale = td.getScale();
        if (length > 0 || scale >= 0) {
            result = SchemaElementFactory.createElement(name, nillable, defaultValue, sequenceContext);
            SimpleType simpleType = SchemaElementFactory.createSimpleType();
            NamespaceContext simpleTypeContext = new NamespaceContext(result.getNSContext());
            simpleType.setNSContext(simpleTypeContext);
            result.addChild(simpleType);
            RestrictionBuilder builder = new RestrictionBuilder(simpleTypeContext, type);
            if (length > 0) {
                builder.setTotalDigits(length);
            }
            if (scale >= 0) {
                builder.setFractionDigits(scale);
            }
            Restriction restriction = builder.build();
            simpleType.addChild(restriction);
        } else {
            result = SchemaElementFactory.createElementWithType(name, type, nillable, defaultValue, sequenceContext);
        }
        return result;
    }

    private ElementDef buildTypeElement(TypeDescription td, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext) {
        String type = this.xmlschemaPrefix + ":" + TypeToXsdMapping.getTypeMapping((TypeDescription)td);
        ElementDef result = SchemaElementFactory.createElementWithType(name, type, nillable, defaultValue, sequenceContext);
        return result;
    }

    private ElementDef buildStringElement(TypeDescription td, String name, String defaultValue, boolean nillable, NamespaceContext sequenceContext) {
        ElementDef result;
        String type = this.xmlschemaPrefix + ":" + TypeToXsdMapping.getTypeMapping((TypeDescription)td);
        int length = td.getLength();
        if (length > 0) {
            result = SchemaElementFactory.createElement(name, nillable, defaultValue, sequenceContext);
            SimpleType simpleType = SchemaElementFactory.createSimpleType();
            NamespaceContext simpleTypeContext = new NamespaceContext(result.getNSContext());
            simpleType.setNSContext(simpleTypeContext);
            result.addChild(simpleType);
            RestrictionBuilder builder = new RestrictionBuilder(simpleTypeContext, type);
            builder.setMaxLength(length);
            Restriction restriction = builder.build();
            simpleType.addChild(restriction);
        } else {
            result = SchemaElementFactory.createElementWithType(name, type, nillable, defaultValue, sequenceContext);
        }
        return result;
    }
}

