/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.recognizer;

import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.catalog.recognizer.FileHeader;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.recognizer.ResourceTypeRecognizer;
import org.jetbrains.annotations.NotNull;

public class CompositeResourceRecognizer
implements ResourceTypeRecognizer {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = ResourceType.COMPOSITE;
        if (resourceType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/CompositeResourceRecognizer.getResourceType must not return null");
        }
        return resourceType;
    }

    @Override
    public boolean recognizeByFileExtension(@NotNull FileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/CompositeResourceRecognizer.recognizeByFileExtension must not be null");
        }
        return header.getFile().getName().equals("/composite.xml");
    }

    @Override
    public boolean recognizeResource(@NotNull FileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/CompositeResourceRecognizer.recognizeResource must not be null");
        }
        boolean result = false;
        VFile file = header.getFile();
        String fileName = file.getCanonicalPath();
        if (!file.isZeroLength() && fileName.equals("/composite.xml")) {
            result = true;
        }
        return result;
    }
}

