/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.recognizer;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.catalog.recognizer.FileHeader;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.recognizer.ResourceTypeRecognizer;
import oracle.bpm.project.catalog.type.TypeLoadRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceTypeRecognizer
implements ResourceTypeRecognizer {
    private String fileExtension;
    private Pattern pattern;
    private ResourceType resourceType;

    protected AbstractResourceTypeRecognizer(@NotNull ResourceType resourceType, @NotNull String fileExtension) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.<init> must not be null");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.<init> must not be null");
        }
        this(resourceType, fileExtension, null);
    }

    protected AbstractResourceTypeRecognizer(@NotNull ResourceType resourceType, @NotNull String fileExtension, @Nullable String searchPattern) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.<init> must not be null");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.<init> must not be null");
        }
        this.resourceType = resourceType;
        this.fileExtension = fileExtension;
        this.pattern = searchPattern != null ? Pattern.compile(searchPattern) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = this.resourceType;
        if (resourceType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.getResourceType must not return null");
        }
        return resourceType;
    }

    @Override
    public boolean recognizeByFileExtension(@NotNull FileHeader resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.recognizeByFileExtension must not be null");
        }
        return resource.getFile().getName().endsWith(this.fileExtension);
    }

    @Override
    public boolean recognizeResource(@NotNull FileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/AbstractResourceTypeRecognizer.recognizeResource must not be null");
        }
        try {
            VFile file = header.getFile();
            String fileName = file.getName();
            boolean result = false;
            if (fileName.endsWith(this.fileExtension) && !file.isZeroLength()) {
                if (this.pattern == null) {
                    result = true;
                } else {
                    Matcher matcher = this.pattern.matcher(header.getHeader());
                    result = matcher.matches();
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new TypeLoadRuntimeException(e);
        }
    }
}

