/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import javax.xml.namespace.QName;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.ComplexTypeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

public class SimpleType
extends SchemaElement {
    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        if (this.type != null) {
            return this.type;
        }
        String type = this.getType();
        TypeDescription simpleType = type != null ? this.findType(type) : this.buildSubElements(current);
        TypeDescription result = SimpleType.ensureIsSimple(simpleType);
        if (this.getName() != null) {
            QName thisQName = new QName(this.getTarget().getUri(), this.getName());
            if (current == null && !thisQName.equals(result.asSchemaObject().getQName())) {
                result = XmlTypeDescription.createPointerToType((String)this.getName(), (String)this.getTarget().getUri(), (TypeRef)result);
            }
        }
        this.type = result;
        return result;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareType(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
            catch (UnsupportedOperationException e) {
                throw TypeNotFoundException.wrap(new ComplexTypeNotFoundException(name, this.getTarget()), (DefaultElement)this);
            }
        }
    }

    static TypeDescription ensureIsSimple(TypeDescription type) {
        if (type == null) {
            type = TypeFactory.getString();
        }
        TypeDescription realType = null;
        if (type.isObject()) {
            ObjectTypeDescription otd = type.asObject();
            realType = (TypeDescription)otd.getTransientProperty("real.type");
        }
        if (realType != null) {
            type = realType;
        } else if (!(type.isPredefined() || type.isEnum() || type.isArray())) {
            type = TypeFactory.getString();
        } else if (type.isAny()) {
            type = TypeFactory.getString();
        }
        return type;
    }

    private String getName() {
        return this.getAttribute("name");
    }

    private String getType() {
        return this.getAttribute("type");
    }
}

