/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.List;
import java.util.TreeMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Particle;
import org.jetbrains.annotations.Nullable;

public class Sequence
extends Particle {
    @Override
    protected AttrGroupTypeDescription buildAttributes(TypeDescription current, boolean mergeGroups) throws TypeBuildException {
        if (this.getMaxOccurs() != 1) {
            return new AttrGroupTypeDescription();
        }
        AttributeTypeDescription[] attributes = this.buildAttributeTypes(current, mergeGroups);
        AttrGroupTypeDescription group = new AttrGroupTypeDescription();
        if (attributes != null) {
            int length = attributes.length;
            List list = ((ObjectTypeDescription)current).getAttributes();
            int position = list != null ? list.size() : 0;
            for (int i = 0; i < length; ++i) {
                int nextIndex;
                int nextIndex2;
                AttributeTypeDescription attr = attributes[i].clone();
                TreeMap properties = new TreeMap(attr.getProperties());
                attr.setProperties(properties);
                String writeSignature = attr.getWriteSignature();
                if (writeSignature.charAt(0) == '@' && (nextIndex2 = writeSignature.indexOf(";")) != -1) {
                    writeSignature = writeSignature.substring(nextIndex2 + 1);
                }
                writeSignature = String.valueOf('@') + position + ";" + writeSignature;
                attr.setWriteSignature(writeSignature);
                String readSignature = attr.getReadSignature();
                if (readSignature.charAt(0) == '@' && (nextIndex = readSignature.indexOf(";")) != -1) {
                    readSignature = readSignature.substring(nextIndex + 1);
                }
                readSignature = String.valueOf('@') + position + ";" + readSignature;
                attr.setReadSignature(readSignature);
                attr.setProperty(Literals.ELEMENT_POSITION, Integer.toString(position));
                ++position;
                group.addAttribute(attr);
            }
        }
        return group;
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        boolean hasMinOccurrs;
        boolean hasMaxOccurrs = this.getAttribute("maxOccurs") != null;
        boolean bl = hasMinOccurrs = this.getAttribute("minOccurs") != null;
        if (hasMaxOccurrs || hasMinOccurrs) {
            this.reportWarning(ProjectCatalogMsg.SEQUENCE_WITH_RESTRICTION_NOT_SUPPORTED.getString());
        }
        return this.buildAttributes(current, true);
    }

    @Nullable
    private AttributeTypeDescription[] buildAttributeTypes(TypeDescription current, boolean mergeGroups) throws TypeBuildException {
        AttrGroupTypeDescription group = super.buildAttributes(current, mergeGroups);
        return group.getAttributes();
    }
}

