/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlEnumTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Attribute;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.parser.xsd.Enumeration;
import oracle.bpm.project.catalog.parser.xsd.FractionDigits;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SimpleType;
import oracle.bpm.project.catalog.parser.xsd.TotalDigits;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidSchemaElementException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Restriction
extends ComponentDef {
    private static final String SOAPENC_ARRAY = "soapenc:Array";
    private static final String NAMESPACE = "namespace";
    static final String SOAP_ARRAY = "soapArray";

    public String getBase() {
        return super.getAttribute("base");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        int maxLength;
        String base = this.getBase();
        ObjectTypeDescription baseType = XmlTypeHelper.XMLOBJECT;
        if (base != null) {
            baseType = this.findType(base);
        }
        assert (baseType != null) : "baseType is null!";
        SchemaElement first = this.getFirst();
        if (first instanceof SimpleType) {
            baseType = first.buildType(current);
            first = first.getNext();
        } else if (this.isEnumeration() && baseType.isPredefined()) {
            DefaultElement parent = this.getParent();
            String name = this.findEnumName(parent);
            String enumNamespace = this.getContext().getTarget().getUri();
            if (name == null) throw new InvalidSchemaElementException(this.getTagName(), (SchemaElement)this);
            if (enumNamespace == null) throw new InvalidSchemaElementException(this.getTagName(), (SchemaElement)this);
            String parentFullName = this.getContext().buildParentFullName();
            baseType = XmlEnumTypeDescription.create((String)name, (String)enumNamespace, (String)parentFullName);
        } else if (baseType.isArray()) {
            TypeDescription atype;
            String arrayType;
            if (base != null && base.startsWith(SOAPENC_ARRAY)) {
                ObjectTypeDescription objTypeDesc = (ObjectTypeDescription)current;
                this.reportWarning(ProjectCatalogMsg.SOAP_ENCODING_ARRAY_WARNING(objTypeDesc.getProperty("nativeName"), objTypeDesc.getProperty(NAMESPACE)).toString());
            }
            if ((arrayType = this.findArrayType()) != null && (atype = this.buildArrayType(arrayType)) != null && atype.isArray()) {
                ArrayTypeDescription objectType = (ArrayTypeDescription)atype;
                objectType.setProperty(SOAP_ARRAY, Boolean.TRUE.toString());
                if (!current.isXmlObject()) return objectType;
                SchemaObject schemaObject = current.asSchemaObject();
                return XmlTypeDescription.createPointerToType((String)schemaObject.getName(), (String)schemaObject.getNamespace(), (TypeRef)objectType);
            }
        } else if (baseType.isNumber()) {
            int totalDigits = this.findTotalDigits();
            int fractionDigits = this.findFractionDigits();
            if (totalDigits != 0) {
                baseType = baseType.setLength(totalDigits);
            }
            if (fractionDigits != 0) {
                baseType = baseType.setScale(fractionDigits);
            }
        } else if (baseType.isString() && (maxLength = this.findMaxLength()) != 0) {
            baseType = baseType.setLength(maxLength);
        }
        AttrGroupTypeDescription group = this.buildAttributes(first, (TypeDescription)baseType, true);
        assert (baseType != null) : "baseType is null!";
        if (!baseType.isAny()) return baseType;
        TypeDescription subclassType = super.buildType(current);
        assert (subclassType != null) : "subclassType is null!";
        ObjectTypeDescription subclass = subclassType.asObject();
        group.addTo(subclass);
        return subclass;
    }

    @Nullable
    private String findEnumName(@NotNull DefaultElement parentElement) {
        if (parentElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Restriction.findEnumName must not be null");
        }
        String name = parentElement.getAttribute("name");
        if (name == null) {
            for (DefaultElement parent = parentElement.getParent(); name == null && parent != null; parent = parent.getParent()) {
                name = parent.getAttribute("name");
                if (name == null || parent.getElementType() != 11) continue;
                name = name + "Enum";
            }
        }
        return name;
    }

    private int findTotalDigits() {
        String totalDigit = null;
        TotalDigits totalDigits = this.findChildByClass(TotalDigits.class);
        if (totalDigits != null) {
            totalDigit = totalDigits.getValue();
        }
        return totalDigit == null ? 0 : Integer.valueOf(totalDigit);
    }

    private int findMaxLength() {
        String maxLength = null;
        DefaultElement element = this.findChildByName("maxLength");
        if (element != null) {
            maxLength = element.getAttribute("value");
        }
        return maxLength == null ? 0 : Integer.valueOf(maxLength);
    }

    private int findFractionDigits() {
        String fracDigit = null;
        FractionDigits fractionDigits = this.findChildByClass(FractionDigits.class);
        if (fractionDigits != null) {
            fracDigit = fractionDigits.getValue();
        }
        return fracDigit == null ? 0 : Integer.valueOf(fracDigit);
    }

    private boolean isEnumeration() {
        SchemaElement element = this.getFirst();
        if (element instanceof SimpleType) {
            element = element.getNext();
        }
        boolean isEnum = element instanceof Enumeration;
        while (element != null) {
            isEnum = isEnum && element instanceof Enumeration;
            element = element.getNext();
        }
        return isEnum;
    }

    private TypeDescription buildArrayType(String arrayTypeText) throws TypeBuildException {
        TypeDescription result;
        int index = arrayTypeText.lastIndexOf(91);
        if (index != -1) {
            arrayTypeText = arrayTypeText.substring(0, index);
            ArrayTypeDescription arrayType = TypeFactory.createArray((TypeRef)this.buildArrayType(arrayTypeText));
            result = arrayType;
        } else {
            result = this.findType(arrayTypeText);
        }
        return result;
    }

    private String findArrayType() {
        Attribute attr;
        String arrayType = null;
        for (SchemaElement element = this.getFirst(); !(element == null || element instanceof Attribute && (arrayType = (attr = (Attribute)element).getArrayType()) != null); element = element.getNext()) {
        }
        return arrayType;
    }
}

