/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ComplexContent;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

class Extension
extends ComponentDef {
    Extension() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        TypeDescription result;
        String base = this.getBase();
        ObjectTypeDescription baseTypeRef = XmlTypeHelper.XMLOBJECT;
        if (base != null) {
            try {
                baseTypeRef = this.findType(base);
            }
            catch (TypeNotFoundException e) {
                String uri = this.getContext().findNamespace(this.prefix(base)).getUri();
                XmlUUID xmlId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)uri, (String)this.localName(base));
                baseTypeRef = new BpmObjectDynamicRef(xmlId.getId(), this.localName(base), this.getSchemaParser().getCatalog());
            }
        }
        assert (baseTypeRef != null);
        AttrGroupTypeDescription group = this.buildAttributes(current, true);
        if (this.isObject((TypeRef)baseTypeRef)) {
            ObjectTypeDescription subclass = super.buildType(current).asObject();
            subclass.addSuperType(new SuperType((TypeRef)baseTypeRef, 32768L));
            group.addTo(subclass);
            result = subclass;
        } else {
            TypeDescription baseType = baseTypeRef.get();
            if (group.hasAttributes()) {
                ObjectTypeDescription subclass = super.buildType(current).asObject();
                group.addTo(subclass);
                String content_attr_name = "inner_content";
                AttributeTypeDescription attribute = subclass.findAttribute(content_attr_name);
                if (attribute != null) {
                    content_attr_name = "$" + content_attr_name;
                }
                String signature = 'C' + content_attr_name;
                Object attRef = baseType.isUnknown() || !baseType.isXmlObject() ? baseTypeRef : new BpmObjectDynamicRef(baseType.asObject(), ((SchemaParser)this.getXMLParser()).getCatalog());
                AttributeTypeDescription value = new AttributeTypeDescription(content_attr_name, (TypeRef)attRef);
                value.setModifiers(12L);
                value.setReadSignature(signature + ";" + Extension.buildSignature(baseType));
                value.setWriteSignature(signature + ";" + Extension.buildSignature(baseType));
                subclass.addMember((MethodTypeDescription)value);
                result = subclass;
            } else {
                result = baseType;
            }
        }
        return result;
    }

    String getBase() {
        return this.getAttribute("base");
    }

    private boolean isObject(TypeRef baseTypeRef) {
        TypeDescription type = baseTypeRef.get();
        return !type.isUnknown() && type.isObject() || type.isUnknown() && this.getParent() instanceof ComplexContent;
    }
}

