/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Attribute;
import oracle.bpm.project.catalog.parser.xsd.AttributeGroup;
import oracle.bpm.project.catalog.parser.xsd.Group;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.catalog.parser.xsd.SOAPNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.AttrGroupNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.AttributeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.ComplexTypeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.ElementNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.GroupNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.type.TypeToXsdMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedNamespace
extends Namespace {
    protected Map<String, TypeDescription> anonymous;
    protected Map<String, SchemaElement> attrGroups;
    protected Map<String, SchemaElement> attributes;
    protected Map<String, SchemaElement> elements = new HashMap<String, SchemaElement>();
    protected Map<String, SchemaElement> groups;
    protected Map<TypeDescription, String> names;
    protected Map<String, SchemaElement> types;
    private ExtendedNamespace defaultNS;

    ExtendedNamespace(String uri) {
        super(uri);
        this.attrGroups = new HashMap<String, SchemaElement>();
        this.attributes = new HashMap<String, SchemaElement>();
        this.names = TypeToXsdMapping.createEmptyTypeMap();
        this.types = new HashMap<String, SchemaElement>();
        this.groups = new HashMap<String, SchemaElement>();
        this.anonymous = new HashMap<String, TypeDescription>();
    }

    public static boolean isBuiltin(String namespaceUri) {
        return namespaceUri != null && (SFSNamespace.isSFS(namespaceUri) || SOAPNamespace.isSOAPSchema(namespaceUri) || SOAPNamespace.isSOAPWsdlSchema(namespaceUri));
    }

    public boolean hasTypesOrElements() {
        return !this.types.isEmpty() || !this.elements.isEmpty() || !this.anonymous.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<String, TypeDescription> getAllDefinedTypesByName() {
        Map<String, TypeDescription> definedTypes = this.getDefinedTypesByName();
        definedTypes.putAll(this.getAnonymousTypesByName());
        Map<String, TypeDescription> map = definedTypes;
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAllDefinedTypesByName must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<TypeDescription> getAllDefinedTypes() {
        ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
        result.addAll(this.getDefinedTypes());
        result.addAll(this.getAnonymousTypes());
        ArrayList<TypeDescription> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAllDefinedTypes must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<TypeDescription> getAllDefinedAttributes() {
        ArrayList<TypeDescription> arrayList;
        try {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            for (String name : this.attributes.keySet()) {
                TypeDescription type = this.lookupAttribute(name).buildType(null);
                assert (type != null);
                AttributeTypeDescription att = type.asAttribute();
                XmlTypeDescription xmlTypeDescription = XmlTypeDescription.createPointerToAttribute((AttributeTypeDescription)att);
                result.add((TypeDescription)xmlTypeDescription);
            }
            arrayList = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAllDefinedAttributes must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<TypeDescription> getAllDefinedAttributeGroups() {
        ArrayList<TypeDescription> arrayList;
        try {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            for (String name : this.attrGroups.keySet()) {
                String namespace;
                TypeDescription td = this.lookupAttributeGroup(name).buildType(null);
                assert (td != null);
                if (td instanceof AttrGroupTypeDescription) {
                    namespace = ((AttrGroupTypeDescription)td).getNamespace();
                } else {
                    assert (td.isUnknown()) : "Unexpected type";
                    namespace = td.asObject().getProperty("namespace");
                }
                XmlTypeDescription toAttGroup = XmlTypeDescription.createPointerToAttGroup((TypeDescription)td, (String)namespace, (String)td.getName());
                result.add((TypeDescription)toAttGroup);
            }
            arrayList = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (AttrGroupNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAllDefinedAttributeGroups must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<TypeDescription> getAllDefinedGroups() {
        ArrayList<TypeDescription> arrayList;
        try {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            for (String name : this.groups.keySet()) {
                AttrGroupTypeDescription att = (AttrGroupTypeDescription)this.lookupGroup(name).buildType(null);
                assert (att != null);
                XmlTypeDescription group = XmlTypeDescription.createPointerToGroup((TypeDescription)att, (String)att.getNamespace(), (String)att.getName());
                result.add((TypeDescription)group);
            }
            arrayList = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (GroupNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAllDefinedGroups must not return null");
        }
        return arrayList;
    }

    public boolean isAnonymousType(TypeDescription type) {
        return this.anonymous.containsValue(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Map<String, TypeDescription> getDefinedTypesByName() {
        HashMap<String, TypeDescription> hashMap;
        try {
            HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
            for (String name : this.types.keySet()) {
                TypeDescription type = this.lookupType(name).buildType(null);
                result.put(name, type);
            }
            hashMap = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (ComplexTypeNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getDefinedTypesByName must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<TypeDescription> getDefinedElements() {
        ArrayList<TypeDescription> arrayList;
        try {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            for (String name : this.elements.keySet()) {
                TypeDescription type = this.lookupElement(name).buildType(null);
                if (type == null) continue;
                result.add(type);
            }
            arrayList = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (ElementNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getDefinedElements must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Map<String, TypeDescription> getDefinedElementsByName() {
        HashMap<String, TypeDescription> hashMap;
        try {
            HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
            for (String name : this.elements.keySet()) {
                TypeDescription type = this.lookupElement(name).buildType(null);
                result.put(name, type);
            }
            hashMap = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (ElementNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getDefinedElementsByName must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Attribute lookupAttribute(@NotNull String name) throws AttributeNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupAttribute must not be null");
        }
        Attribute attr = (Attribute)this.attributes.get(name);
        if (attr == null) {
            if (this.defaultNS == null) {
                throw new AttributeNotFoundException(name, this);
            }
            attr = this.defaultNS.lookupAttribute(name);
        }
        Attribute attribute = attr;
        if (attribute == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupAttribute must not return null");
        }
        return attribute;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AttributeGroup lookupAttributeGroup(@NotNull String name) throws AttrGroupNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupAttributeGroup must not be null");
        }
        AttributeGroup group = (AttributeGroup)this.attrGroups.get(name);
        if (group == null) {
            if (this.defaultNS == null) {
                throw new AttrGroupNotFoundException(name, this);
            }
            group = this.defaultNS.lookupAttributeGroup(name);
        }
        AttributeGroup attributeGroup = group;
        if (attributeGroup == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupAttributeGroup must not return null");
        }
        return attributeGroup;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Group lookupGroup(@NotNull String name) throws GroupNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupGroup must not be null");
        }
        Group group = (Group)this.groups.get(name);
        if (group == null) {
            if (this.defaultNS == null) {
                throw new GroupNotFoundException(name, this);
            }
            group = this.defaultNS.lookupGroup(name);
        }
        Group group2 = group;
        if (group2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupGroup must not return null");
        }
        return group2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SchemaElement lookupType(@NotNull String name) throws ComplexTypeNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupType must not be null");
        }
        SchemaElement type = this.types.get(name);
        if (type == null) {
            if (this.defaultNS == null) {
                throw new ComplexTypeNotFoundException(name, this);
            }
            type = this.defaultNS.lookupType(name);
        }
        SchemaElement schemaElement = type;
        if (schemaElement == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupType must not return null");
        }
        return schemaElement;
    }

    public String lookupTypeName(TypeDescription type) {
        return this.names.get(type);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SchemaElement lookupElement(String name) throws ElementNotFoundException {
        SchemaElement element = this.elements.get(name);
        if (element == null) {
            if (this.defaultNS == null) {
                throw new ElementNotFoundException(name, this);
            }
            element = this.defaultNS.lookupElement(name);
        }
        SchemaElement schemaElement = element;
        if (schemaElement == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.lookupElement must not return null");
        }
        return schemaElement;
    }

    void setDefault(ExtendedNamespace ns) {
        this.defaultNS = ns;
    }

    void declareAnonymous(@NotNull TypeDescription type) throws InvalidLocalNameException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareAnonymous must not be null");
        }
        this.anonymous.put(type.getId(), type);
    }

    void declareAttribute(@NotNull String name, @NotNull SchemaElement element) throws InvalidLocalNameException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareAttribute must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareAttribute must not be null");
        }
        this.ensureLocalName(name);
        this.attributes.put(name, element);
    }

    void declareAttributeGroup(@NotNull String name, @NotNull SchemaElement element) throws InvalidLocalNameException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareAttributeGroup must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareAttributeGroup must not be null");
        }
        this.ensureLocalName(name);
        this.attrGroups.put(name, element);
    }

    void declareElement(@NotNull String name, @NotNull SchemaElement element) throws InvalidLocalNameException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareElement must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.declareElement must not be null");
        }
        this.ensureLocalName(name);
        this.elements.put(name, element);
    }

    void declareGroup(String name, SchemaElement element) throws InvalidLocalNameException {
        this.ensureLocalName(name);
        this.groups.put(name, element);
    }

    void declareType(String name, SchemaElement element) throws InvalidLocalNameException {
        this.ensureLocalName(name);
        this.types.put(name, element);
        TypeDescription type = element.getTypeIfCreated();
        if (type != null) {
            this.names.put(type, type.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<TypeDescription> getDefinedTypes() {
        ArrayList<TypeDescription> arrayList;
        try {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            for (String name : this.types.keySet()) {
                TypeDescription type = this.lookupType(name).buildType(null);
                if (type == null) continue;
                result.add(type);
            }
            arrayList = result;
        }
        catch (TypeBuildException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        catch (ComplexTypeNotFoundException e) {
            throw new IllegalStateException("Context is not consistent", e);
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getDefinedTypes must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Collection<TypeDescription> getAnonymousTypes() {
        Collection<TypeDescription> collection = this.anonymous.values();
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ExtendedNamespace.getAnonymousTypes must not return null");
        }
        return collection;
    }

    private Map<String, TypeDescription> getAnonymousTypesByName() {
        HashMap<String, TypeDescription> definedTypes = new HashMap<String, TypeDescription>();
        for (TypeDescription typeDescription : this.anonymous.values()) {
            ObjectTypeDescription otd = typeDescription.asObject();
            String name = otd.getNativeName();
            if (name == null) {
                name = otd.getName();
            }
            definedTypes.put(name, typeDescription);
        }
        return definedTypes;
    }

    private void ensureLocalName(@Nullable String name) throws InvalidLocalNameException {
        if (name == null || name.indexOf(58) != -1) {
            throw new InvalidLocalNameException(name);
        }
    }
}

