/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.ElementRootDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.ComplexTypeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import org.jetbrains.annotations.Nullable;

class ComponentDef
extends SchemaElement {
    ComponentDef() {
    }

    ComponentDef(SchemaElement element) {
        super(element);
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        String name = this.getName();
        boolean anonymous = false;
        if (name == null && current != null && current.isAttribute()) {
            String signature;
            AttributeTypeDescription attr = current.asAttribute();
            int index = (signature = attr.getReadSignature()).lastIndexOf(59);
            name = signature.substring(1, index != -1 ? index : signature.length());
            anonymous = true;
        } else if (name == null && current != null && (current.isObject() || current.isEnum())) {
            if (current.isObject()) {
                name = current.asObject().getNativeName();
            }
            if (name == null) {
                name = current.getName();
            }
        }
        if (!Utils.isValidNCName(name)) {
            throw new InvalidNameException(name, (SchemaElement)this);
        }
        ExtendedNamespace target = this.getTarget();
        String namespace = null;
        if (target != null) {
            namespace = target.getUri();
        } else {
            this.getContext().setTarget("");
        }
        boolean hasNamespace = namespace != null;
        boolean elementsAreQualified = hasNamespace && this.getSchema().isElementQualified();
        boolean attributesAreQualified = hasNamespace && this.getSchema().isAttributeQualified();
        namespace = hasNamespace ? namespace : "";
        XmlElementType xmlElementType = anonymous || this instanceof ElementRootDef ? XmlElementType.ELEMENT : XmlElementType.TYPE;
        String parentFullName = this.getContext().buildParentFullName();
        XmlTypeDescription object = XmlTypeHelper.createXmlTypeDescription(name, namespace, null, elementsAreQualified, attributesAreQualified, xmlElementType, parentFullName);
        if (anonymous) {
            try {
                this.getTarget().declareAnonymous((TypeDescription)object);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
        this.addAnnotations((TypeDescription)object);
        return object;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareType(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
            catch (UnsupportedOperationException e) {
                throw TypeNotFoundException.wrap(new ComplexTypeNotFoundException(name, this.getTarget()), (DefaultElement)this);
            }
        }
    }

    boolean isAbstract() {
        return "true".equals(this.getAttribute("abstract"));
    }

    String getName() {
        return this.getAttribute("name");
    }
}

