/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.parser.xsd.Content;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SimpleContent;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class ComplexType
extends ComponentDef {
    public ComplexType() {
    }

    public ComplexType(Schema context, String name) {
        super(context);
        this.setTagName("complexType");
        this.setName(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Argument> buildBpmObjectArguments() throws TypeBuildException {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        SchemaElement sequence = this.getFirst();
        for (SchemaElement schemaElement = sequence.getFirst(); schemaElement != null; schemaElement = schemaElement.getNext()) {
            Argument argument = ((ElementDef)schemaElement).buildBpmObjectArgument();
            arguments.add(argument);
        }
        ArrayList<Argument> arrayList = arguments;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ComplexType.buildBpmObjectArguments must not return null");
        }
        return arrayList;
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        TypeDescription object;
        TypeDescription typeDescription;
        block15: {
            AttrGroupTypeDescription attributes;
            block16: {
                if (this.type != null) {
                    typeDescription = this.type;
                    if (typeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ComplexType.buildType must not return null");
                    return typeDescription;
                }
                object = super.buildType(current);
                SchemaElement first = this.getFirst();
                this.type = object;
                if (!(first instanceof Content)) break block16;
                if (!(object = first.buildType(object)).isObject() || object.isHidden()) {
                    if (first instanceof SimpleContent) {
                        object = XmlTypeDescription.createPointerToType((String)this.getHiddenName(this.getName()), (String)this.type.asSchemaObject().getNamespace(), (TypeRef)object);
                        break block15;
                    } else {
                        this.type = object;
                    }
                    break block15;
                } else {
                    ObjectTypeDescription source = object.asObject();
                    ObjectTypeDescription target = this.type.asObject();
                    for (SuperType superType : source.getSuperTypes()) {
                        if (XmlTypeHelper.XMLOBJECT.equals((Object)superType.getType())) continue;
                        target.addSuperType(superType);
                    }
                    int count = source.getMemberCount();
                    for (int i = 0; i < count; ++i) {
                        MethodTypeDescription memberType = source.getMemberType(i);
                        if (!memberType.isAttribute() || target.getMemberIndex(memberType.getName()) != -1) continue;
                        AttributeTypeDescription attr = new AttributeTypeDescription(memberType.getName(), memberType.getResultTypeRef());
                        attr.setModifiers(memberType.getModifiers());
                        attr.setReadSignature(memberType.getSignature());
                        attr.setWriteSignature(memberType.asAttribute().getWriteSignature());
                        attr.setProperties(memberType.getProperties());
                        target.addMember((MethodTypeDescription)attr);
                    }
                    object = target;
                }
                break block15;
            }
            if (current != null && current.isAttribute()) {
                current.asAttribute().setType((TypeRef)object);
            }
            if ((attributes = this.buildAttributes(object, true)) != null) {
                if (this.isMixed()) {
                    // empty if block
                }
                attributes.addTo(object.asObject());
            }
        }
        if (object instanceof ObjectTypeDescription && this.isAbstract()) {
            ((ObjectTypeDescription)object).addModifier(512L);
        }
        this.type = object;
        typeDescription = object;
        if (typeDescription != null) return typeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ComplexType.buildType must not return null");
    }

    @Override
    boolean isAbstract() {
        return Boolean.parseBoolean(this.getAttribute("abstract"));
    }

    boolean isMixed() {
        return Boolean.parseBoolean(this.getAttribute("mixed"));
    }

    private String getHiddenName(String name) {
        if (name == null) {
            for (DefaultElement parent = this.getParent(); name == null && parent != null; parent = parent.getParent()) {
                name = parent.getAttribute("name");
                if (name == null || parent.getElementType() != 11) continue;
                name = name + "Anon";
            }
        }
        assert (name != null) : "Unable to get name from type";
        return name;
    }
}

