/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.Annotation;
import oracle.bpm.project.catalog.parser.xsd.Documentation;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.MissingNameOrReferenceException;
import oracle.bpm.project.catalog.parser.xsd.exception.MissingNamespaceException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public abstract class AttributeDef
extends SchemaElement {
    protected AttributeDef() {
    }

    protected AttributeDef(SchemaElement element) {
        super(element);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getBpmElementName() {
        return this.getAttribute(new QName("http://xmlns.oracle.com/bpm/bpmobject/", "name"));
    }

    protected static TypeRef createLazyRef(ComponentCatalog catalog, TypeRef typeRef) {
        TypeRef argType;
        if (typeRef instanceof DynamicRef) {
            argType = typeRef;
        } else {
            TypeDescription td = typeRef.get();
            if ((td.isObject() || td.isEnum()) && !td.isPrimitive()) {
                SchemaObject schema = td.asSchemaObject();
                String uniqueId = UUIDFactory.createXmlId((XmlElementType)schema.getXmlElementType(), (String)schema.getNamespace(), (String)schema.getName()).getId();
                argType = new BpmObjectDynamicRef(uniqueId, td.getName(), catalog);
            } else {
                argType = td.getRef();
            }
        }
        return argType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        assert (this.getRef() == null) : "Reference must be processed in subclass";
        String type = this.getType();
        String name = this.getName();
        if (name == null) {
            throw new MissingNameOrReferenceException(this);
        }
        AttributeTypeDescription attr = new AttributeTypeDescription(Identifier.attribute(name, true), (TypeRef)TypeFactory.getAny());
        attr.setReadSignature('A' + name);
        attr.setWriteSignature('A' + name);
        String currentNamespace = null;
        if (current != null && current.isObject()) {
            currentNamespace = current.asObject().getProperty("namespace");
        }
        if (type != null) {
            String prefix = XmlUtils.prefix((String)type);
            String typeName = XmlUtils.localname((String)type);
            Namespace ns = this.getContext().findNamespace(prefix);
            if (ns == null) {
                throw new MissingNamespaceException(prefix, (SchemaElement)this);
            }
            String schemaNamespace = ns.getUri();
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            TypeRef typeRef = null;
            if (Utils.isHolderType(schemaNamespace, typeName)) {
                ObjectTypeDescription holderOtd;
                List attributes;
                TypeDescription holderType = this.findType(type);
                if (holderType != null && (attributes = (holderOtd = holderType.asObject()).getAttributes()).size() == 1) {
                    AttributeTypeDescription att = ((MethodTypeDescription)attributes.get(0)).asAttribute();
                    typeRef = AttributeDef.createLazyRef(catalog, att.getTypeRef());
                }
                if (typeRef == null) {
                    typeRef = UnknownType.create((String)"missingType", (ComponentCatalog)catalog, (String)("Unable to load element for holder: '" + typeName + '\''));
                }
            } else {
                typeRef = this.lookupTypeRef(type, catalog);
            }
            attr.setType(typeRef);
        }
        this.type = attr;
        TypeDescription redefType = this.buildSubElements((TypeDescription)attr);
        if (redefType != null && !redefType.isAttribute()) {
            if (redefType.isEnum()) {
                try {
                    ObjectTypeDescription parentType;
                    if (this.getElementType() != 11 && (parentType = this.getContext().getParentType()) != null) {
                        parentType.addInnerType((TypeRef)redefType);
                    }
                    redefType.asObject().addModifier(0x2000000L);
                    this.getTarget().declareAnonymous(redefType);
                }
                catch (InvalidLocalNameException e) {
                    throw TypeNotFoundException.wrap(e, (DefaultElement)this);
                }
            }
            attr.setType((TypeRef)redefType);
        }
        if (currentNamespace != null && Utils.isBpmObjectNamespace(currentNamespace)) {
            List<Annotation> annotations = this.findChildrenByClass(Annotation.class);
            for (Annotation annotation : annotations) {
                List<Documentation> documentations = annotation.findChildrenByClass(Documentation.class);
                for (Documentation documentation : documentations) {
                    documentation.buildBpmoDocumentation((TypeDescription)attr);
                }
            }
        }
        this.addAnnotations((TypeDescription)attr);
        AttributeTypeDescription attributeTypeDescription = attr;
        if (attributeTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/AttributeDef.buildType must not return null");
        }
        return attributeTypeDescription;
    }

    String getRef() {
        return this.getAttribute("ref");
    }

    String getSubstitutionGroup() {
        return this.getAttribute("substitutionGroup");
    }

    String getType() {
        return this.getAttribute("type");
    }

    String getForm() {
        return this.getAttribute("form");
    }
}

