/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.XMLSignatureParser;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.AttributeDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.AttributeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.NamespaceNotDeclaredException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class Attribute
extends AttributeDef {
    public Attribute() {
    }

    public Attribute(AttributeTypeDescription type) {
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        boolean isQualified;
        AttributeTypeDescription attr;
        TypeDescription typeDescription;
        if (this.type != null) {
            typeDescription = this.type;
            if (typeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Attribute.buildType must not return null");
            return typeDescription;
        }
        String ref = this.getRef();
        ExtendedNamespace currentNamespace = this.getContext().getTarget();
        String elementNamespace = currentNamespace.getUri();
        if (ref != null) {
            TypeRef attRef;
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            try {
                attRef = this.getContext().lookupAttributeRef(ref, catalog);
            }
            catch (NamespaceNotDeclaredException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
            String name = this.localName(ref);
            attr = Attribute.buildAttributeTD(name, attRef);
            Namespace elemNs = this.getContext().findNamespace(this.prefix(ref));
            if (elementNamespace != null) {
                elementNamespace = elemNs.getUri();
            }
            attr.setReadSignature('A' + name + ";?");
            attr.setWriteSignature('A' + name + ";?");
            isQualified = true;
        } else {
            String defaultValue;
            String typeSig;
            isQualified = this.getSchema().isAttributeQualified();
            attr = super.buildType(current).asAttribute();
            if (!(attr.getTypeRef() instanceof DynamicRef)) {
                if (attr.getType().isAny()) {
                    attr.setType((TypeRef)TypeFactory.getString());
                }
                typeSig = Attribute.buildSignature(attr.getType());
            } else {
                typeSig = 'X' + attr.getName();
            }
            attr.setReadSignature(attr.getReadSignature() + ';' + typeSig);
            attr.setWriteSignature(attr.getWriteSignature() + ';' + typeSig);
            String fixed = this.getFixed();
            if (fixed != null) {
                attr.setProperty("fixedValue", fixed);
            }
            if ((defaultValue = this.getDefault()) != null) {
                attr.setProperty("defaultValue", defaultValue);
            }
            attr.setProperty(Literals.IS_XSD_ATTRIBUTE, String.valueOf(true));
            attr.setProperty("nativeName", this.getName());
            this.type = attr;
            String form = this.getForm();
            if (form != null) {
                isQualified = "qualified".equals(form);
                attr.setProperty(Literals.FORM_QUALIFIED, String.valueOf(isQualified));
            }
        }
        attr.setProperty("namespace", elementNamespace);
        if (!isQualified) {
            elementNamespace = "";
        }
        attr.setProperty(Literals.ELEMENT_NAMESPACE, elementNamespace);
        attr.setProperty("qualified", String.valueOf(isQualified));
        String signature = attr.getReadSignature();
        signature = XMLSignatureParser.replaceAttributeElementNamespace((String)signature, (String)elementNamespace);
        attr.setReadSignature(signature);
        attr.setWriteSignature(signature);
        typeDescription = attr;
        if (typeDescription != null) return typeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Attribute.buildType must not return null");
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareAttribute(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
            catch (UnsupportedOperationException e) {
                throw TypeNotFoundException.wrap(new AttributeNotFoundException(name, this.getTarget()), (DefaultElement)this);
            }
        }
    }

    String getArrayType() {
        String nspace = "http://schemas.xmlsoap.org/wsdl/";
        String attrName = "arrayType";
        QName qname = new QName(nspace, attrName);
        String value = this.getAttribute(qname);
        if (value == null) {
            Map<QName, String> attributes = this.getAttributes();
            Set<Map.Entry<QName, String>> entries = attributes.entrySet();
            for (Map.Entry<QName, String> pair : entries) {
                Namespace ns;
                String name = pair.getKey().getLocalPart();
                if (!name.endsWith(':' + attrName) && !name.equals(attrName)) continue;
                int index = name.lastIndexOf(58);
                String prefix = "";
                if (index != -1) {
                    prefix = name.substring(0, index);
                }
                if ((ns = this.getContext().findNamespace(prefix)) == null || !ns.getUri().equals(nspace)) continue;
                value = pair.getValue();
                break;
            }
        }
        return value;
    }

    String getFixed() {
        return this.getAttribute("fixed");
    }

    String getDefault() {
        return this.getAttribute("default");
    }

    private static AttributeTypeDescription buildAttributeTD(String name, TypeRef attRef) {
        return new AttributeTypeDescription(name, attRef){

            public String getSignature() {
                String signature = super.getSignature();
                TypeDescription type = this.getResultType();
                if (type.isUnknown()) {
                    return signature;
                }
                String typeSig = SchemaElement.buildSignature(type.isAny() ? TypeFactory.getString() : type);
                return XMLSignatureParser.replaceAttributeType((String)signature, (String)typeSig);
            }
        };
    }
}

