/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultFactory;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.MessageListener;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    private StringBuffer buffer;
    private boolean buildingContext;
    private int closedPrefix = 0;
    private Stack<NamespaceContext> contexts;
    private int current;
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private ElementFactory factory;
    private StringList infos;
    private int length;
    private MessageListener listener;
    private URL location;
    private Locator locator;
    private Element root;
    private SAXParser saxParser;
    private Element[] stack;
    private List<SAXException> warnings = new ArrayList<SAXException>();

    public Parser() {
        this.infos = StringList.create();
        this.contexts = new Stack();
        this.factory = new DefaultFactory();
    }

    public NamespaceContext getRootNamespaceContext() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public ElementFactory getElementFactory() {
        return this.factory;
    }

    public SAXException[] getErrors() {
        return this.errors.toArray(new SAXException[this.errors.size()]);
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public URL getSourceLocation() {
        return this.location;
    }

    public SAXException[] getWarnings() {
        return this.warnings.toArray(new SAXException[this.warnings.size()]);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        boolean isWhiteSpace;
        block8: {
            isWhiteSpace = true;
            if (this.buffer == null) {
                block3: for (int i = 0; i < len; ++i) {
                    switch (buf[offset + i]) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block3;
                        }
                        default: {
                            isWhiteSpace = false;
                            break block8;
                        }
                    }
                }
            } else {
                isWhiteSpace = false;
            }
        }
        if (!isWhiteSpace) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(len);
            }
            this.buffer.append(buf, offset, len);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespace, String name, String qualifiedName) throws SAXException {
        this.dispatchPendingTextData();
        try {
            --this.current;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        ++this.closedPrefix;
        NamespaceContext current = null;
        if (!this.contexts.isEmpty()) {
            current = this.contexts.peek();
        }
        if (current != null && this.closedPrefix == current.getDeclaredPrefixCount()) {
            NamespaceContext ctx = this.popContext();
            this.closedPrefix = 0;
            if (this.factory != null) {
                this.factory.setContext(ctx.getParent());
            }
        }
    }

    @Override
    public void error(SAXParseException error) throws SAXException {
        this.errors.add(error);
        if (this.listener != null) {
            this.listener.error(error.getLineNumber(), error.getColumnNumber(), error.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException error) throws SAXException {
        this.errors.add(error);
        if (this.listener != null) {
            this.listener.error(error.getLineNumber(), error.getColumnNumber(), error.getMessage());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void info(String message) {
        this.infos.add(message);
        if (this.listener != null) {
            this.listener.info(message);
        }
    }

    public synchronized Element parse(URL location) throws TypeParseException {
        Element element;
        InputStream in = null;
        try {
            in = location.openStream();
            PushbackInputStream pb = new PushbackInputStream(in, 32);
            InputSource source = new InputSource(pb);
            byte[] buffer = new byte[3];
            int count = pb.read(buffer);
            if (count >= 3 && buffer[0] == -17 && buffer[1] == -69 && buffer[2] == -65) {
                source.setEncoding("UTF-8");
            } else {
                pb.unread(buffer, 0, count);
            }
            element = this.parse(location, source);
        }
        catch (IOException e) {
            try {
                throw new TypeParseException(location, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return element;
    }

    public synchronized Element parse(URL location, InputStream input) throws TypeParseException {
        return this.parse(location, new InputSource(input));
    }

    public synchronized Element parse(URL location, String input) throws TypeParseException {
        InputSource source = new InputSource(new StringReader(input));
        return this.parse(location, source);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source = null;
        try {
            if (systemId != null) {
                URL url = new URL(this.location, systemId);
                source = new InputSource(url.openStream());
            }
            if (source == null) {
                source = super.resolveEntity(publicId, systemId);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return source;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.resetMessages();
        this.reset();
    }

    @Override
    public void startElement(String namespace, String name, String qualifiedName, Attributes attrs) throws SAXException {
        this.dispatchPendingTextData();
        try {
            Element element;
            this.buildingContext = false;
            if (this.root == null && this.contexts.isEmpty()) {
                NamespaceContext ctx = this.createContext(this.getRootNamespaceContext());
                this.pushContext(ctx);
                if (this.factory != null) {
                    this.factory.setContext(ctx);
                }
            }
            if (name == null && qualifiedName != null) {
                int q = qualifiedName.indexOf(58);
                name = qualifiedName.substring(q + 1);
            }
            HashMap<QName, String> attributes = null;
            if (attrs != null) {
                attributes = new HashMap<QName, String>();
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    String uri = attrs.getURI(i);
                    String localName = attrs.getLocalName(i);
                    String prefix = XmlUtils.prefix((String)attrs.getQName(i));
                    String attrValue = attrs.getValue(i);
                    QName qname = new QName(uri, localName, prefix);
                    attributes.put(qname, attrValue);
                }
            }
            if ((element = this.factory.create(namespace, name, attributes)) == null) {
                throw new SAXException("couldn't create element for " + name);
            }
            Element parent = this.peek();
            if (parent != null) {
                parent.addChild(element);
            } else {
                this.root = element;
            }
            this.push(element);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        NamespaceContext current = !this.contexts.isEmpty() ? this.contexts.peek() : this.getRootNamespaceContext();
        if (!this.buildingContext) {
            current = this.createContext(current);
            this.pushContext(current);
            this.closedPrefix = 0;
            if (this.factory != null) {
                this.factory.setContext(current);
            }
        }
        if (current != null) {
            current.addNamespace(prefix, uri);
        }
        this.buildingContext = true;
    }

    public void warning(String message) {
        try {
            this.warning(new SAXParseException(message, null, null, -1, -1));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void warning(SAXParseException warning) throws SAXException {
        this.warnings.add(warning);
        if (this.listener != null) {
            this.listener.warning(warning.getLineNumber(), warning.getColumnNumber(), warning.getMessage());
        }
    }

    protected NamespaceContext createContext(NamespaceContext parent) {
        return new NamespaceContext(parent);
    }

    protected NamespaceContext popContext() {
        return this.contexts.pop();
    }

    protected void pushContext(NamespaceContext ctx) {
        this.contexts.push(ctx);
    }

    protected void reset() {
        this.length = 1024;
        this.stack = new Element[this.length];
        this.current = 0;
        this.root = null;
        this.buildingContext = false;
        if (this.factory != null) {
            this.factory.setParser(this);
        }
        this.buffer = null;
        this.contexts.clear();
    }

    protected void resetMessages() {
        this.errors.clear();
        this.warnings.clear();
        this.infos.clear();
    }

    protected Element pop() {
        return this.stack[--this.current];
    }

    protected void push(Element element) {
        if (this.length == this.current) {
            Element[] expanded = new Element[this.length + 128];
            System.arraycopy(this.stack, 0, expanded, 0, this.length);
            this.stack = expanded;
        }
        this.stack[this.current++] = element;
    }

    protected Element peek() {
        int top = this.current - 1;
        return top >= 0 && top < this.length ? this.stack[top] : null;
    }

    private void dispatchPendingTextData() throws SAXException {
        if (this.buffer != null) {
            String data = this.buffer.toString();
            this.buffer = null;
            Element element = this.factory.createText(data);
            if (element == null) {
                throw new SAXException("couldn't create element for character data ");
            }
            Element parent = this.peek();
            if (parent != null) {
                parent.addChild(element);
            }
        }
    }

    private Element parse(URL location, InputSource source) throws TypeParseException {
        try {
            this.location = location;
            if (this.saxParser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                this.saxParser = factory.newSAXParser();
            }
            this.saxParser.parse(source, (DefaultHandler)this);
            return this.root;
        }
        catch (IOException e) {
            throw new TypeParseException(location, e);
        }
        catch (SAXException e) {
            throw new TypeParseException(location, e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }
}

