/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;

public class NamespaceContext
implements Serializable {
    private Map<String, Namespace> namespacesByURI;
    private NamespaceContext parent;
    private Map<String, String> prefixToUri;
    private Map<String, Set<String>> uriToPrefix;
    public static final long serialVersionUID = -3290764779210539755L;
    static final long serialCheck = -8093781321275640031L;

    public NamespaceContext() {
        this(null);
    }

    public NamespaceContext(NamespaceContext parent) {
        this.parent = parent;
        this.uriToPrefix = new HashMap<String, Set<String>>();
        this.prefixToUri = new HashMap<String, String>();
        if (parent == null) {
            this.namespacesByURI = new HashMap<String, Namespace>();
        }
    }

    public int getDeclaredPrefixCount() {
        return this.prefixToUri.size();
    }

    public Map<String, Collection<String>> getPrefixesByUri() {
        Map<String, Set<String>> prefix = this.uriToPrefix;
        return Collections.unmodifiableMap(prefix);
    }

    public NamespaceContext getParent() {
        return this.parent;
    }

    public void setParent(NamespaceContext parent) {
        this.parent = parent;
        this.namespacesByURI = null;
    }

    public void addNamespace(String prefix, String uri) {
        Namespace ns = this.findNamespaceByUri(uri);
        if (ns == null) {
            ns = new Namespace(uri);
        }
        this.addNamespace(prefix, ns);
    }

    public void updateNamespace(Namespace ns) {
        String uri = ns.getUri();
        ExtendedNamespace old = (ExtendedNamespace)this.findNamespaceByUri(uri);
        Map<String, Namespace> declaredNamespaces = this.getDeclaredNamespaces();
        if (old == null || !old.hasTypesOrElements()) {
            declaredNamespaces.put(uri, ns);
        }
    }

    public void addNamespace(String prefix, Namespace ns) {
        String uri = ns.getUri();
        Namespace old = this.findNamespaceByUri(uri);
        assert (old == null || old == ns) : "There are two instances of namespace for the same uri: " + uri;
        this.addPrefixToUri(uri, prefix);
        Map<String, Namespace> declaredNamespaces = this.getDeclaredNamespaces();
        declaredNamespaces.put(uri, ns);
    }

    public Namespace findNamespace(String prefix) {
        Map<String, Namespace> declaredNamespaces;
        Namespace nspace;
        String uri = this.getPrefixToUri(prefix);
        if (uri == null && "".equals(prefix)) {
            uri = "";
        }
        if ((nspace = (declaredNamespaces = this.getDeclaredNamespaces()).get(uri)) == null && this.parent != null) {
            nspace = this.parent.findNamespace(prefix);
        }
        return nspace;
    }

    public Namespace findNamespaceByUri(String uri) {
        Map<String, Namespace> declaredNamespaces = this.getDeclaredNamespaces();
        return declaredNamespaces.get(uri);
    }

    @Deprecated
    public String findPrefixByUri(String uri) {
        Collection<String> prefixes = this.findPrefixesByUri(uri);
        String prefix = null;
        if (prefixes != null && !prefixes.isEmpty()) {
            String[] bufferString = new String[prefixes.size()];
            String[] availablePrefixes = prefixes.toArray(bufferString);
            for (int idx = availablePrefixes.length - 1; idx >= 0; --idx) {
                String currentPrefix = availablePrefixes[idx];
                if ("".equals(currentPrefix)) continue;
                prefix = currentPrefix;
                break;
            }
        }
        return prefix;
    }

    public Collection<String> findPrefixesByUri(String uri) {
        Collection<String> prefixes = this.getLocalDeclaredPrefixByNamespace(uri);
        if (prefixes == null && this.parent != null) {
            prefixes = this.parent.findPrefixesByUri(uri);
        }
        return prefixes;
    }

    public Map<String, Namespace> getDeclaredNamespaces() {
        return this.getRoot().namespacesByURI;
    }

    public String toString() {
        return "NamespaceContext(" + this.namespacesByURI + ")";
    }

    public Map<String, String> getLocalDeclaredPrefixToUriMap() {
        return Collections.unmodifiableMap(this.prefixToUri);
    }

    public Map<String, Set<String>> getLocalDeclaredUriToPrefixMap() {
        return Collections.unmodifiableMap(this.uriToPrefix);
    }

    public Map<String, String> getAllPrefixToUriMap() {
        Map<String, String> result;
        if (this.getParent() == null) {
            result = this.getLocalDeclaredPrefixToUriMap();
        } else {
            result = new HashMap<String, String>();
            result.putAll(this.getParent().getLocalDeclaredPrefixToUriMap());
            result.putAll(this.getLocalDeclaredPrefixToUriMap());
        }
        return result;
    }

    public boolean isValid() {
        return this.uriToPrefix != null || this.namespacesByURI != null || this.prefixToUri != null;
    }

    private NamespaceContext getRoot() {
        NamespaceContext parent;
        NamespaceContext root = this;
        while ((parent = root.getParent()) != null) {
            root = parent;
        }
        return root;
    }

    private String getPrefixToUri(String prefix) {
        String uri = null;
        Set<String> namespaces = this.getLocalDeclaredNamespaces();
        block0: for (String namespace : namespaces) {
            Collection<String> prefixes = this.getLocalDeclaredPrefixByNamespace(namespace);
            for (String declaredPrefix : prefixes) {
                if (!declaredPrefix.equals(prefix)) continue;
                uri = namespace;
                continue block0;
            }
        }
        return uri;
    }

    private Collection<String> getLocalDeclaredPrefixByNamespace(String namespace) {
        return this.uriToPrefix.get(namespace);
    }

    private Set<String> getLocalDeclaredNamespaces() {
        return this.uriToPrefix.keySet();
    }

    private void addPrefixToUri(String uri, String prefix) {
        Set<String> prefixes = this.uriToPrefix.get(uri);
        if (prefixes == null) {
            prefixes = new HashSet<String>();
            this.uriToPrefix.put(uri, prefixes);
        }
        prefixes.add(prefix);
        this.prefixToUri.put(prefix, uri);
    }
}

