/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xmlparser.Parser;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultElement
implements Element {
    private Map<QName, String> attributes;
    private int column = -1;
    private NamespaceContext context;
    private DefaultElement first;
    private int line = -1;
    private String name;
    private String namespace;
    private DefaultElement next;
    private DefaultElement parent;
    private Parser parser;
    private int type;

    public void setAttribute(String name, String value) {
        QName qname = new QName(name);
        this.setAttribute(qname, value);
    }

    public void setAttribute(QName qname, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<QName, String>();
        }
        this.attributes.put(qname, value);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public String getAttribute(String name) {
        return this.getAttribute(new QName(name));
    }

    public String getAttribute(QName name) {
        String value = null;
        if (this.attributes != null) {
            value = this.attributes.get(name);
        }
        return value;
    }

    public void setAttributes(Map<QName, String> attributes) {
        this.attributes = attributes;
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public void setColumn(int col) {
        this.column = col;
    }

    public int getColumn() {
        return this.column;
    }

    public void setElementType(int type) {
        this.type = type;
    }

    public int getElementType() {
        return this.type;
    }

    public void setFirstElement(DefaultElement element) {
        if (element != null) {
            element.setParent(this);
        }
        this.first = element;
    }

    public DefaultElement getFirstElement() {
        return this.first;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setNSContext(NamespaceContext ctx) {
        this.context = ctx;
    }

    public NamespaceContext getNSContext() {
        DefaultElement parent = this.getParent();
        if (this.context == null) {
            this.context = parent != null ? parent.getNSContext() : new NamespaceContext();
        }
        return this.context;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNextElement(DefaultElement element) {
        this.next = element;
    }

    public DefaultElement getNextElement() {
        return this.next;
    }

    public void setParent(DefaultElement parent) {
        this.parent = parent;
    }

    public DefaultElement getParent() {
        return this.parent;
    }

    public int getPosition() {
        int position = -1;
        if (this.parent != null) {
            DefaultElement current = this.parent.getFirstElement();
            position = 0;
            while (current != null && current != this) {
                current = current.getParent();
                ++position;
            }
        }
        return position;
    }

    public void setTagName(String name) {
        this.name = name;
    }

    public String getTagName() {
        return this.name;
    }

    public void setXMLParser(Parser xmlparser) {
        this.parser = xmlparser;
    }

    public Parser getXMLParser() {
        return this.parser;
    }

    @Override
    public void addChild(Element element) {
        DefaultElement elem = (DefaultElement)element;
        if (this.first == null) {
            this.first = elem;
        } else {
            DefaultElement current = this.first;
            while (current.getNextElement() != null) {
                current = current.getNextElement();
            }
            current.setNextElement(elem);
        }
        elem.setParent(this);
    }

    public void insertFirstChild(Element element) {
        if (this.first == null) {
            this.addChild(element);
        } else {
            DefaultElement oldFirst = this.first;
            this.first = null;
            this.addChild(element);
            this.addChild(oldFirst);
        }
    }

    public void removeChild(Element element) {
        if (this.first != null) {
            if (this.first.equals(element)) {
                this.first = this.first.getNextElement();
            } else {
                DefaultElement previous = this.first;
                for (DefaultElement current = this.first.getNextElement(); current != null; current = current.getNextElement()) {
                    if (current.equals(element)) {
                        previous.setNextElement(current.getNextElement());
                        return;
                    }
                    previous = current;
                }
            }
        }
        if (element instanceof DefaultElement) {
            ((DefaultElement)element).setNextElement(null);
        }
    }

    public void setElement(String tagName, Element element) {
        DefaultElement current;
        DefaultElement defaultElement = (DefaultElement)element;
        defaultElement.setTagName(tagName);
        DefaultElement prev = null;
        for (current = this.first; current != null && !tagName.equals(current.getTagName()); current = current.getNextElement()) {
            prev = current;
        }
        if (current == null) {
            this.addChild(element);
        } else {
            if (prev != null) {
                prev.setNextElement(defaultElement);
            } else {
                this.setFirstElement(defaultElement);
            }
            defaultElement.setNextElement(current.getNextElement());
            defaultElement.setParent(this);
            current.setNextElement(null);
            current.setParent(null);
        }
    }

    public void setAllElements(String tagName, Element[] elements) {
        for (DefaultElement child : this.findChildrenByName(tagName)) {
            this.removeChild(child);
        }
        for (Element element : elements) {
            DefaultElement defaultElement = (DefaultElement)element;
            defaultElement.setTagName(tagName);
            this.addChild(element);
        }
    }

    public void dump(IndentedPrintWriter out, String encoding) {
        this.dump(out, true, null, encoding);
    }

    public void dump(IndentedPrintWriter out, @Nullable String[] processingInstructions, String encoding) {
        this.dump(out, true, processingInstructions, null, encoding);
    }

    public void dump(IndentedPrintWriter out, String encoding, DumpParameters parameters) {
        this.dump(out, true, null, encoding, parameters);
    }

    public <E extends DefaultElement> E findAncestorByClass(Class<E> cl) {
        DefaultElement current;
        for (current = this; current != null && !cl.isAssignableFrom(current.getClass()); current = current.getParent()) {
        }
        return (E)((DefaultElement)cl.cast(current));
    }

    public <E extends DefaultElement> E findByAttributeValue(List<E> elements, String name, String value) {
        DefaultElement element = null;
        if (elements != null) {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                String attrValue = ((DefaultElement)elements.get(i)).getAttribute(name);
                if (attrValue == null || !attrValue.equals(value)) continue;
                element = (DefaultElement)elements.get(i);
                break;
            }
        }
        return (E)element;
    }

    public <E extends DefaultElement> E findChildByClass(Class<E> cl) {
        List<E> elements = this.findChildrenByClass(cl);
        return (E)(!elements.isEmpty() ? (DefaultElement)cl.cast(elements.get(0)) : null);
    }

    public DefaultElement getElement(String name) {
        return this.findChildByName(name);
    }

    public DefaultElement findChildByName(String name) {
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            if (!name.equals(element.getTagName())) continue;
            return element;
        }
        return null;
    }

    public DefaultElement[] findChildrenByName(String name) {
        ArrayList<DefaultElement> result = new ArrayList<DefaultElement>();
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            if (!name.equals(element.getTagName())) continue;
            result.add(element);
        }
        return result.toArray(new DefaultElement[result.size()]);
    }

    public <E extends DefaultElement> List<E> findChildrenByClass(Class<E> cl) {
        E current = DefaultElement.findFirst(this.getFirstElement(), cl);
        if (current == null) {
            return Collections.emptyList();
        }
        ArrayList<E> children = new ArrayList<E>();
        do {
            children.add(current);
        } while ((current = DefaultElement.findNext(current, cl)) != null);
        return CollectionUtils.immutableList(children);
    }

    public <E extends DefaultElement> List<E> findRecursiveChildrenByClass(Class<E> cl) {
        ArrayList found = new ArrayList();
        this.searchRecursiveByClass(found, cl);
        return CollectionUtils.immutableList(found);
    }

    public void generateXml(@NotNull XmlWriter xml) throws IOException {
        if (xml == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/DefaultElement.generateXml must not be null");
        }
        xml.startElement(this.getTagName());
        this.generateXmlAttributes(xml);
        this.generateXmlNamespaces(xml);
        this.generateXmlElements(xml);
        xml.endElement();
    }

    public void info(String msg) {
        this.getXMLParser().info(msg);
    }

    public void reportWarning(String msg) {
        try {
            this.getXMLParser().warning(new SAXParseException(msg, null, null, this.getLine(), this.getColumn()));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public boolean isEmpty() {
        return !this.hasChilds() && !this.hasAttributes();
    }

    public String toString() {
        return String.valueOf(this.getTagName()) + this.getAttributes();
    }

    public boolean hasChilds() {
        return this.first != null;
    }

    public void verify() throws NoWellFormedContentException {
        for (DefaultElement e = this.getFirstElement(); e != null; e = e.getNextElement()) {
            e.verify();
        }
    }

    protected void generateXmlAttributes(XmlWriter xml) throws IOException {
        Map<QName, String> attributes = this.getAttributes();
        if (attributes != null) {
            for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                QName qname = entry.getKey();
                String name = qname.getLocalPart();
                xml.printAttribute(name, entry.getValue());
            }
        }
    }

    protected void generateXmlElements(XmlWriter xml) throws IOException {
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            element.generateXml(xml);
        }
    }

    protected void generateXmlNamespaces(XmlWriter xml) throws IOException {
        NamespaceContext nsContext = this.getNSContext();
        DefaultElement parent = this.getParent();
        if (parent == null || parent.getNSContext() != nsContext) {
            Map<String, Collection<String>> prefixByUri = nsContext.getPrefixesByUri();
            Set<Map.Entry<String, Collection<String>>> entries = prefixByUri.entrySet();
            for (Map.Entry<String, Collection<String>> entry : entries) {
                if (entry.getKey().length() <= 0) continue;
                String uri = entry.getKey();
                Collection<String> prefixes = entry.getValue();
                for (String prefix : prefixes) {
                    String name = "xmlns";
                    if (!prefix.equals("")) {
                        name = name + ":" + prefix;
                    }
                    xml.printAttribute(name, uri);
                }
            }
        }
    }

    protected void dump(IndentedPrintWriter out, boolean root, NamespaceContext currentCtx, String encoding) {
        this.dump(out, root, null, currentCtx, encoding);
    }

    protected void dump(IndentedPrintWriter out, boolean root, NamespaceContext currentCtx, String encoding, DumpParameters parameters) {
        this.dumpWrite(out, root, null, currentCtx, encoding, parameters);
    }

    protected void dump(IndentedPrintWriter out, boolean root, @Nullable String[] processingInstructions, NamespaceContext currentCtx, String encoding) {
        this.dumpWrite(out, root, processingInstructions, currentCtx, encoding, new DumpParameters());
    }

    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding, DumpParameters parameters) {
        this.dumpWrite(out, root, new String[]{Id.getFuegoProcessingInstructionLine()}, currentCtx, encoding, parameters);
    }

    protected void dumpWrite(IndentedPrintWriter out, boolean root, @Nullable String[] processingInstructions, NamespaceContext currentCtx, String encoding, DumpParameters parameters) {
        String uri;
        if (parameters == null) {
            parameters = new DumpParameters();
        }
        if (root) {
            out.print(Id.getXmlProcessingInstructionLine(encoding));
            if (processingInstructions != null) {
                for (String instruction : processingInstructions) {
                    out.print(instruction);
                }
            }
            this.printModifyWarningBlock(out);
            out.setIndentationString("    ");
        }
        NamespaceContext nsContext = this.getNSContext();
        String currentNs = this.getNamespace();
        String currentPrefix = nsContext.findPrefixByUri(currentNs);
        out.print('<');
        if (currentPrefix != null && !currentPrefix.equals("")) {
            out.print(currentPrefix);
            out.print(":");
        }
        assert (this.name != null) : "tag name is null for class '" + this.getClass().getName() + "'";
        out.print(this.name);
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        if (this.attributes != null) {
            for (Map.Entry<QName, String> entry : this.attributes.entrySet()) {
                String prefix;
                String value = entry.getValue();
                if (value == null) continue;
                out.print(' ');
                QName qname = entry.getKey();
                uri = qname.getNamespaceURI();
                String name = qname.getLocalPart();
                if (!"".equals(uri) && (prefix = nsContext.findPrefixByUri(uri)) != null) {
                    name = prefix + ":" + name;
                }
                out.print(name);
                out.print('=');
                out.print('\"');
                out.print(Str.toXMLString(value, encoder));
                out.print('\"');
            }
        }
        if (currentCtx != nsContext) {
            Set<Map.Entry<String, Object>> entries;
            if (root && parameters.isAddContextNamespaces()) {
                Map<String, String> prefixToUri = nsContext.getAllPrefixToUriMap();
                entries = prefixToUri.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    String prefix = entry.getKey();
                    String uri2 = (String)entry.getValue();
                    this.dumpNamespaceDeclaration(out, uri2, prefix);
                }
            } else {
                Map<String, Collection<String>> prefixByUri = nsContext.getPrefixesByUri();
                entries = prefixByUri.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    if (entry.getKey().length() <= 0) continue;
                    uri = entry.getKey();
                    Collection prefixes = (Collection)entry.getValue();
                    for (String prefix : prefixes) {
                        this.dumpNamespaceDeclaration(out, Str.toXMLString(uri, encoder), prefix);
                    }
                }
            }
        }
        if (this.getFirstElement() == null) {
            if (parameters.isPrintIndented()) {
                out.println("/>");
            } else {
                out.print("/>");
            }
        } else {
            if (parameters.isPrintIndented()) {
                out.println(">");
            } else {
                out.print(">");
            }
            if (parameters.isPrintIndented()) {
                out.indent();
            }
            for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
                current.dump(out, false, nsContext, encoding, parameters);
            }
            if (parameters.isPrintIndented()) {
                out.dedent();
            }
            out.print("</");
            if (currentPrefix != null && !currentPrefix.equals("")) {
                out.print(currentPrefix);
                out.print(":");
            }
            out.print(this.name);
            if (parameters.isPrintIndented()) {
                out.println(">");
            } else {
                out.print(">");
            }
        }
    }

    @Nullable
    private static <E extends DefaultElement> E findNext(@NotNull DefaultElement current, Class<E> cl) {
        if (current == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/DefaultElement.findNext must not be null");
        }
        return DefaultElement.findFirst(current.getNextElement(), cl);
    }

    @Nullable
    private static <E extends DefaultElement> E findFirst(@Nullable DefaultElement current, Class<E> cl) {
        while (current != null) {
            if (cl.isInstance(current)) {
                return (E)((DefaultElement)cl.cast(current));
            }
            current = current.getNextElement();
        }
        return null;
    }

    private <E extends DefaultElement> void searchRecursiveByClass(List<E> found, Class<E> cl) {
        for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
            if (cl.isInstance(current)) {
                found.add(cl.cast(current));
            }
            current.searchRecursiveByClass(found, cl);
        }
    }

    private void printModifyWarningBlock(@NotNull IndentedPrintWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/DefaultElement.printModifyWarningBlock must not be null");
        }
        writer.println("<!--########################################################################################-->");
        writer.println("<!--####                                                                                ####-->");
        writer.println("<!--####          THIS IS AN AUTO GENERATED FILE. PLEASE DO NOT MANUALLY MODIFY         ####-->");
        writer.println("<!--#### CHANGES TO THIS FILE MAY PRODUCE UNEXPECTED BEHAVIOR AND WOULD BE OVERWRITTEN  ####-->");
        writer.println("<!--####                                                                                ####-->");
        writer.println("<!--########################################################################################-->");
    }

    private void dumpNamespaceDeclaration(@NotNull IndentedPrintWriter out, String uri, String prefix) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/DefaultElement.dumpNamespaceDeclaration must not be null");
        }
        out.print(" xmlns");
        if (prefix != null && !prefix.equals("")) {
            out.print(":");
            out.print(prefix);
        }
        out.print("=\"" + uri + "\" ");
    }

    private boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public static class DumpParameters {
        private boolean addContextNamespaces;
        private boolean printIndented;

        public DumpParameters() {
            this(false, true);
        }

        public DumpParameters(boolean addContextNamespaces, boolean printIndented) {
            this.setAddContextNamespaces(addContextNamespaces);
            this.setPrintIndented(printIndented);
        }

        public boolean isPrintIndented() {
            return this.printIndented;
        }

        public void setPrintIndented(boolean printIndented) {
            this.printIndented = printIndented;
        }

        public boolean isAddContextNamespaces() {
            return this.addContextNamespaces;
        }

        public void setAddContextNamespaces(boolean addContextNamespaces) {
            this.addContextNamespaces = addContextNamespaces;
        }
    }
}

