/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.ParserContext;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidRootException;
import oracle.bpm.type.TypeIndex;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class WsdlParser
extends SchemaParser {
    private ParserContext parserContext;
    private Map<String, String> processInstruction;

    public WsdlParser(@NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlParser.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlParser.<init> must not be null");
        }
        super(fileSystem, typeFinder);
        super.setElementFactory(new WsdlElementFactory(this.getElementFactory()));
        this.parserContext = new ParserContext();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.processInstruction == null) {
            this.processInstruction = new HashMap<String, String>();
        }
        if (this.processInstruction.get(target) == null) {
            this.processInstruction.put(target, data);
        }
    }

    public ServiceDefinition parseDefinition(URL location, InputStream source) throws TypeParseException {
        DefaultElement root = (DefaultElement)super.parse(location, source);
        return WsdlParser.validateDefinition(location, root);
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ServiceDefinition parseDefinition(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlParser.parseDefinition must not be null");
        }
        ServiceDefinition def = this.getParserContext().getServiceDefinition(uri);
        if (def == null) {
            try {
                URL url = URLHelper.toUrl((URI)uri);
                InputStream source = URLHelper.openStream((URL)url);
                try {
                    def = this.parseDefinition(url, source);
                    this.getParserContext().addParsedWsdlFile(uri, def);
                    source.close();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(source);
                    throw throwable;
                }
                StreamUtils.close(source);
            }
            catch (IOException e) {
                throw new TypeParseException(uri, e);
            }
        }
        ServiceDefinition serviceDefinition = def;
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/WsdlParser.parseDefinition must not return null");
        }
        return serviceDefinition;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ServiceDefinition parseDefinition(URL location, String wsdl) throws TypeParseException {
        DefaultElement root = (DefaultElement)super.parse(location, wsdl);
        ServiceDefinition serviceDefinition = WsdlParser.validateDefinition(location, root);
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/WsdlParser.parseDefinition must not return null");
        }
        return serviceDefinition;
    }

    private static ServiceDefinition validateDefinition(URL location, DefaultElement root) throws TypeParseException {
        if (!(root instanceof ServiceDefinition)) {
            throw new InvalidRootException(location, root.getTagName());
        }
        ServiceDefinition def = (ServiceDefinition)root;
        def.setLocation(location);
        return def;
    }
}

