/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.project.catalog.parser.bpel20.BPEL20ElementFactory;
import oracle.bpm.project.catalog.parser.bpws.BPWSElementFactory;
import oracle.bpm.project.catalog.parser.wsdl.Binding;
import oracle.bpm.project.catalog.parser.wsdl.Documentation;
import oracle.bpm.project.catalog.parser.wsdl.ElementType;
import oracle.bpm.project.catalog.parser.wsdl.Fault;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.Part;
import oracle.bpm.project.catalog.parser.wsdl.Port;
import oracle.bpm.project.catalog.parser.wsdl.PortDefinition;
import oracle.bpm.project.catalog.parser.wsdl.Service;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.TypeDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.Parser;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import oracle.bpm.project.catalog.type.parser.BpmoBinding;
import oracle.bpm.project.catalog.type.parser.BpmoDelegate;
import oracle.bpm.project.catalog.type.parser.BpmoElementFactory;
import oracle.bpm.project.catalog.type.parser.BpmoOperation;
import oracle.bpm.project.catalog.type.parser.BpmoProperties;
import oracle.bpm.project.catalog.type.parser.BpmoScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Locator;

public class WsdlElementFactory
implements ElementFactory {
    private NamespaceContext context;
    private Locator locator;
    private Parser parser;
    private ElementFactory schemaFactory;
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    public WsdlElementFactory(ElementFactory factory) {
        this.schemaFactory = factory;
    }

    public static Binding createBinding(String name, String type, NamespaceContext parentContext) {
        Binding result = new Binding();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setName(name);
        result.setType(type);
        return result;
    }

    public static BpmoBinding createBpmoBindingWithType(String type, NamespaceContext parentContext) {
        BpmoBinding result = new BpmoBinding();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setType(type);
        return result;
    }

    public static BpmoBinding createBpmoBindingWithElement(String element, NamespaceContext parentContext) {
        BpmoBinding result = new BpmoBinding();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setElement(element);
        return result;
    }

    public static BpmoProperties createBpmoProperties(@NotNull Map<String, String> properties, @Nullable NamespaceContext parentContext) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlElementFactory.createBpmoProperties must not be null");
        }
        BpmoProperties result = new BpmoProperties();
        result.setNSContext(new NamespaceContext(parentContext));
        result.putAll(properties);
        return result;
    }

    public static Operation createOperation(String name, NamespaceContext parentContext) {
        Operation result = new Operation(name);
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        return result;
    }

    public static BpmoOperation createBpmoOperation(NamespaceContext parentContext) {
        BpmoOperation result = new BpmoOperation();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace("http://xmlns.oracle.com/bpm/bpmobject/");
        return result;
    }

    public static DefaultElement createBpmoScript(String language, NamespaceContext parentContext) {
        BpmoScript result = new BpmoScript();
        result.setNSContext(new NamespaceContext(parentContext));
        if (language != null) {
            result.setLanguage(language);
        }
        return result;
    }

    public static DefaultElement createInput(String name, NamespaceContext parentContext) {
        DefaultElement result = new DefaultElement();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setTagName("input");
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("name", name);
        return result;
    }

    public static DefaultElement createOutput(String name, NamespaceContext parentContext) {
        DefaultElement result = new DefaultElement();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setTagName("output");
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("name", name);
        return result;
    }

    public static DefaultElement createPortType(String name, NamespaceContext parentContext) {
        DefaultElement result = new DefaultElement();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setTagName("portType");
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("name", name);
        return result;
    }

    public static Input createInputMessage(String name, String message, NamespaceContext parentContext) {
        Input result = new Input();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("name", name);
        result.setMessage(message);
        return result;
    }

    public static Output createOutputMessage(String name, String message, NamespaceContext parentContext) {
        Output result = new Output();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("name", name);
        result.setMessage(message);
        return result;
    }

    public static Message createMessage(String name, NamespaceContext parentContext) {
        Message result = new Message();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setName(name);
        return result;
    }

    public static Part createPart(String name, String element, NamespaceContext parentContext) {
        Part result = new Part();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setName(name);
        result.setElement(element);
        return result;
    }

    public static Import createImport(String namespace, String location, NamespaceContext parentContext) {
        Import result = new Import();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setNamespace(WSDL_NAMESPACE);
        result.setImportedNamespace(namespace);
        result.setLocation(location);
        return result;
    }

    public static DefaultElement createTypes(NamespaceContext parentContext) {
        DefaultElement result = new DefaultElement();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setTagName("types");
        result.setNamespace(WSDL_NAMESPACE);
        return result;
    }

    public static DefaultElement createDefinitions(String targetNamespace, String name) {
        DefaultElement result = new DefaultElement();
        result.setTagName("definitions");
        result.setNamespace(WSDL_NAMESPACE);
        result.setAttribute("targetNamespace", targetNamespace);
        result.setAttribute("name", name);
        return result;
    }

    public static BpmoDelegate createBpmoDelegateForWsdlService(NamespaceContext parentContext, @NotNull String signature, @NotNull String delegatedNamespace, @NotNull String delegatedPortType) {
        if (signature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlElementFactory.createBpmoDelegateForWsdlService must not be null");
        }
        if (delegatedNamespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlElementFactory.createBpmoDelegateForWsdlService must not be null");
        }
        if (delegatedPortType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/WsdlElementFactory.createBpmoDelegateForWsdlService must not be null");
        }
        BpmoDelegate result = new BpmoDelegate();
        result.setNSContext(new NamespaceContext(parentContext));
        result.setMethodSignature(signature);
        result.setDelegatedWsdl(delegatedNamespace, delegatedPortType);
        return result;
    }

    @Override
    public void setContext(NamespaceContext ctx) {
        this.schemaFactory.setContext(ctx);
        this.context = ctx;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void setParser(Parser parser) {
        this.schemaFactory.setParser(parser);
        this.parser = parser;
    }

    @Override
    public Element create(String namespace, String name, Map<QName, String> attrs) {
        DefaultElement element = null;
        if (WSDL_NAMESPACE.equals(namespace)) {
            element = this.createWSDL(name);
        } else {
            if (namespace.endsWith("/XMLSchema")) {
                return this.schemaFactory.create(namespace, name, attrs);
            }
            if ("http://xmlns.oracle.com/bpm/bpmobject/".equals(namespace)) {
                element = BpmoElementFactory.createBpmo(name);
            } else if ("http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(namespace)) {
                element = BPWSElementFactory.createBpws(name);
            } else if ("http://docs.oasis-open.org/wsbpel/2.0/varprop".equals(namespace)) {
                element = BPEL20ElementFactory.createBpel20(name);
            }
        }
        if (element == null) {
            element = new WsdlElement();
        }
        if (this.locator == null) {
            this.locator = this.parser != null ? this.parser.getLocator() : null;
        }
        element.setTagName(name);
        element.setAttributes(attrs);
        element.setXMLParser(this.parser);
        element.setNamespace(namespace);
        element.setLine(this.locator.getLineNumber());
        element.setColumn(this.locator.getColumnNumber());
        element.setNSContext(this.context);
        return element;
    }

    @Override
    public Element createText(String text) {
        return new Text(text);
    }

    private WsdlElement createWSDL(String name) {
        WsdlElement element = null;
        int type = ElementType.findByName(name);
        switch (type) {
            case 0: {
                element = new Binding();
                break;
            }
            case 1: {
                element = new ServiceDefinition();
                break;
            }
            case 2: {
                element = new Documentation();
                break;
            }
            case 3: {
                element = new Fault();
                break;
            }
            case 4: {
                element = new Import();
                break;
            }
            case 5: {
                element = new Input();
                break;
            }
            case 6: {
                element = new Message();
                break;
            }
            case 8: {
                element = new Output();
                break;
            }
            case 7: {
                element = new Operation();
                break;
            }
            case 9: {
                element = new Part();
                break;
            }
            case 10: {
                element = new Port();
                break;
            }
            case 11: {
                element = new PortDefinition();
                break;
            }
            case 12: {
                element = new Service();
                break;
            }
            case 13: {
                element = new TypeDefinition();
            }
        }
        return element;
    }
}

