/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortDefinition
extends WsdlElement {
    @Nullable
    private List<Operation> operations;
    private WsdlTypeDescription type;

    PortDefinition() {
    }

    public WsdlTypeDescription getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Operation> getOperations() {
        List<Operation> result = this.operations;
        if (result == null) {
            this.operations = result = this.findChildrenByClass(Operation.class);
        }
        List<Object> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/PortDefinition.getOperations must not return null");
        }
        return list;
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        String name = this.getName();
        URL location = this.getServiceDefinition().getLocation();
        if (name == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("name", "portType"));
        }
        for (Operation operation : this.getOperations()) {
            operation.verify();
        }
        String overloadedOperarion = this.findOverloadedOperation();
        if (overloadedOperarion != null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.OP_OVERLOADED(overloadedOperarion));
        }
    }

    static String beautify(String name) {
        int index = name.lastIndexOf(46);
        if ((name = name.substring(index + 1)).endsWith("PortType") && name.length() > 8) {
            name = name.substring(0, name.length() - 8);
        }
        if (name.endsWith("Soap") && name.length() > 4) {
            name = name.substring(0, name.length() - "Soap".length());
        }
        if (name.endsWith("Port") && name.length() > 4) {
            name = name.substring(0, name.length() - "Port".length());
        }
        if (name.endsWith("service")) {
            name = name.substring(0, name.length() - "service".length());
        }
        if (name.endsWith("_ptt")) {
            name = name.substring(0, name.length() - "_ptt".length());
        }
        return Identifier.classname(name);
    }

    String getName() {
        return this.getAttribute("name");
    }

    Operation getOperation(String name) {
        return this.findByAttributeValue(this.getOperations(), "name", name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    WsdlTypeDescription buildPort() throws TypeBuildException {
        WsdlTypeDescription wsdlTypeDescription;
        if (this.type != null) {
            wsdlTypeDescription = this.type;
            if (wsdlTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/PortDefinition.buildPort must not return null");
            return wsdlTypeDescription;
        }
        ServiceDefinition serviceDef = this.getServiceDefinition();
        String namespace = serviceDef.getTargetNamespace();
        String location = URLHelper.getResourceLocation((URL)serviceDef.getLocation());
        String name = this.getName();
        this.type = WsdlTypeDescription.createForExternalXml((String)name, (String)namespace, (String)location);
        this.type.setName(PortDefinition.beautify(name));
        PortDefinition.addDefaultConstructor((ObjectTypeDescription)this.type);
        for (Operation operation : this.getOperations()) {
            MethodTypeDescription method = operation.buildMethod();
            method.addModifiers(64L);
            this.type.addMember(method);
        }
        wsdlTypeDescription = this.type;
        if (wsdlTypeDescription != null) return wsdlTypeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/PortDefinition.buildPort must not return null");
    }

    private static void addDefaultConstructor(ObjectTypeDescription type) {
        MethodTypeDescription defaultConstructor = type.createConstructor();
        defaultConstructor.setSignature("K");
        type.addMember(defaultConstructor);
    }

    private String findOverloadedOperation() {
        String overloadedOperation = null;
        ArrayList<String> operationsNames = new ArrayList<String>();
        for (Operation operation : this.getOperations()) {
            String name = operation.getName();
            if (!operationsNames.contains(name)) {
                operationsNames.add(name);
                continue;
            }
            overloadedOperation = name;
            break;
        }
        return overloadedOperation;
    }
}

