/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Part;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.ElementNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.Argument;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class Message
extends WsdlElement {
    private List<Argument> args;
    private List<Part> parts;

    public Message() {
        this.setTagName("message");
    }

    public List<Part> getParts() {
        if (this.parts == null) {
            this.parts = this.findChildrenByClass(Part.class);
        }
        return this.parts;
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        if (this.getName() == null) {
            URL location = this.getServiceDefinition().getLocation();
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("name", "message"));
        }
        for (Part part : this.getParts()) {
            part.verify();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<Argument> buildArguments() throws TypeBuildException {
        List<Argument> list;
        if (this.args != null) {
            ArrayList<Argument> copy = new ArrayList<Argument>(this.args.size());
            for (Argument arg : this.args) {
                copy.add(arg.copy());
            }
            list = copy;
            if (list == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Message.buildArguments must not return null");
            return list;
        }
        List<Part> parts = this.getParts();
        ArrayList<Argument> argList = new ArrayList<Argument>();
        for (Part part : parts) {
            Argument arg = part.buildArg();
            argList.add(arg);
        }
        this.setArgs(argList);
        list = this.args;
        if (list != null) return list;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Message.buildArguments must not return null");
    }

    void setArgs(List<Argument> args) {
        this.args = args;
    }

    void setName(String name) {
        this.setAttribute("name", name);
    }

    String getName() {
        return this.getAttribute("name");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    List<Argument> buildBpmObjectArguments() throws TypeBuildException {
        List<Argument> list;
        List<Part> parts = this.getParts();
        String elementName = parts.get(0).getElement();
        String prefix = this.prefix(elementName);
        Context context = this.getServiceDefinition().getContext();
        String namespace = context.getAllPrefixToUriMap().get(prefix);
        ExtendedNamespace extendedNamespace = (ExtendedNamespace)context.getDeclaredNamespaces().get(namespace);
        String localName = this.localname(elementName);
        try {
            SchemaElement elementDef = extendedNamespace.lookupElement(localName);
            ComplexType complex = (ComplexType)elementDef.getFirstElement();
            list = complex.buildBpmObjectArguments();
        }
        catch (ElementNotFoundException e) {
            throw TypeNotFoundException.wrap(e, (DefaultElement)this);
        }
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Message.buildBpmObjectArguments must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    AttributeTypeDescription buildExceptionAttribute() throws TypeBuildException {
        List<Argument> arguments = this.buildArguments();
        Argument argument = arguments.get(0);
        AttributeTypeDescription attribute = this.buildAttributeTypeDescription(0, argument, argument.getTypeRef(), false);
        attribute.setName("errorInfo");
        AttributeTypeDescription attributeTypeDescription = attribute;
        if (attributeTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Message.buildExceptionAttribute must not return null");
        }
        return attributeTypeDescription;
    }

    private AttributeTypeDescription buildAttributeTypeDescription(int pos, Argument argument, TypeRef resultTypeRef, boolean usePartsignature) {
        AttributeTypeDescription attribute = new AttributeTypeDescription(argument.getName(), resultTypeRef);
        String elementName = argument.getProperty("nativeName");
        String namespaceUri = argument.getProperty("nativeNamespace");
        Namespace elementNamespace = new Namespace(namespaceUri);
        TypeDescription resultType = null;
        if (resultTypeRef instanceof DynamicRef) {
            DynamicRef dynamicRef = (DynamicRef)resultTypeRef;
            TypeRef xmlTypeRef = this.getWSDLParser().getTypeFinder().findById(ComponentType.XML.getText(), dynamicRef.getId());
            if (xmlTypeRef != null) {
                resultType = xmlTypeRef.get();
            }
        } else {
            resultType = resultTypeRef.get();
        }
        if (resultType != null && resultType instanceof ObjectTypeDescription && !resultType.equals(XmlTypeHelper.XMLOBJECT) && !resultType.isUnknown()) {
            elementName = ((ObjectTypeDescription)resultType).getNativeName();
            namespaceUri = ((ObjectTypeDescription)resultType).getProperty("namespace");
            elementNamespace = new Namespace(namespaceUri);
        }
        ElementDef.setSignature(attribute, elementName, 1, elementNamespace, elementNamespace.getUri(), false, usePartsignature);
        attribute.setSignature(String.valueOf('@') + pos + ";" + attribute.getSignature());
        attribute.setWriteSignature(String.valueOf('@') + pos + ";" + attribute.getWriteSignature());
        attribute.setProperty("partName", argument.getName());
        attribute.setProperty("partPosition", Integer.toString(pos));
        return attribute;
    }
}

