/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.List;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Part;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.exception.MessageNotFoundException;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import org.jetbrains.annotations.NotNull;

public final class Fault
extends WsdlElement {
    private XmlTypeDescription object;

    @Override
    public void verify() throws NoWellFormedContentException {
        String name = this.getName();
        URL location = this.getServiceDefinition().getLocation();
        if (name == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("name", "fault"));
        }
        String message = this.getMessage();
        if (message == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("message", "fault"));
        }
    }

    String getMessage() {
        return this.getAttribute("message");
    }

    String getName() {
        return this.getAttribute("name");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    XmlTypeDescription buildException() throws TypeBuildException {
        String msgId = this.getMessage();
        ServiceDefinition service = this.getServiceDefinition();
        Message msg = service.getMessage(msgId);
        if (msg == null) {
            Operation operation = (Operation)this.getParent();
            throw new MessageNotFoundException(this, msgId, operation);
        }
        String msgNamespace = this.getContext().findNamespace(this.prefix(msgId)).getUri();
        String msgName = msg.getName();
        XmlTypeDescription faultType = this.buildFaultType(msgNamespace, msgName);
        AttributeTypeDescription atd = msg.buildExceptionAttribute();
        faultType.addMember((MethodTypeDescription)atd);
        faultType.setProperty("messageNamespace", msgNamespace);
        faultType.setProperty("message", msgName);
        Part part = this.getPart(msg);
        if (part != null) {
            String namespace = this.faultNamespace(msg);
            String type = this.faultType(msg);
            String objectType = XmlTypeHelper.buildSignature(type, namespace, false, false);
            faultType.setSignature(objectType);
            faultType.setProperty("partName", part.getName());
            for (MethodTypeDescription method : faultType.getPublicMethods()) {
                if (!method.isConstructor()) continue;
                String signature = method.getSignature();
                signature = 'L' + signature.substring(1);
                method.setSignature(signature);
            }
        }
        XmlTypeDescription xmlTypeDescription = faultType;
        if (xmlTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Fault.buildException must not return null");
        }
        return xmlTypeDescription;
    }

    private XmlTypeDescription buildFaultType(@NotNull String msgNamespace, @NotNull String msgName) {
        if (msgNamespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Fault.buildFaultType must not be null");
        }
        if (msgName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Fault.buildFaultType must not be null");
        }
        if (this.object == null) {
            String name = this.getName();
            ServiceDefinition service = this.getServiceDefinition();
            String targetNamespace = service.getTargetNamespace();
            String location = URLHelper.getResourceLocation((URL)service.getLocation());
            XmlTypeDescription objectType = XmlTypeHelper.createXmlTypeDescriptionForFault(name, targetNamespace, location, msgNamespace, msgName);
            objectType.setProperty("targetNamespace", targetNamespace);
            objectType.addModifier(262144L);
            this.object = objectType;
        }
        return this.object;
    }

    private String faultNamespace(Message msg) {
        ExtendedNamespace ns;
        String result = null;
        Part part = this.getPart(msg);
        Context context = part.getContext();
        String prefix = null;
        if (part.getType() != null) {
            prefix = this.prefix(part.getType());
        } else if (part.getElement() != null) {
            prefix = this.prefix(part.getElement());
        }
        if (!Str.isEmpty(prefix) && (ns = (ExtendedNamespace)context.findNamespace(prefix)) != null) {
            result = ns.getUri();
        }
        if (result == null) {
            ServiceDefinition service = this.getServiceDefinition();
            result = service.getTargetNamespace();
        }
        return result;
    }

    private String faultType(Message msg) {
        String result = null;
        Part part = this.getPart(msg);
        if (part.getType() != null) {
            String fullType;
            result = fullType = part.getType();
            if (fullType.indexOf(":") != -1) {
                result = fullType.substring(fullType.indexOf(":"));
            }
        } else if (part.getElement() != null) {
            String element = part.getElement();
            int index = 0;
            if (element.indexOf(":") != -1) {
                index = element.indexOf(":");
            }
            result = element.substring(1 + index);
        }
        assert (result != null) : "Name element can not be null";
        return result;
    }

    private Part getPart(Message msg) {
        Part result = null;
        List<Part> parts = msg.getParts();
        if (parts.size() > 1) {
            this.reportWarning("Fault element must only have one part.");
        }
        if (parts.size() != 0) {
            result = parts.get(0);
        }
        return result;
    }
}

