/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.DummyParsedObject;
import oracle.bpm.project.catalog.loaders.impl.SchemaParsedObject;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.utils.NotificationServiceHelper;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.XML_SCHEMA, isStructural=true, requiresUniqueNodeSuffix=true)
public final class XsdTypeLoader
extends AbstractTypeLoader<Schema> {
    public XsdTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Map<String, TypeDescription> preBuildTypes(@NotNull URI uri, @NotNull Schema schema) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.preBuildTypes must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.preBuildTypes must not be null");
        }
        SchemaParser parser = (SchemaParser)schema.getXMLParser();
        parser.setTwoPassBuild(true);
        Map<String, TypeDescription> map = XsdTypeLoader.buildTypes(uri, schema);
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.preBuildTypes must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Map<String, TypeDescription> buildTypes(@NotNull URI uri, @NotNull Schema schema) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not be null");
        }
        Hashtable<String, TypeDescription> result = new Hashtable<String, TypeDescription>();
        schema.declare();
        schema.buildType(null);
        ExtendedNamespace target = schema.getContext().getTarget();
        String module = XmlUtils.getExtModuleFromNamespace((String)target.getUri());
        URL location = XsdTypeLoader.uriToUrl(uri);
        String relativePath = URLHelper.getResourceLocation((URL)location);
        Map<String, TypeDescription> elements = XsdTypeLoader.validTypesByName(target.getDefinedElements(), result, module, location, relativePath);
        result.putAll(elements);
        Map<String, TypeDescription> types = XsdTypeLoader.validTypesByName(target.getAllDefinedTypes(), result, module, location, relativePath);
        result.putAll(types);
        Map<String, TypeDescription> attributes = XsdTypeLoader.validTypesByName(target.getAllDefinedAttributes(), result, module, location, relativePath);
        result.putAll(attributes);
        Map<String, TypeDescription> attGroup = XsdTypeLoader.validTypesByName(target.getAllDefinedAttributeGroups(), result, module, location, relativePath);
        result.putAll(attGroup);
        Map<String, TypeDescription> groups = XsdTypeLoader.validTypesByName(target.getAllDefinedGroups(), result, module, location, relativePath);
        result.putAll(groups);
        Hashtable<String, TypeDescription> hashtable = result;
        if (hashtable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not return null");
        }
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ParsedObject<Schema> parseUri(@NotNull URI uri) throws TypeParseException {
        ParsedObject parsedObject;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.parseUri must not be null");
        }
        SchemaParser parser = this.buildSchemaParser();
        Schema schema = parser.parse(uri);
        schema.verify();
        if (NotificationServiceHelper.NOTIFICATION_SERVICE_NAMESPACE.equals(schema.getTargetNamespace()) && !"oramds".equals(uri.getScheme())) {
            parsedObject = new DummyParsedObject<Schema>(uri, schema);
            if (parsedObject == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.parseUri must not return null");
            return parsedObject;
        }
        parsedObject = new SchemaParsedObject(uri, schema);
        if (parsedObject != null) return parsedObject;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.parseUri must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<Schema> parsedObject) throws TypeBuildException {
        Set<SchemaElement> pendingElements;
        Map<String, TypeDescription> map;
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadTypes must not be null");
        }
        Schema schema = parsedObject.getParsedData();
        if (ExtendedNamespace.isBuiltin(schema.getTargetNamespace())) {
            map = Collections.emptyMap();
            if (map == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadTypes must not return null");
            return map;
        }
        SchemaParser parser = (SchemaParser)schema.getXMLParser();
        if (parser.isTwoPassBuild()) {
            parser.setSecondPass(true);
        }
        if (!(pendingElements = parser.getPendingElementsBuild()).isEmpty()) {
            for (SchemaElement element : pendingElements) {
                XsdTypeLoader.resetBuiltType(element, false);
            }
        }
        if ((map = XsdTypeLoader.buildTypes(parsedObject.getUri(), schema)) != null) return map;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadTypes must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected Map<String, TypeDescription> loadPreBuilTTypes(@NotNull ParsedObject<Schema> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadPreBuilTTypes must not be null");
        }
        Schema schema = parsedObject.getParsedData();
        Map<String, TypeDescription> map = XsdTypeLoader.preBuildTypes(parsedObject.getUri(), schema);
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadPreBuilTTypes must not return null");
        }
        return map;
    }

    private static void resetBuiltType(@NotNull SchemaElement element, boolean resetNext) {
        SchemaElement first;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.resetBuiltType must not be null");
        }
        element.setTypeDescription(null);
        if (resetNext) {
            for (SchemaElement next = element.getNext(); next != null; next = next.getNext()) {
                XsdTypeLoader.resetBuiltType(next, false);
            }
        }
        if ((first = element.getFirst()) != null) {
            XsdTypeLoader.resetBuiltType(first, true);
        }
    }

    private static Map<String, TypeDescription> validTypesByName(@NotNull List<TypeDescription> origin, @NotNull Map<String, TypeDescription> existent, @NotNull String module, @NotNull URL location, @NotNull String relativePath) {
        if (origin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.validTypesByName must not be null");
        }
        if (existent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.validTypesByName must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.validTypesByName must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.validTypesByName must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.validTypesByName must not be null");
        }
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        Collections.sort(origin, new Comparator<TypeDescription>(){

            @Override
            public int compare(TypeDescription o1, TypeDescription o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
        for (TypeDescription type : origin) {
            String validName;
            if (!type.isXmlObject() && !type.isEnum()) continue;
            String name = module + "." + type.getText();
            if (!name.equals(validName = XsdTypeLoader.getValidName(existent, name))) {
                type.asObject().setName(TypeUtils.shortName((String)validName));
            }
            result.put(validName, type);
            Utils.fixResourceLocation(location, relativePath, type);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getValidName(@NotNull Map<String, TypeDescription> elements, @NotNull String originalName) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not be null");
        }
        if (originalName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not be null");
        }
        String name = originalName;
        if (elements.containsKey(name)) {
            String nameType;
            name = nameType = originalName + "Type";
            int i = 2;
            while (elements.containsKey(name)) {
                name = nameType + i;
                ++i;
            }
        }
        String string = name;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private SchemaParser buildSchemaParser() {
        SchemaParser parser = new SchemaParser(this.getFileSystem(), this.typeFinder);
        parser.setCatalog(this.getCatalog());
        SchemaParser schemaParser = parser;
        if (schemaParser == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildSchemaParser must not return null");
        }
        return schemaParser;
    }
}

