/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.ServiceDefinitionParsedObject;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.TypeDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.WsdlParser;
import oracle.bpm.project.catalog.parser.xmlparser.ParserContext;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.exception.UriConversionException;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.WSDL, isStructural=true, rootModules={"Services"}, requiresUniqueNodeSuffix=true)
public class WsdlTypeLoader
extends AbstractTypeLoader<ServiceDefinition> {
    public WsdlTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<ObjectTypeDescription> collectDefinedTypes(@NotNull ExtendedNamespace enspace, @NotNull URI sourceLocation) throws UriConversionException {
        if (enspace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.collectDefinedTypes must not be null");
        }
        if (sourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.collectDefinedTypes must not be null");
        }
        ArrayList<ObjectTypeDescription> result = new ArrayList<ObjectTypeDescription>();
        Map<String, TypeDescription> definedElements = enspace.getDefinedElementsByName();
        for (Map.Entry<String, TypeDescription> entry : definedElements.entrySet()) {
            TypeDescription type = entry.getValue();
            if (!type.isObject() && !type.isEnum()) continue;
            ObjectTypeDescription otd = (ObjectTypeDescription)type;
            WsdlTypeLoader.fixResourceLocation(otd, sourceLocation);
            otd.setProperty("wsdl.inline.object", Boolean.TRUE.toString());
            result.add(otd);
        }
        Map<String, TypeDescription> definedTypes = enspace.getDefinedTypesByName();
        for (Map.Entry<String, TypeDescription> entry : definedTypes.entrySet()) {
            TypeDescription type = entry.getValue();
            if (!type.isObject() && !type.isEnum()) continue;
            ObjectTypeDescription otd = (ObjectTypeDescription)type;
            WsdlTypeLoader.fixResourceLocation(otd, sourceLocation);
            otd.setProperty("wsdl.inline.object", Boolean.TRUE.toString());
            result.add(otd);
        }
        ArrayList<ObjectTypeDescription> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.collectDefinedTypes must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ParsedObject<ServiceDefinition> parseUri(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.parseUri must not be null");
        }
        WsdlParser parser = new WsdlParser(this.getFileSystem(), this.typeFinder);
        parser.setCatalog(this.getCatalog());
        ServiceDefinition definition = parser.parseDefinition(uri);
        definition.verify();
        ServiceDefinitionParsedObject serviceDefinitionParsedObject = this.buildParsedObject(uri, definition);
        if (serviceDefinitionParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.parseUri must not return null");
        }
        return serviceDefinitionParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<ServiceDefinition> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.loadTypes must not be null");
        }
        ServiceDefinition serviceDefinition = parsedObject.getParsedData();
        Map<String, TypeDescription> map = this.buildTypes(parsedObject.getUri(), serviceDefinition);
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.loadTypes must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<String, TypeDescription> buildTypes(@NotNull URI uri, @NotNull ServiceDefinition def) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildTypes must not be null");
        }
        if (def == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildTypes must not be null");
        }
        Hashtable<String, TypeDescription> result = new Hashtable<String, TypeDescription>();
        String targetNamespace = def.getTargetNamespace();
        String moduleName = XmlUtils.getExtModuleFromNamespace((String)targetNamespace);
        Map<ObjectTypeDescription, WsdlElement> ptTypes = def.buildTypesFromPortTypes(new ParserContext());
        for (ObjectTypeDescription otd : ptTypes.keySet()) {
            WsdlTypeDescription wsdlTypeDescription = (WsdlTypeDescription)otd;
            if (!WsdlTypeLoader.sameLocation(uri, wsdlTypeDescription.getLocation())) continue;
            this.addTypeToList(result, otd, moduleName);
        }
        TypeDefinition typeDef = def.getTypeDef();
        if (typeDef != null) {
            List<Schema> schemas = typeDef.getSchemas();
            for (Schema schema : schemas) {
                String schemaNamespace = schema.getTargetNamespace();
                Context context = schema.getContext();
                ExtendedNamespace ns = (ExtendedNamespace)context.findNamespaceByUri(schemaNamespace);
                if (ns == null) continue;
                List<ObjectTypeDescription> definedTypes = WsdlTypeLoader.collectDefinedTypes(ns, uri);
                for (ObjectTypeDescription type : definedTypes) {
                    SchemaObject schemaObject = type.asSchemaObject();
                    if (!WsdlTypeLoader.sameLocation(uri, schemaObject.getLocation())) continue;
                    String module = XmlUtils.getExtModuleFromNamespace((String)ns.getUri());
                    this.addTypeToList(result, type, module);
                }
            }
        }
        for (XmlTypeDescription exception : def.getFaults()) {
            this.addTypeToList(result, (ObjectTypeDescription)exception, moduleName);
        }
        Hashtable<String, TypeDescription> hashtable = result;
        if (hashtable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildTypes must not return null");
        }
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected ServiceDefinitionParsedObject buildParsedObject(@NotNull URI uri, @NotNull ServiceDefinition definition) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildParsedObject must not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildParsedObject must not be null");
        }
        ServiceDefinitionParsedObject serviceDefinitionParsedObject = new ServiceDefinitionParsedObject(uri, definition);
        if (serviceDefinitionParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.buildParsedObject must not return null");
        }
        return serviceDefinitionParsedObject;
    }

    private static void fixResourceLocation(@NotNull ObjectTypeDescription otd, @NotNull URI uri) throws UriConversionException {
        String location;
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.fixResourceLocation must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.fixResourceLocation must not be null");
        }
        URL url = WsdlTypeLoader.uriToUrl(uri);
        Object transientProperty = otd.getTransientProperty("resource_location");
        String string = location = transientProperty != null ? (String)transientProperty : null;
        if (location == null) {
            if ("vfile".equals(url.getProtocol())) {
                String relativePath = URLHelper.getResourceLocation((URL)url);
                VFile vFile = VFileURLConnection.get((URL)url);
                assert (vFile != null) : "Could not load vFile resource:" + url;
                otd.setTransientProperty("resource_location", (Object)relativePath);
                otd.setTransientProperty("files", (Object)new VFile[]{vFile});
            } else {
                otd.setTransientProperty("resource_location", (Object)url.toString());
            }
        }
    }

    private static boolean sameLocation(URI uri, String location) {
        return uri.toASCIIString().contains(URI.create(location).toASCIIString());
    }

    private void addTypeToList(@NotNull Map<String, TypeDescription> result, @NotNull ObjectTypeDescription type, @NotNull String module) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        String typeName = module + "." + type.getName();
        this.addTypeToList(result, type, typeName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypeToList(@NotNull Map<String, TypeDescription> result, @NotNull ObjectTypeDescription type, @NotNull String typeName, boolean renameUsingType) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/WsdlTypeLoader.addTypeToList must not be null");
        }
        type.setProperty("wsdl.inline.object", Boolean.TRUE.toString());
        String newTypeName = typeName;
        TypeDescription existingTd = result.get(newTypeName);
        boolean skip = false;
        if (existingTd != null) {
            if (existingTd == type) {
                return;
            }
            if (existingTd.equals(type)) {
                if (existingTd.isObject()) {
                    ObjectTypeDescription newOtd;
                    ObjectTypeDescription existingOtd = existingTd.asObject();
                    boolean membersMatch = TypeUtils.compareObjectMembers((ObjectTypeDescription)existingOtd, (ObjectTypeDescription)(newOtd = type.asObject()), (boolean)true);
                    if (!membersMatch) throw new IllegalStateException("Tried to add 2 objects '" + existingOtd + "' that have different members");
                    return;
                }
                newTypeName = Utils.buildFreeName(result.keySet(), typeName);
            } else {
                if (renameUsingType && type instanceof XmlTypeDescription) {
                    XmlTypeDescription xmlOtd = (XmlTypeDescription)type;
                    newTypeName = typeName + xmlOtd.getXmlElementType().getSuffix();
                    type.setName(TypeUtils.shortName((String)newTypeName));
                    this.addTypeToList(result, type, newTypeName, false);
                    return;
                }
                newTypeName = Utils.buildFreeName(result.keySet(), typeName);
            }
        }
        if (skip) return;
        if (!newTypeName.equals(typeName)) {
            type.setName(TypeUtils.shortName((String)newTypeName));
        }
        result.put(newTypeName, (TypeDescription)type);
        if (!type.isObject()) return;
        ObjectTypeDescription otd = type.asObject();
        Iterator i$ = otd.getInnerTypeRefs().iterator();
        while (i$.hasNext()) {
            TypeRef ref = (TypeRef)i$.next();
            this.addTypeToList(result, ref.get().asObject(), newTypeName);
        }
    }
}

