/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class TaskDefinitionParsedObject
extends ParsedObject<TaskDefinition> {
    private Set<Dependency> dependencies;
    private static final String SCHEMA_LOCATION_TAG = "schemaLocation";
    private static final QName IMPORT_TAG = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName INCLUDE_TAG = new QName("http://www.w3.org/2001/XMLSchema", "include");

    public TaskDefinitionParsedObject(@NotNull URI uri, @NotNull TaskDefinition parsedData) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/TaskDefinitionParsedObject.<init> must not be null");
        }
        if (parsedData == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/TaskDefinitionParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDependencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/TaskDefinitionParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static Collection<URI> collectDependencies(@NotNull URI xsdFile) {
        if (xsdFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/TaskDefinitionParsedObject.collectDependencies must not be null");
        }
        TreeSet<URI> result = new TreeSet<URI>();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            InputStream is = URLHelper.toUrl((URI)xsdFile).openStream();
            try {
                XMLStreamReader sr = inputFactory.createXMLStreamReader(is);
                int eventCode = sr.next();
                while (sr.hasNext()) {
                    if (eventCode == 1 && (IMPORT_TAG.equals(sr.getName()) || INCLUDE_TAG.equals(sr.getName()))) {
                        for (int i = 0; i < sr.getAttributeCount(); ++i) {
                            if (!sr.getAttributeLocalName(i).equals(SCHEMA_LOCATION_TAG)) continue;
                            String importedXsdPath = sr.getAttributeValue(i);
                            URI importedXsdUri = xsdFile.resolve(importedXsdPath);
                            result.add(importedXsdUri);
                        }
                    }
                    eventCode = sr.next();
                }
                is.close();
            }
            catch (Throwable throwable) {
                StreamUtils.close(is);
                throw throwable;
            }
            StreamUtils.close(is);
        }
        catch (Exception e) {
            System.err.println("Payload could not be loaded:" + xsdFile);
        }
        TreeSet<URI> treeSet = result;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/TaskDefinitionParsedObject.collectDependencies must not return null");
        }
        return treeSet;
    }

    private Set<Dependency> parseDependencies() throws TypeParseException {
        String schemaDefinition;
        TreeSet<Dependency> result = new TreeSet<Dependency>();
        URI uri = this.getUri();
        TaskDefinition data = (TaskDefinition)this.getParsedData();
        WorkflowConfigurationType workflowConfiguration = data.getWorkflowConfiguration();
        PayloadType payload = workflowConfiguration != null ? workflowConfiguration.getPayload() : null;
        String string = schemaDefinition = payload != null ? payload.getXmlSchemaDefinition() : null;
        if (!Str.isEmpty(schemaDefinition)) {
            URI payloadXsd = uri.resolve(schemaDefinition);
            Collection<URI> importedXsds = TaskDefinitionParsedObject.collectDependencies(payloadXsd);
            for (URI importedXsd : importedXsds) {
                result.add(new Dependency(importedXsd, ResourceType.XML_SCHEMA));
            }
        }
        return result;
    }
}

