/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.TypeDescriptionParsedObject;
import oracle.bpm.project.catalog.parser.xsd.exception.UriConversionException;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.MUTABLE_MODULE, isStructural=false)
public final class ModuleTypeLoader
extends AbstractTypeLoader<TypeDescription> {
    public ModuleTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ParsedObject<TypeDescription> parseUri(@NotNull URI uri) throws TypeParseException {
        TypeDescription module;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.parseUri must not be null");
        }
        try {
            VFile vfile = this.uriToVFile(uri);
            module = this.createModuleTypeByUri(vfile);
        }
        catch (UriConversionException e) {
            throw TypeParseException.wrap(e);
        }
        TypeDescriptionParsedObject typeDescriptionParsedObject = new TypeDescriptionParsedObject(uri, module);
        if (typeDescriptionParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.parseUri must not return null");
        }
        return typeDescriptionParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<TypeDescription> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.loadTypes must not be null");
        }
        TypeDescription module = parsedObject.getParsedData();
        VFile vfile = this.uriToVFile(parsedObject.getUri());
        String typeName = Utils.getTypeName(vfile, "businessCatalog");
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        result.put(typeName, module);
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription createModuleTypeByUri(@NotNull VFile vfile) {
        if (vfile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.createModuleTypeByUri must not be null");
        }
        String name = Identifier.classname(vfile.getName());
        ObjectTypeDescription result = new ObjectTypeDescription(name);
        result.setComponentType(ComponentType.OBJECT.getText());
        result.addModifier(0x2000000000000L);
        ObjectTypeDescription objectTypeDescription = result;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/ModuleTypeLoader.createModuleTypeByUri must not return null");
        }
        return objectTypeDescription;
    }
}

